/*
 * Decompiled with CFR 0.152.
 */
package com.goby56.wakes;

import com.goby56.wakes.config.WakesConfig;
import com.goby56.wakes.debug.DebugCommand;
import com.goby56.wakes.debug.WakeDebugRenderer;
import com.goby56.wakes.event.PickBoat;
import com.goby56.wakes.event.WakeTicker;
import com.goby56.wakes.particle.ModParticles;
import com.goby56.wakes.render.SplashPlaneRenderer;
import com.goby56.wakes.render.WakeRenderer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.event.client.player.ClientPickBlockGatherCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.irisshaders.iris.api.v0.IrisApi;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import org.ladysnake.satin.api.managed.ManagedCoreShader;
import org.ladysnake.satin.api.managed.ShaderEffectManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WakesClient
implements ClientModInitializer {
    public static final String MOD_ID = "wakes";
    public static ModMetadata METADATA;
    public static final String CONFIG_PATH;
    public static final Logger LOGGER;
    public static WakesConfig CONFIG_INSTANCE;
    public static final ManagedCoreShader TRANSLUCENT_NO_LIGHT_DIRECTION_PROGRAM;
    public static boolean areShadersEnabled;

    public void onInitializeClient() {
        FabricLoader.getInstance().getModContainer(MOD_ID).ifPresent(container -> {
            METADATA = container.getMetadata();
        });
        CONFIG_INSTANCE = WakesConfig.loadConfig();
        ModParticles.registerParticles();
        ClientTickEvents.END_WORLD_TICK.register((Object)new WakeTicker());
        ClientPickBlockGatherCallback.EVENT.register((Object)new PickBoat());
        WorldRenderEvents.AFTER_TRANSLUCENT.register((Object)new WakeRenderer());
        WorldRenderEvents.BEFORE_DEBUG_RENDER.register((Object)new WakeDebugRenderer());
        ClientLifecycleEvents.CLIENT_STARTED.register((Object)new SplashPlaneRenderer());
        ClientCommandRegistrationCallback.EVENT.register(DebugCommand::register);
    }

    public static boolean isYACLLoaded() {
        return FabricLoader.getInstance().isModLoaded("yet_another_config_lib_v3");
    }

    public static boolean areShadersEnabled() {
        if (FabricLoader.getInstance().isModLoaded("iris")) {
            return IrisApi.getInstance().getConfig().areShadersEnabled();
        }
        return false;
    }

    static {
        CONFIG_PATH = String.format("%s/%s.json", FabricLoader.getInstance().getConfigDir().toString(), MOD_ID);
        LOGGER = LoggerFactory.getLogger((String)MOD_ID);
        TRANSLUCENT_NO_LIGHT_DIRECTION_PROGRAM = ShaderEffectManager.getInstance().manageCoreShader(class_2960.method_60655((String)MOD_ID, (String)"translucent_no_light_direction"), class_290.field_1580);
        areShadersEnabled = false;
    }
}

