/*
 * Decompiled with CFR 0.152.
 */
package com.goby56.wakes.render.enums;

import com.goby56.wakes.WakesClient;
import com.goby56.wakes.config.WakesConfig;
import net.minecraft.class_3542;

public enum WakeColor implements class_3542
{
    TRANSPARENT(0, 0, 0, 0),
    DARK_GRAY(147, 153, 166, 40),
    GRAY(158, 165, 176, 100),
    LIGHT_GRAY(196, 202, 209, 180),
    WHITE(255, 255, 255, 255),
    RED(189, 42, 42, 255),
    ORANGE(214, 111, 51, 255),
    YELLOW(227, 225, 84, 255),
    GREEN(115, 189, 42, 255),
    CAMO(8, 135, 57, 255),
    TURQUOISE(42, 189, 140, 255),
    BLUE(65, 51, 214, 255),
    PURPLE(149, 51, 214, 255),
    PINK(214, 51, 192, 255);

    public final int abgr;

    private WakeColor(int red, int green, int blue, int alpha) {
        this.abgr = alpha << 24 | blue << 16 | green << 8 | red;
    }

    private int blend(int waterColor, int lightColor, float opacity, boolean isWhite) {
        float srcA = (float)(this.abgr >>> 24 & 0xFF) / 255.0f;
        int a = (int)(opacity * 255.0f * srcA);
        int b = 255;
        int g = 255;
        int r = 255;
        if (!isWhite) {
            b = (int)((float)(this.abgr >> 16 & 0xFF) * (1.0f - srcA) + (float)(waterColor & 0xFF) * srcA);
            g = (int)((float)(this.abgr >> 8 & 0xFF) * (1.0f - srcA) + (float)(waterColor >> 8 & 0xFF) * srcA);
            r = (int)((float)(this.abgr & 0xFF) * (1.0f - srcA) + (float)(waterColor >> 16 & 0xFF) * srcA);
        }
        b = (int)((double)b * WakeColor.invertedLogisticCurve((float)(lightColor >> 16 & 0xFF) / 255.0f));
        g = (int)((double)g * WakeColor.invertedLogisticCurve((float)(lightColor >> 8 & 0xFF) / 255.0f));
        r = (int)((double)r * WakeColor.invertedLogisticCurve((float)(lightColor & 0xFF) / 255.0f));
        return a << 24 | b << 16 | g << 8 | r;
    }

    private static double invertedLogisticCurve(float x) {
        float k = WakesClient.CONFIG_INSTANCE.shaderLightPassthrough;
        return WakesClient.areShadersEnabled ? (double)k * (4.0 * Math.pow(x - 0.5f, 3.0) + 0.5) : (double)x;
    }

    public static int getColor(float waveEqAvg, int waterColor, int lightColor, float opacity) {
        double clampedRange = 100.0 / (1.0 + Math.exp(-0.1 * (double)waveEqAvg)) - 50.0;
        for (WakesConfig.ColorInterval interval : WakesClient.CONFIG_INSTANCE.colorIntervals) {
            if (!((double)interval.lower <= clampedRange) || !(clampedRange <= (double)interval.upper)) continue;
            return interval.color.blend(waterColor, lightColor, opacity, interval.color == WHITE);
        }
        return WakeColor.TRANSPARENT.abgr;
    }

    public String method_15434() {
        return this.name().toLowerCase();
    }
}

