/*
 * Decompiled with CFR 0.152.
 */
package net.dungeon_difficulty.config;

import java.util.List;
import java.util.Random;

public class Config {
    public Meta meta = new Meta(this);
    public PerPlayerDifficulty perPlayerDifficulty;
    public DifficultyType[] difficulty_types;
    public Dimension[] dimensions;

    public class Meta {
        public String comment = "IMPORTANT! Make sure to set `allow_customization` to `true` to allow customization of the config";
        public boolean allow_customization = false;
        public boolean sanitize_config = true;
        public Double rounding_unit = 0.5;

        public Meta(Config this$0) {
        }
    }

    public static class SpawnerModifier {
        public float spawn_range_multiplier = 0.0f;
        public float spawn_count_multiplier = 0.0f;
        public float max_nearby_entities_multiplier = 0.0f;
        public float min_spawn_delay_multiplier = 0.0f;
        public float max_spawn_delay_multiplier = 0.0f;
        public float required_player_range_multiplier = 0.0f;
    }

    public static class AttributeModifier {
        public String attribute;
        public Operation operation = Operation.MULTIPLY_BASE;
        public float randomness = 0.0f;
        public float value = 0.0f;
        private static Random rng = new Random();

        public AttributeModifier() {
        }

        public AttributeModifier(String attribute, float value) {
            this.attribute = attribute;
            this.value = value;
        }

        public float randomizedValue(int level) {
            float value = this.value * (float)level;
            return this.randomness > 0.0f ? rng.nextFloat(value - this.randomness, value + this.randomness) : value;
        }
    }

    public static class ItemModifier {
        public Filters item_matches = new Filters();
        public AttributeModifier[] attributes = new AttributeModifier[0];

        public static class Filters {
            public String item_id_regex = ".*";
            public String loot_table_regex = ".*";
            public String rarity_regex = ".*";
        }
    }

    public static class Rewards {
        public List<ItemModifier> armor = List.of();
        public List<ItemModifier> weapons = List.of();
    }

    public static class EntityModifier {
        public Filters entity_matches = new Filters();
        public AttributeModifier[] attributes = new AttributeModifier[0];
        public SpawnerModifier spawners = null;
        public float experience_multiplier = 0.0f;

        public static class Filters {
            public Attitude attitude = Attitude.ANY;
            public String entity_id_regex = ".*";

            public static enum Attitude {
                FRIENDLY,
                HOSTILE,
                ANY;

            }
        }
    }

    public static enum Operation {
        ADDITION,
        MULTIPLY_BASE;

    }

    public static class Zone {
        public Filters zone_matches = new Filters();
        public DifficultyReference difficulty;

        public static class Filters {
            public String biome = ".*";
            public String structure = null;
        }
    }

    public static class Dimension {
        public Filters world_matches = new Filters();
        public DifficultyReference difficulty;
        public Zone[] zones = new Zone[0];

        public static class Filters {
            public String dimension_regex = ".*";
        }
    }

    public static class DifficultyReference {
        public String name;
        public int level = 0;

        public DifficultyReference() {
        }

        public DifficultyReference(String name, int level) {
            this.name = name;
            this.level = level;
        }
    }

    public static class DifficultyType {
        public String name;
        public String parent;
        public List<EntityModifier> entities = List.of();
        public Rewards rewards = new Rewards();

        public DifficultyType() {
        }

        public DifficultyType(String name) {
            this.name = name;
        }
    }

    public static class PerPlayerDifficulty {
        public boolean enabled = true;
        public Counting counting = Counting.EVERYWHERE;
        public EntityModifier[] entities = new EntityModifier[0];

        public static enum Counting {
            EVERYWHERE,
            DIMENSION;

        }
    }
}

