/*
 * Decompiled with CFR 0.152.
 */
package net.dungeon_difficulty.config;

import java.util.List;
import net.dungeon_difficulty.DungeonDifficulty;
import net.dungeon_difficulty.config.Config;
import net.fabricmc.loader.api.FabricLoader;

public class Default {
    public static Config config = Default.createDefaultConfig();

    private static Config createDefaultConfig() {
        Config.DifficultyType normalDifficulty = new Config.DifficultyType("normal");
        normalDifficulty.entities = List.of(Default.createEntityModifier(".*", new Config.AttributeModifier[]{Default.createDamageMultiplier(0.25f, 0.0f), Default.createArmorBonus(1.0f), Default.createHealthMultiplier(0.25f, 0.1f)}, null, 0.2f));
        Config.DifficultyType dungeonDifficulty = new Config.DifficultyType("dungeon");
        dungeonDifficulty.parent = normalDifficulty.name;
        Config.SpawnerModifier dungeonSpawners = new Config.SpawnerModifier();
        dungeonSpawners = new Config.SpawnerModifier();
        dungeonSpawners.min_spawn_delay_multiplier = -0.1f;
        dungeonSpawners.max_spawn_delay_multiplier = -0.1f;
        dungeonSpawners.spawn_count_multiplier = 0.5f;
        dungeonSpawners.max_nearby_entities_multiplier = 1.0f;
        dungeonDifficulty.entities = List.of(Default.createEntityModifier(".*", new Config.AttributeModifier[0], dungeonSpawners, 0.0f));
        dungeonDifficulty.rewards.armor = List.of(Default.createItemModifier(new Config.AttributeModifier[]{Default.createArmorMultiplier(0.1f), Default.createHealthBonus(1.0f)}));
        dungeonDifficulty.rewards.weapons = List.of(Default.createItemModifier(new Config.AttributeModifier[]{Default.createDamageMultiplier(0.15f, 0.05f), Default.createPowerMultiplier(0.15f, 0.05f)}));
        Config.PerPlayerDifficulty perPlayerDifficulty = new Config.PerPlayerDifficulty();
        Config.EntityModifier perPlayerEntityModifier = new Config.EntityModifier();
        perPlayerEntityModifier.entity_matches.entity_id_regex = ".*";
        if (FabricLoader.getInstance().isModLoaded("the_bumblezone")) {
            perPlayerEntityModifier.entity_matches.entity_id_regex = "^(?!the_bumblezone:cosmic_crystal_entity).*$";
        }
        perPlayerEntityModifier.attributes = new Config.AttributeModifier[]{Default.createDamageMultiplier(0.2f, 0.0f), Default.createHealthMultiplier(0.2f, 0.0f)};
        perPlayerDifficulty.entities = new Config.EntityModifier[]{perPlayerEntityModifier};
        Config.Dimension overworld = new Config.Dimension();
        overworld.world_matches.dimension_regex = "minecraft:overworld";
        overworld.zones = new Config.Zone[]{Default.structureTag("level_3", dungeonDifficulty.name, 3), Default.structureTag("level_2", dungeonDifficulty.name, 2), Default.structureTag("level_1", dungeonDifficulty.name, 1), Default.biomeId("desert|frozen|snowy|ice|jungle", normalDifficulty.name, 1)};
        Config.Dimension nether = new Config.Dimension();
        nether.world_matches.dimension_regex = "minecraft:the_nether";
        nether.difficulty = new Config.DifficultyReference(normalDifficulty.name, 3);
        nether.zones = new Config.Zone[]{Default.structureTag("level_4", dungeonDifficulty.name, 4)};
        Config.Dimension end = new Config.Dimension();
        end.world_matches.dimension_regex = "minecraft:the_end";
        end.difficulty = new Config.DifficultyReference(normalDifficulty.name, 5);
        end.zones = new Config.Zone[]{Default.structureTag("level_6", dungeonDifficulty.name, 6), Default.structureTag("level_5", dungeonDifficulty.name, 5)};
        Config config = new Config();
        config.difficulty_types = new Config.DifficultyType[]{normalDifficulty, dungeonDifficulty};
        config.dimensions = new Config.Dimension[]{overworld, nether, end};
        config.perPlayerDifficulty = perPlayerDifficulty;
        return config;
    }

    private static Config.ItemModifier createItemModifier(Config.AttributeModifier[] attributeModifiers) {
        return Default.createItemModifier(null, null, attributeModifiers);
    }

    private static Config.ItemModifier createItemModifier(String itemIdRegex, String lootTableRegex, Config.AttributeModifier[] attributeModifiers) {
        Config.ItemModifier itemModifier = new Config.ItemModifier();
        itemModifier.item_matches = new Config.ItemModifier.Filters();
        if (itemIdRegex != null) {
            itemModifier.item_matches.item_id_regex = itemIdRegex;
        }
        if (lootTableRegex != null) {
            itemModifier.item_matches.loot_table_regex = lootTableRegex;
        }
        itemModifier.attributes = attributeModifiers;
        return itemModifier;
    }

    private static Config.AttributeModifier createDamageMultiplier(float value, float randomness) {
        Config.AttributeModifier modifier = new Config.AttributeModifier("damage", value);
        modifier.randomness = randomness;
        return modifier;
    }

    private static Config.AttributeModifier createPowerMultiplier(float value, float randomness) {
        Config.AttributeModifier modifier = new Config.AttributeModifier("power", value);
        modifier.randomness = randomness;
        return modifier;
    }

    private static Config.AttributeModifier createProjectileMultiplier(float value, float randomness) {
        Config.AttributeModifier modifier = new Config.AttributeModifier("ranged_weapon:damage", value);
        modifier.randomness = randomness;
        return modifier;
    }

    private static Config.AttributeModifier createArmorMultiplier(float value) {
        return new Config.AttributeModifier("generic.armor", value);
    }

    private static Config.AttributeModifier createArmorBonus(float value) {
        Config.AttributeModifier modifier = new Config.AttributeModifier("generic.armor", value);
        modifier.operation = Config.Operation.ADDITION;
        return modifier;
    }

    private static Config.AttributeModifier createHealthMultiplier(float value, float randomness) {
        Config.AttributeModifier modifier = new Config.AttributeModifier("generic.max_health", value);
        modifier.randomness = randomness;
        return modifier;
    }

    private static Config.AttributeModifier createHealthBonus(float value) {
        Config.AttributeModifier modifier = new Config.AttributeModifier("generic.max_health", value);
        modifier.operation = Config.Operation.ADDITION;
        return modifier;
    }

    private static Config.EntityModifier createEntityModifier(String idRegex, Config.AttributeModifier[] attributeModifiers, Config.SpawnerModifier spawnerModifier, float xpMultiplier) {
        Config.EntityModifier entityModifier = new Config.EntityModifier();
        entityModifier.entity_matches = new Config.EntityModifier.Filters();
        entityModifier.entity_matches.entity_id_regex = idRegex;
        entityModifier.attributes = attributeModifiers;
        entityModifier.spawners = spawnerModifier;
        entityModifier.experience_multiplier = xpMultiplier;
        return entityModifier;
    }

    private static Config.Zone biomeId(String regex, String difficulty, int level) {
        Config.Zone zone = new Config.Zone();
        zone.zone_matches.biome = regex;
        zone.difficulty = new Config.DifficultyReference(difficulty, level);
        return zone;
    }

    private static Config.Zone structureId(String id, String difficulty, int level) {
        Config.Zone zone = new Config.Zone();
        zone.zone_matches.structure = id;
        zone.difficulty = new Config.DifficultyReference(difficulty, level);
        return zone;
    }

    private static Config.Zone structureTag(String tag, String difficulty, int level) {
        Config.Zone zone = new Config.Zone();
        zone.zone_matches.structure = "#" + DungeonDifficulty.MODID + ":" + tag;
        zone.difficulty = new Config.DifficultyReference(difficulty, level);
        return zone;
    }
}

