/*
 * Decompiled with CFR 0.152.
 */
package net.dungeon_difficulty.logic;

import net.dungeon_difficulty.config.Config;
import net.dungeon_difficulty.logic.EntityDifficultyScalable;
import net.dungeon_difficulty.logic.PatternMatching;
import net.dungeon_difficulty.logic.PerPlayerDifficulty;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class EntityScaling {
    public static void scale(class_1297 entity, class_3218 world) {
        if (entity instanceof class_1657) {
            return;
        }
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            EntityDifficultyScalable scalableEntity = (EntityDifficultyScalable)livingEntity;
            if (scalableEntity.isAlreadyScaled()) {
                return;
            }
            PatternMatching.LocationData locationData = PatternMatching.LocationData.create(world, livingEntity.method_24515());
            PatternMatching.EntityData entityData = PatternMatching.EntityData.create(livingEntity);
            scalableEntity.setScalingLocationData(locationData);
            float relativeHealth = livingEntity.method_6032() / livingEntity.method_6063();
            EntityScaling.apply(PerPlayerDifficulty.getAttributeModifiers(entityData, world), livingEntity);
            EntityScaling.apply(PatternMatching.getAttributeModifiersForEntity(locationData, entityData, world), livingEntity);
            scalableEntity.markAlreadyScaled();
            livingEntity.method_6033(relativeHealth * livingEntity.method_6063());
        }
    }

    private static void apply(PatternMatching.EntityScaleResult scaling, class_1309 entity) {
        int level = scaling.level();
        if (level <= 0) {
            return;
        }
        block4: for (Config.AttributeModifier modifier : scaling.modifiers()) {
            class_6880.class_6883 attribute;
            if (modifier.attribute == null || (attribute = (class_6880.class_6883)class_7923.field_41190.method_55841(class_2960.method_60654((String)modifier.attribute)).orElse(null)) == null || !entity.method_6127().method_45331((class_6880)attribute)) continue;
            float modifierValue = modifier.randomizedValue(level);
            switch (modifier.operation) {
                case ADDITION: {
                    class_1324 entityAttribute = entity.method_5996((class_6880)attribute);
                    if (entityAttribute == null) continue block4;
                    entityAttribute.method_6192(entityAttribute.method_6201() + (double)modifierValue);
                    break;
                }
                case MULTIPLY_BASE: {
                    double defaultValue = entity.method_45325((class_6880)attribute);
                    if (!(defaultValue > 0.0)) break;
                    entity.method_5996((class_6880)attribute).method_6192(defaultValue * (double)(1.0f + modifierValue));
                }
            }
        }
    }
}

