/*
 * Decompiled with CFR 0.152.
 */
package net.dungeon_difficulty.logic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.dungeon_difficulty.DungeonDifficulty;
import net.dungeon_difficulty.config.Config;
import net.dungeon_difficulty.logic.Difficulty;
import net.dungeon_difficulty.logic.DifficultyTypes;
import net.minecraft.class_1309;
import net.minecraft.class_1569;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3449;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class PatternMatching {
    private static boolean isInsideStructure(class_3218 world, class_2338 pos, class_3449 structureStart) {
        if (structureStart.method_16657()) {
            return structureStart.method_14969().method_14662((class_2382)pos);
        }
        return false;
    }

    public static ItemScaleResult getModifiersForItem(LocationData locationData, ItemData itemData, class_3218 world) {
        ArrayList<Config.AttributeModifier> attributeModifiers = new ArrayList<Config.AttributeModifier>();
        Difficulty difficulty = PatternMatching.getDifficulty(locationData, world);
        int level = 0;
        if (difficulty != null) {
            level = difficulty.level();
            Config.Rewards rewards = difficulty.type().rewards;
            if (rewards != null) {
                List<Config.ItemModifier> itemModifiers = null;
                switch (itemData.kind.ordinal()) {
                    case 0: {
                        itemModifiers = rewards.armor;
                        break;
                    }
                    case 1: {
                        itemModifiers = rewards.weapons;
                    }
                }
                if (itemModifiers != null) {
                    for (Config.ItemModifier entry : itemModifiers) {
                        if (!itemData.matches(entry.item_matches)) continue;
                        attributeModifiers.addAll(Arrays.asList(entry.attributes));
                    }
                }
            }
        }
        return new ItemScaleResult(attributeModifiers, level);
    }

    public static EntityScaleResult getAttributeModifiersForEntity(LocationData locationData, EntityData entityData, class_3218 world) {
        ArrayList<Config.AttributeModifier> attributeModifiers = new ArrayList<Config.AttributeModifier>();
        Difficulty difficulty = PatternMatching.getDifficulty(locationData, world);
        int level = 0;
        float experienceMultiplier = 0.0f;
        if (difficulty != null) {
            level = difficulty.level();
            for (Config.EntityModifier modifier : PatternMatching.getModifiersForEntity(difficulty.type().entities, entityData)) {
                attributeModifiers.addAll(Arrays.asList(modifier.attributes));
                experienceMultiplier += modifier.experience_multiplier;
            }
        }
        return new EntityScaleResult(attributeModifiers, level, experienceMultiplier);
    }

    public static SpawnerScaleResult getModifiersForSpawner(LocationData locationData, EntityData entityData, class_3218 world) {
        ArrayList<Config.SpawnerModifier> spawnerModifiers = new ArrayList<Config.SpawnerModifier>();
        Difficulty difficulty = PatternMatching.getDifficulty(locationData, world);
        int level = 0;
        if (difficulty != null) {
            level = difficulty.level();
            for (Config.EntityModifier modifier : PatternMatching.getModifiersForEntity(difficulty.type().entities, entityData)) {
                if (modifier.spawners == null) continue;
                spawnerModifiers.add(modifier.spawners);
            }
        }
        return new SpawnerScaleResult(spawnerModifiers, level);
    }

    public static List<Config.EntityModifier> getModifiersForEntity(List<Config.EntityModifier> definitions, EntityData entityData) {
        ArrayList<Config.EntityModifier> entityModifiers = new ArrayList<Config.EntityModifier>();
        for (Config.EntityModifier entityModifier : definitions) {
            if (!entityData.matches(entityModifier.entity_matches)) continue;
            entityModifiers.add(entityModifier);
        }
        return entityModifiers;
    }

    @Nullable
    public static Difficulty getDifficulty(LocationData locationData, class_3218 world) {
        for (Config.Dimension dimension : ((Config)DungeonDifficulty.config.value).dimensions) {
            if (!locationData.matches(dimension.world_matches)) continue;
            Difficulty dimensionDifficulty = PatternMatching.findDifficulty(dimension.difficulty);
            if (dimension.zones != null) {
                for (Config.Zone zone : dimension.zones) {
                    Difficulty zoneDifficulty;
                    if (!locationData.matches(zone.zone_matches, world) || (zoneDifficulty = PatternMatching.findDifficulty(zone.difficulty)) == null || !zoneDifficulty.isValid()) continue;
                    return zoneDifficulty;
                }
            }
            if (dimensionDifficulty == null || !dimensionDifficulty.isValid()) continue;
            return dimensionDifficulty;
        }
        return null;
    }

    @Nullable
    private static Difficulty findDifficulty(Config.DifficultyReference reference) {
        if (reference == null) {
            return null;
        }
        String name = reference.name;
        if (name == null || name.isEmpty()) {
            return null;
        }
        for (Config.DifficultyType entry : DifficultyTypes.resolved) {
            if (!name.equals(entry.name)) continue;
            return new Difficulty(entry, reference.level);
        }
        return null;
    }

    public static boolean matches(String subject, @Nullable String nullableRegex) {
        if (subject == null) {
            subject = "";
        }
        if (nullableRegex == null || nullableRegex.isEmpty()) {
            return true;
        }
        Pattern pattern = Pattern.compile(nullableRegex, 2);
        Matcher matcher = pattern.matcher(subject);
        return matcher.find();
    }

    public record LocationData(String dimensionId, class_2338 position, BiomeData biome) {
        public static LocationData create(class_3218 world, class_2338 position) {
            String dimensionId = world.method_27983().method_29177().toString();
            BiomeData biome = null;
            if (position != null) {
                class_5321 biomeKey = world.method_23753(position).method_40230().orElse(class_1972.field_9451);
                String keyString = biomeKey.method_29177().toString();
                biome = new BiomeData((class_5321<class_1959>)biomeKey, keyString);
            }
            return new LocationData(dimensionId, position, biome);
        }

        public boolean matches(Config.Dimension.Filters filters) {
            if (filters == null) {
                return true;
            }
            boolean result = PatternMatching.matches(this.dimensionId, filters.dimension_regex);
            return result;
        }

        public boolean matches(Config.Zone.Filters filters, @Nullable class_3218 world) {
            boolean result;
            block7: {
                List structureStartsUnfiltered;
                class_2378 registry;
                class_6880.class_6883 entry;
                block8: {
                    if (filters == null || this.biome == null) {
                        return true;
                    }
                    result = false;
                    if (world == null) {
                        return false;
                    }
                    class_5455.class_6890 registries = world.method_8503().method_30611();
                    if (this.biome.keyString.startsWith("#")) {
                        class_2378 registry2;
                        String tagString = this.biome.keyString.substring(1);
                        class_2960 id = class_2960.method_60654((String)tagString);
                        class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)id);
                        if (tag != null && (entry = (class_6880.class_6883)(registry2 = registries.method_30530(class_7924.field_41236)).method_40264(this.biome.key).orElse(null)) != null) {
                            result = entry.method_40220(tag);
                        }
                    } else {
                        result = PatternMatching.matches(this.biome.keyString, filters.biome);
                    }
                    if (!result || filters.structure == null || filters.structure.isEmpty()) break block7;
                    result = false;
                    registry = registries.method_30530(class_7924.field_41246);
                    structureStartsUnfiltered = world.method_27056().method_41035(new class_1923(this.position), s -> true);
                    if (!filters.structure.startsWith("#")) break block8;
                    String tagString = filters.structure.substring(1);
                    class_2960 id = class_2960.method_60654((String)tagString);
                    class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)id);
                    if (tag == null) break block7;
                    for (class_3449 structureStart : structureStartsUnfiltered) {
                        class_6880.class_6883 entry2 = registry.method_40265(registry.method_10206((Object)structureStart.method_16656())).orElse(null);
                        if (entry2 == null || !entry2.method_40220(tag) || !PatternMatching.isInsideStructure(world, this.position, structureStart)) continue;
                        result = true;
                        break block7;
                    }
                    break block7;
                }
                for (class_3449 structureStart : structureStartsUnfiltered) {
                    entry = registry.method_40265(registry.method_10206((Object)structureStart.method_16656())).orElse(null);
                    if (entry == null || !PatternMatching.matches(((class_5321)entry.method_40230().get()).method_29177().toString(), filters.structure) || !PatternMatching.isInsideStructure(world, this.position, structureStart)) continue;
                    result = true;
                    break;
                }
            }
            return result;
        }
    }

    public record ItemData(ItemKind kind, String lootTableId, String itemId, String rarity) {
        public boolean matches(Config.ItemModifier.Filters filters) {
            if (filters == null) {
                return true;
            }
            boolean result = PatternMatching.matches(this.itemId, filters.item_id_regex) && PatternMatching.matches(this.lootTableId, filters.loot_table_regex) && PatternMatching.matches(this.rarity, filters.rarity_regex);
            return result;
        }
    }

    public static enum ItemKind {
        ARMOR,
        WEAPONS;

    }

    public record ItemScaleResult(List<Config.AttributeModifier> modifiers, int level) {
    }

    public record EntityData(String entityId, boolean isHostile) {
        public static EntityData create(class_1309 entity) {
            String entityId = class_7923.field_41177.method_10221((Object)entity.method_5864()).toString();
            boolean isHostile = entity instanceof class_1569;
            return new EntityData(entityId, isHostile);
        }

        public boolean matches(Config.EntityModifier.Filters filters) {
            if (filters == null) {
                return true;
            }
            boolean matchesAttitude = true;
            if (filters.attitude != null) {
                switch (filters.attitude) {
                    case FRIENDLY: {
                        matchesAttitude = !this.isHostile;
                        break;
                    }
                    case HOSTILE: {
                        matchesAttitude = this.isHostile;
                        break;
                    }
                    case ANY: {
                        matchesAttitude = true;
                    }
                }
            }
            boolean result = matchesAttitude && PatternMatching.matches(this.entityId, filters.entity_id_regex);
            return result;
        }
    }

    public record EntityScaleResult(List<Config.AttributeModifier> modifiers, int level, float experienceMultiplier) {
    }

    public record SpawnerScaleResult(List<Config.SpawnerModifier> modifiers, int level) {
    }

    public record Location(Config.EntityModifier[] entities, Config.Rewards rewards) {
    }

    public record BiomeData(class_5321<class_1959> key, String keyString) {
    }
}

