/*
 * Decompiled with CFR 0.152.
 */
package net.dungeon_difficulty.logic;

import java.util.ArrayList;
import java.util.List;
import net.dungeon_difficulty.DungeonDifficulty;
import net.dungeon_difficulty.config.Config;
import net.dungeon_difficulty.logic.PatternMatching;
import net.minecraft.class_3218;

public class PerPlayerDifficulty {
    public static PatternMatching.EntityScaleResult getAttributeModifiers(PatternMatching.EntityData entityData, class_3218 world) {
        PatternMatching.EntityScaleResult empty = new PatternMatching.EntityScaleResult(List.of(), 0, 0.0f);
        Config.PerPlayerDifficulty perPlayer = ((Config)DungeonDifficulty.config.value).perPlayerDifficulty;
        if (perPlayer == null || !perPlayer.enabled || perPlayer.entities == null || perPlayer.entities.length == 0 || perPlayer.counting == null) {
            return empty;
        }
        int playerCount = 0;
        switch (perPlayer.counting) {
            case EVERYWHERE: {
                playerCount = world.method_8503().method_3760().method_14571().size();
                break;
            }
            case DIMENSION: {
                playerCount = world.method_18456().size();
            }
        }
        if (playerCount < 2) {
            return empty;
        }
        int applyCount = playerCount - 1;
        ArrayList<Config.AttributeModifier> attributeModifiers = new ArrayList<Config.AttributeModifier>();
        for (Config.EntityModifier entityBaseModifier : perPlayer.entities) {
            if (!entityData.matches(entityBaseModifier.entity_matches)) continue;
            attributeModifiers.addAll(List.of(entityBaseModifier.attributes));
        }
        return new PatternMatching.EntityScaleResult(attributeModifiers, applyCount, 0.0f);
    }
}

