/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.class_1662;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.client.recipebook.CookingPotRecipeBookTab;
import vectorwing.farmersdelight.common.crafting.RecipeWrapper;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.registry.ModRecipeSerializers;
import vectorwing.farmersdelight.common.registry.ModRecipeTypes;

public class CookingPotRecipe
implements class_1860<RecipeWrapper> {
    public static final int INPUT_SLOTS = 6;
    private final String group;
    private final CookingPotRecipeBookTab tab;
    private final class_2371<class_1856> inputItems;
    private final class_1799 output;
    private final class_1799 container;
    private final class_1799 containerOverride;
    private final float experience;
    private final int cookTime;

    public CookingPotRecipe(String group, @Nullable CookingPotRecipeBookTab tab, class_2371<class_1856> inputItems, class_1799 output, class_1799 container, float experience, int cookTime) {
        this.group = group;
        this.tab = tab;
        this.inputItems = inputItems;
        this.output = output;
        this.container = !container.method_7960() ? container : (!output.getRecipeRemainder().method_7960() ? output.getRecipeRemainder() : class_1799.field_8037);
        this.containerOverride = container;
        this.experience = experience;
        this.cookTime = cookTime;
    }

    public String method_8112() {
        return this.group;
    }

    @Nullable
    public CookingPotRecipeBookTab getRecipeBookTab() {
        return this.tab;
    }

    public class_2371<class_1856> method_8117() {
        return this.inputItems;
    }

    public class_1799 method_8110(class_7225.class_7874 provider) {
        return this.output;
    }

    public class_1799 getOutputContainer() {
        return this.container;
    }

    public class_1799 getContainerOverride() {
        return this.containerOverride;
    }

    public class_1799 assemble(RecipeWrapper inv, class_7225.class_7874 provider) {
        return this.output.method_7972();
    }

    public float getExperience() {
        return this.experience;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public boolean matches(RecipeWrapper inv, class_1937 level) {
        class_1662 stackedContents = new class_1662();
        int i = 0;
        for (int j = 0; j < 6; ++j) {
            class_1799 itemstack = inv.method_59984(j);
            if (itemstack.method_7960()) continue;
            ++i;
            stackedContents.method_7400(itemstack);
        }
        return i == this.inputItems.size() && stackedContents.method_7402((class_1860)this, null);
    }

    public boolean method_8113(int width, int height) {
        return width * height >= this.inputItems.size();
    }

    public class_1865<?> method_8119() {
        return ModRecipeSerializers.COOKING.get();
    }

    public class_3956<?> method_17716() {
        return ModRecipeTypes.COOKING.get();
    }

    public class_1799 method_17447() {
        return new class_1799((class_1935)ModItems.COOKING_POT.get());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CookingPotRecipe that = (CookingPotRecipe)o;
        if (Float.compare(that.getExperience(), this.getExperience()) != 0) {
            return false;
        }
        if (this.getCookTime() != that.getCookTime()) {
            return false;
        }
        if (!this.method_8112().equals(that.method_8112())) {
            return false;
        }
        if (this.tab != that.tab) {
            return false;
        }
        if (!this.inputItems.equals(that.inputItems)) {
            return false;
        }
        if (!this.output.equals(that.output)) {
            return false;
        }
        return this.container.equals(that.container);
    }

    public int hashCode() {
        int result = this.method_8112().hashCode();
        result = 31 * result + (this.getRecipeBookTab() != null ? this.getRecipeBookTab().hashCode() : 0);
        result = 31 * result + this.inputItems.hashCode();
        result = 31 * result + this.output.hashCode();
        result = 31 * result + this.container.hashCode();
        result = 31 * result + (this.getExperience() != 0.0f ? Float.floatToIntBits(this.getExperience()) : 0);
        result = 31 * result + this.getCookTime();
        return result;
    }

    public static class Serializer
    implements class_1865<CookingPotRecipe> {
        private static final MapCodec<CookingPotRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(CookingPotRecipe::method_8112), (App)CookingPotRecipeBookTab.CODEC.optionalFieldOf("recipe_book_tab").xmap(optional -> optional.orElse(null), Optional::of).forGetter(CookingPotRecipe::getRecipeBookTab), (App)class_1856.field_46096.listOf().fieldOf("ingredients").xmap(ingredients -> {
            class_2371 nonNullList = class_2371.method_10211();
            nonNullList.addAll((Collection)ingredients);
            return nonNullList;
        }, ingredients -> ingredients).forGetter(CookingPotRecipe::method_8117), (App)class_1799.field_51397.fieldOf("result").forGetter(r -> r.output), (App)class_1799.field_51397.optionalFieldOf("container", (Object)class_1799.field_8037).forGetter(CookingPotRecipe::getContainerOverride), (App)Codec.FLOAT.optionalFieldOf("experience", (Object)Float.valueOf(0.0f)).forGetter(CookingPotRecipe::getExperience), (App)Codec.INT.optionalFieldOf("cookingtime", (Object)200).forGetter(CookingPotRecipe::getCookTime)).apply((Applicative)inst, CookingPotRecipe::new));
        public static final class_9139<class_9129, CookingPotRecipe> STREAM_CODEC = class_9139.method_56437(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<CookingPotRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, CookingPotRecipe> method_56104() {
            return STREAM_CODEC;
        }

        private static CookingPotRecipe fromNetwork(class_9129 buffer) {
            String groupIn = buffer.method_19772();
            CookingPotRecipeBookTab tabIn = CookingPotRecipeBookTab.findByName(buffer.method_19772());
            int i = buffer.method_10816();
            class_2371 inputItemsIn = class_2371.method_10213((int)i, (Object)class_1856.field_9017);
            inputItemsIn.replaceAll(ignored -> (class_1856)class_1856.field_48355.decode((Object)buffer));
            class_1799 outputIn = (class_1799)class_1799.field_48349.decode((Object)buffer);
            class_1799 container = (class_1799)class_1799.field_49268.decode((Object)buffer);
            float experienceIn = buffer.readFloat();
            int cookTimeIn = buffer.method_10816();
            return new CookingPotRecipe(groupIn, tabIn, (class_2371<class_1856>)inputItemsIn, outputIn, container, experienceIn, cookTimeIn);
        }

        private static void toNetwork(class_9129 buffer, CookingPotRecipe recipe) {
            buffer.method_10814(recipe.group);
            buffer.method_10814(recipe.tab != null ? recipe.tab.toString() : "");
            buffer.method_10804(recipe.inputItems.size());
            for (class_1856 ingredient : recipe.inputItems) {
                class_1856.field_48355.encode((Object)buffer, (Object)ingredient);
            }
            class_1799.field_48349.encode((Object)buffer, (Object)recipe.output);
            class_1799.field_49268.encode((Object)buffer, (Object)recipe.container);
            buffer.method_52941(recipe.experience);
            buffer.method_10804(recipe.cookTime);
        }
    }
}

