/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.api.fluid;

import dev.architectury.fluid.FluidStack;
import dev.sterner.witchery.api.fluid.WitcheryFluidHandler;
import dev.sterner.witchery.block.cauldron.CauldronBlockEntity;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\u0010\b\u0002\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0019\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0004H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u001aJ\u001f\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u001f\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u001f\u0010!J\r\u0010#\u001a\u00020\"\u00a2\u0006\u0004\b#\u0010$J\r\u0010%\u001a\u00020\u000f\u00a2\u0006\u0004\b%\u0010&J\u001d\u0010+\u001a\u00020\"2\u0006\u0010(\u001a\u00020'2\u0006\u0010*\u001a\u00020)\u00a2\u0006\u0004\b+\u0010,J\u001d\u0010-\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\u0006\u0010*\u001a\u00020)\u00a2\u0006\u0004\b-\u0010.J\u001d\u00100\u001a\u00020'2\u0006\u0010/\u001a\u00020'2\u0006\u0010*\u001a\u00020)\u00a2\u0006\u0004\b0\u0010.J\u001f\u00101\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b1\u00102R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u00103\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u00108\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010=\u001a\u0004\b>\u0010\rR*\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\t\u0010?\u001a\u0004\b@\u0010A\"\u0004\bB\u0010C\u00a8\u0006D"}, d2={"Ldev/sterner/witchery/api/fluid/WitcheryFluidTank;", "Ldev/sterner/witchery/api/fluid/WitcheryFluidHandler;", "Ldev/sterner/witchery/block/cauldron/CauldronBlockEntity;", "blockEntity", "Ldev/architectury/fluid/FluidStack;", "fluid", "", "capacity", "Ljava/util/function/Predicate;", "predicate", "<init>", "(Ldev/sterner/witchery/block/cauldron/CauldronBlockEntity;Ldev/architectury/fluid/FluidStack;JLjava/util/function/Predicate;)V", "getFluidAmount", "()J", "fluidStack", "", "isFluidValid", "(Ldev/architectury/fluid/FluidStack;)Z", "", "getTanks", "()I", "tank", "getFluidInTank", "(I)Ldev/architectury/fluid/FluidStack;", "getTankCapacity", "(I)J", "(ILdev/architectury/fluid/FluidStack;)Z", "simulate", "fill", "(Ldev/architectury/fluid/FluidStack;Z)J", "maxDrain", "drain", "(JZ)Ldev/architectury/fluid/FluidStack;", "(Ldev/architectury/fluid/FluidStack;Z)Ldev/architectury/fluid/FluidStack;", "", "setChanged", "()V", "isEmpty", "()Z", "Lnet/minecraft/class_2487;", "pTag", "Lnet/minecraft/class_7225$class_7874;", "pRegistries", "loadFluidAdditional", "(Lnet/minecraft/class_2487;Lnet/minecraft/class_7225$class_7874;)V", "saveFluidAdditional", "(Lnet/minecraft/class_2487;Lnet/minecraft/class_7225$class_7874;)Lnet/minecraft/class_2487;", "superTag", "getUpdateTag", "setFluidInTank", "(ILdev/architectury/fluid/FluidStack;)V", "Ldev/sterner/witchery/block/cauldron/CauldronBlockEntity;", "getBlockEntity", "()Ldev/sterner/witchery/block/cauldron/CauldronBlockEntity;", "setBlockEntity", "(Ldev/sterner/witchery/block/cauldron/CauldronBlockEntity;)V", "Ldev/architectury/fluid/FluidStack;", "getFluid", "()Ldev/architectury/fluid/FluidStack;", "setFluid", "(Ldev/architectury/fluid/FluidStack;)V", "J", "getCapacity", "Ljava/util/function/Predicate;", "getPredicate", "()Ljava/util/function/Predicate;", "setPredicate", "(Ljava/util/function/Predicate;)V", "witchery-common"})
public final class WitcheryFluidTank
implements WitcheryFluidHandler {
    @NotNull
    private CauldronBlockEntity blockEntity;
    @NotNull
    private FluidStack fluid;
    private final long capacity;
    @NotNull
    private Predicate<FluidStack> predicate;

    public WitcheryFluidTank(@NotNull CauldronBlockEntity blockEntity, @NotNull FluidStack fluid, long capacity, @NotNull Predicate<FluidStack> predicate) {
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)fluid, (String)"fluid");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        this.blockEntity = blockEntity;
        this.fluid = fluid;
        this.capacity = capacity;
        this.predicate = predicate;
    }

    public /* synthetic */ WitcheryFluidTank(CauldronBlockEntity cauldronBlockEntity, FluidStack fluidStack, long l, Predicate predicate, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            fluidStack = FluidStack.empty();
        }
        if ((n & 4) != 0) {
            l = FluidStack.bucketAmount();
        }
        if ((n & 8) != 0) {
            predicate = WitcheryFluidTank::_init_$lambda$0;
        }
        this(cauldronBlockEntity, fluidStack, l, predicate);
    }

    @NotNull
    public final CauldronBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public final void setBlockEntity(@NotNull CauldronBlockEntity cauldronBlockEntity) {
        Intrinsics.checkNotNullParameter((Object)cauldronBlockEntity, (String)"<set-?>");
        this.blockEntity = cauldronBlockEntity;
    }

    @NotNull
    public final FluidStack getFluid() {
        return this.fluid;
    }

    public final void setFluid(@NotNull FluidStack fluidStack) {
        Intrinsics.checkNotNullParameter((Object)fluidStack, (String)"<set-?>");
        this.fluid = fluidStack;
    }

    public final long getCapacity() {
        return this.capacity;
    }

    @NotNull
    public final Predicate<FluidStack> getPredicate() {
        return this.predicate;
    }

    public final void setPredicate(@NotNull Predicate<FluidStack> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"<set-?>");
        this.predicate = predicate;
    }

    @Override
    public long getFluidAmount() {
        return this.fluid.getAmount();
    }

    @Override
    public boolean isFluidValid(@Nullable FluidStack fluidStack) {
        return this.predicate.test(fluidStack);
    }

    @Override
    public int getTanks() {
        return 1;
    }

    @Override
    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this.fluid;
    }

    @Override
    public long getTankCapacity(int tank) {
        return this.capacity;
    }

    @Override
    public boolean isFluidValid(int tank, @NotNull FluidStack fluidStack) {
        Intrinsics.checkNotNullParameter((Object)fluidStack, (String)"fluidStack");
        return this.isFluidValid(fluidStack);
    }

    @Override
    public long fill(@NotNull FluidStack fluidStack, boolean simulate) {
        Intrinsics.checkNotNullParameter((Object)fluidStack, (String)"fluidStack");
        if (fluidStack.isEmpty() || !this.isFluidValid(fluidStack)) {
            return 0L;
        }
        if (simulate) {
            return this.fluid.isEmpty() ? (long)Math.min((double)this.capacity, (double)fluidStack.getAmount()) : (this.fluid.isFluidEqual(fluidStack) ? (long)Math.min((double)(this.capacity - this.fluid.getAmount()), (double)fluidStack.getAmount()) : 0L);
        }
        if (this.fluid.isEmpty()) {
            this.fluid = FluidStack.create((FluidStack)fluidStack, (long)Math.min(this.capacity, fluidStack.getAmount()));
            this.setChanged();
            return this.fluid.getAmount();
        }
        if (!this.fluid.isFluidEqual(fluidStack)) {
            return 0L;
        }
        long availableSpace = this.capacity - this.fluid.getAmount();
        if (fluidStack.getAmount() < availableSpace) {
            this.fluid.grow(fluidStack.getAmount());
        } else {
            this.fluid.setAmount(this.capacity);
        }
        if (availableSpace > 0L) {
            this.setChanged();
        }
        return availableSpace;
    }

    @Override
    @NotNull
    public FluidStack drain(long maxDrain, boolean simulate) {
        long amountToDrain = Math.min(maxDrain, this.fluid.getAmount());
        FluidStack drainedFluid = FluidStack.create((FluidStack)this.fluid, (long)amountToDrain);
        if (!simulate && amountToDrain > 0L) {
            this.fluid.shrink(amountToDrain);
            this.setChanged();
        }
        Intrinsics.checkNotNull((Object)drainedFluid);
        return drainedFluid;
    }

    @Override
    @NotNull
    public FluidStack drain(@NotNull FluidStack fluidStack, boolean simulate) {
        Intrinsics.checkNotNullParameter((Object)fluidStack, (String)"fluidStack");
        if (fluidStack.isEmpty() || !fluidStack.isFluidEqual(this.fluid)) {
            FluidStack fluidStack2 = FluidStack.empty();
            Intrinsics.checkNotNullExpressionValue((Object)fluidStack2, (String)"empty(...)");
            return fluidStack2;
        }
        return this.drain(fluidStack.getAmount(), simulate);
    }

    public final void setChanged() {
        this.blockEntity.method_5431();
    }

    public final boolean isEmpty() {
        return this.fluid.isEmpty();
    }

    public final void loadFluidAdditional(@NotNull class_2487 pTag, @NotNull class_7225.class_7874 pRegistries) {
        Intrinsics.checkNotNullParameter((Object)pTag, (String)"pTag");
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        if (pTag.method_10545("Fluid")) {
            class_2487 fluidTag = pTag.method_10562("Fluid");
            this.fluid = FluidStack.read((class_7225.class_7874)pRegistries, (class_2520)((class_2520)fluidTag)).orElse(FluidStack.empty());
        }
    }

    @NotNull
    public final class_2487 saveFluidAdditional(@NotNull class_2487 pTag, @NotNull class_7225.class_7874 pRegistries) {
        Intrinsics.checkNotNullParameter((Object)pTag, (String)"pTag");
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        if (!this.fluid.isEmpty()) {
            pTag.method_10566("Fluid", this.fluid.write(pRegistries, (class_2520)pTag));
        }
        return pTag;
    }

    @NotNull
    public final class_2487 getUpdateTag(@NotNull class_2487 superTag, @NotNull class_7225.class_7874 pRegistries) {
        Intrinsics.checkNotNullParameter((Object)superTag, (String)"superTag");
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        if (!this.fluid.isEmpty()) {
            superTag.method_10566("Fluid", this.fluid.write(pRegistries, (class_2520)new class_2487()));
        }
        return superTag;
    }

    @Override
    public void setFluidInTank(int tank, @NotNull FluidStack fluidStack) {
        Intrinsics.checkNotNullParameter((Object)fluidStack, (String)"fluidStack");
        this.fluid = fluidStack;
    }

    private static final boolean _init_$lambda$0(FluidStack it) {
        return true;
    }
}

