/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.block.ritual;

import com.mojang.brigadier.ParseResults;
import dev.sterner.witchery.block.ritual.CommandType;
import dev.sterner.witchery.block.ritual.GoldenChalkBlockEntity;
import dev.sterner.witchery.entity.FloatingItemEntity;
import dev.sterner.witchery.recipe.ritual.RitualRecipe;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.class_1264;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\bJ\u0015\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\bJ\u0015\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\bJ\u0015\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\bJ\u0015\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\bJ%\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0014J%\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0015\u0010\u0014J-\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019JW\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\u001c\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001d\u001a\u00020\u00162\b\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\b\u0010!\u001a\u0004\u0018\u00010 H\u0002\u00a2\u0006\u0004\b\u0018\u0010\"\u00a8\u0006#"}, d2={"Ldev/sterner/witchery/block/ritual/RitualHelper;", "", "<init>", "()V", "Lnet/minecraft/class_1937;", "level", "", "isDaytime", "(Lnet/minecraft/class_1937;)Z", "isNighttime", "isFullMoon", "isNewMoon", "isWaxing", "isWaning", "Lnet/minecraft/class_2338;", "blockPos", "Ldev/sterner/witchery/block/ritual/GoldenChalkBlockEntity;", "blockEntity", "", "summonItems", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;Ldev/sterner/witchery/block/ritual/GoldenChalkBlockEntity;)V", "summonSummons", "", "phase", "runCommand", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;Ldev/sterner/witchery/block/ritual/GoldenChalkBlockEntity;Ljava/lang/String;)V", "Lnet/minecraft/server/MinecraftServer;", "minecraftServer", "waystonePos", "command", "Lnet/minecraft/class_1657;", "player", "", "entityId", "(Ldev/sterner/witchery/block/ritual/GoldenChalkBlockEntity;Lnet/minecraft/class_1937;Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/class_2338;Lnet/minecraft/class_2338;Ljava/lang/String;Lnet/minecraft/class_1657;Ljava/lang/Integer;)V", "witchery-common"})
@SourceDebugExtension(value={"SMAP\nRitualHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RitualHelper.kt\ndev/sterner/witchery/block/ritual/RitualHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,180:1\n1#2:181\n*E\n"})
public final class RitualHelper {
    @NotNull
    public static final RitualHelper INSTANCE = new RitualHelper();

    private RitualHelper() {
    }

    public final boolean isDaytime(@NotNull class_1937 level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        long timeOfDay = level.method_8532() % (long)24000;
        return 0L <= timeOfDay ? timeOfDay < 12000L : false;
    }

    public final boolean isNighttime(@NotNull class_1937 level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        long timeOfDay = level.method_8532() % (long)24000;
        level.method_30273();
        return 12000L <= timeOfDay ? timeOfDay < 24000L : false;
    }

    public final boolean isFullMoon(@NotNull class_1937 level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        return level.method_30273() == 0 && this.isNighttime(level);
    }

    public final boolean isNewMoon(@NotNull class_1937 level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        return level.method_30273() == 4 && this.isNighttime(level);
    }

    public final boolean isWaxing(@NotNull class_1937 level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        int n = level.method_30273();
        return (5 <= n ? n < 8 : false) && this.isNighttime(level);
    }

    public final boolean isWaning(@NotNull class_1937 level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        int n = level.method_30273();
        return (1 <= n ? n < 4 : false) && this.isNighttime(level);
    }

    public final void summonItems(@NotNull class_1937 level, @NotNull class_2338 blockPos, @NotNull GoldenChalkBlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        double x = (double)blockPos.method_10263() + 0.5;
        double y = (double)blockPos.method_10264() + 0.5;
        double z = (double)blockPos.method_10260() + 0.5;
        if (blockEntity.getRitualRecipe() != null) {
            RitualRecipe ritualRecipe = blockEntity.getRitualRecipe();
            Intrinsics.checkNotNull((Object)ritualRecipe);
            for (class_1799 output : ritualRecipe.getOutputItems()) {
                RitualRecipe ritualRecipe2 = blockEntity.getRitualRecipe();
                Intrinsics.checkNotNull((Object)ritualRecipe2);
                if (ritualRecipe2.getFloatingItemOutput()) {
                    FloatingItemEntity itemEntity = new FloatingItemEntity(level);
                    class_1799 class_17992 = output.method_7972();
                    Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"copy(...)");
                    itemEntity.setItem(class_17992);
                    itemEntity.method_5808((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5, 0.0f, 0.0f);
                    level.method_8649((class_1297)itemEntity);
                    continue;
                }
                class_1264.method_5449((class_1937)level, (double)x, (double)y, (double)z, (class_1799)output.method_7972());
            }
        }
    }

    public final void summonSummons(@NotNull class_1937 level, @NotNull class_2338 blockPos, @NotNull GoldenChalkBlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        if (blockEntity.getRitualRecipe() != null) {
            RitualRecipe ritualRecipe = blockEntity.getRitualRecipe();
            Intrinsics.checkNotNull((Object)ritualRecipe);
            for (class_1299<?> entityType : ritualRecipe.getOutputEntities()) {
                class_1297 entity = entityType.method_5883(level);
                if (!(entity instanceof class_1309)) continue;
                float angle = level.field_9229.method_43057() * (float)360;
                double distance = level.field_9229.method_43058() * (double)2;
                double x = (double)blockPos.method_10263() + distance * Math.cos(Math.toRadians(angle));
                double z = (double)blockPos.method_10260() + distance * Math.sin(Math.toRadians(angle));
                ((class_1309)entity).method_5808(x, (double)blockPos.method_10264() + 0.2, z, level.field_9229.method_43057() * (float)360, 0.0f);
                level.method_8649(entity);
            }
        }
    }

    public final void runCommand(@NotNull class_1937 level, @NotNull class_2338 blockPos, @NotNull GoldenChalkBlockEntity blockEntity, @NotNull String phase) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)phase, (String)"phase");
        MinecraftServer server = level.method_8503();
        if (blockEntity.getRitualRecipe() != null) {
            RitualRecipe ritualRecipe = blockEntity.getRitualRecipe();
            Intrinsics.checkNotNull((Object)ritualRecipe);
            for (CommandType commandType : ritualRecipe.getCommands()) {
                class_3218 dimensionLevel;
                Object object;
                class_3222 class_32222;
                if (!Intrinsics.areEqual((Object)commandType.type(), (Object)phase)) continue;
                UUID playerUuid = blockEntity.getTargetPlayer();
                if (playerUuid != null) {
                    UUID it;
                    boolean bl = false;
                    MinecraftServer minecraftServer = server;
                    class_32222 = minecraftServer != null && (minecraftServer = minecraftServer.method_3760()) != null ? minecraftServer.method_14602(it) : null;
                } else {
                    class_32222 = null;
                }
                class_3222 player = class_32222;
                Integer targetEntity = blockEntity.getTargetEntity();
                class_4208 targetPos = blockEntity.getTargetPos();
                class_4208 class_42082 = targetPos;
                if (class_42082 != null && (class_42082 = class_42082.comp_2207()) != null) {
                    class_4208 it = class_42082;
                    boolean bl = false;
                    MinecraftServer minecraftServer = server;
                    object = minecraftServer != null ? minecraftServer.method_3847((class_5321)it) : null;
                } else {
                    object = null;
                }
                class_3218 class_32182 = dimensionLevel = object;
                class_4208 class_42083 = targetPos;
                this.runCommand(blockEntity, class_32182 != null ? (class_1937)class_32182 : level, server, blockPos, (class_2338)(class_42083 != null ? class_42083.comp_2208() : null), commandType.command(), (class_1657)player, targetEntity);
            }
        }
    }

    private final void runCommand(GoldenChalkBlockEntity blockEntity, class_1937 level, MinecraftServer minecraftServer, class_2338 blockPos, class_2338 waystonePos, String command, class_1657 player, Integer entityId) {
        Object formattedCommand = command;
        if (minecraftServer != null && ((CharSequence)formattedCommand).length() > 0) {
            String tag;
            class_1297 entity;
            class_2168 class_21682 = minecraftServer.method_3739().method_9217();
            Intrinsics.checkNotNullExpressionValue((Object)class_21682, (String)"withSuppressedOutput(...)");
            class_2168 commandSource = class_21682;
            class_2170 class_21702 = minecraftServer.method_3734();
            Intrinsics.checkNotNullExpressionValue((Object)class_21702, (String)"getCommands(...)");
            class_2170 commandManager = class_21702;
            if (player != null) {
                String string = player.method_5477().getString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                formattedCommand = StringsKt.replace$default((String)formattedCommand, (String)"{taglockPlayer}", (String)string, (boolean)false, (int)4, null);
            }
            if (entityId != null) {
                MinecraftServer minecraftServer2 = level.method_8503();
                Intrinsics.checkNotNull((Object)minecraftServer2);
                for (class_3218 serverLevels : minecraftServer2.method_3738()) {
                    entity = serverLevels.method_8469(entityId.intValue());
                    if (!(entity instanceof class_1309)) continue;
                    tag = "Waystone_" + ((class_1309)entity).method_5667();
                    if (!((class_1309)entity).method_5752().contains(tag)) {
                        ((class_1309)entity).method_5780(tag);
                    }
                    formattedCommand = StringsKt.replace$default((String)formattedCommand, (String)"{taglockEntity}", (String)("@e[tag=" + tag + "]"), (boolean)false, (int)4, null);
                    break;
                }
            }
            if (StringsKt.contains$default((CharSequence)((CharSequence)formattedCommand), (CharSequence)"{taglockPlayerOrEntity}", (boolean)false, (int)2, null)) {
                if (player != null) {
                    String string = player.method_5477().getString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                    formattedCommand = StringsKt.replace$default((String)formattedCommand, (String)"{taglockPlayerOrEntity}", (String)string, (boolean)false, (int)4, null);
                } else if (entityId != null) {
                    MinecraftServer minecraftServer3 = level.method_8503();
                    Intrinsics.checkNotNull((Object)minecraftServer3);
                    for (class_3218 serverLevels : minecraftServer3.method_3738()) {
                        entity = serverLevels.method_8469(entityId.intValue());
                        if (!(entity instanceof class_1309)) continue;
                        tag = "Waystone_" + ((class_1309)entity).method_5667();
                        if (!((class_1309)entity).method_5752().contains(tag)) {
                            ((class_1309)entity).method_5780(tag);
                        }
                        formattedCommand = StringsKt.replace$default((String)formattedCommand, (String)"{taglockPlayerOrEntity}", (String)("@e[tag=" + tag + "]"), (boolean)false, (int)4, null);
                        break;
                    }
                }
            }
            if (waystonePos != null) {
                formattedCommand = StringsKt.replace$default((String)formattedCommand, (String)"{waystonePos}", (String)(waystonePos.method_10263() + " " + waystonePos.method_10264() + " " + waystonePos.method_10260()), (boolean)false, (int)4, null);
            }
            formattedCommand = StringsKt.replace$default((String)formattedCommand, (String)"{time}", (String)String.valueOf(level.method_8532()), (boolean)false, (int)4, null);
            formattedCommand = StringsKt.replace$default((String)formattedCommand, (String)"{owner}", (String)String.valueOf(blockEntity.getOwnerName()), (boolean)false, (int)4, null);
            formattedCommand = StringsKt.replace$default((String)formattedCommand, (String)"{chalkPos}", (String)(blockPos.method_10263() + " " + blockPos.method_10264() + " " + blockPos.method_10260()), (boolean)false, (int)4, null);
            formattedCommand = "execute as " + blockEntity.getOwnerName() + " run execute in " + level.method_27983().method_29177().method_12832() + " run " + (String)formattedCommand;
            ParseResults parseResults = commandManager.method_9235().parse((String)formattedCommand, (Object)commandSource);
            Intrinsics.checkNotNullExpressionValue((Object)parseResults, (String)"parse(...)");
            ParseResults parseResults2 = parseResults;
            commandManager.method_9249(parseResults2, (String)formattedCommand);
        }
    }
}

