/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.integration.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.api.RenderUtils;
import dev.sterner.witchery.integration.emi.WitcheryEmiPlugin;
import dev.sterner.witchery.integration.emi.WitcherySlotWidget;
import dev.sterner.witchery.recipe.ritual.RitualRecipe;
import dev.sterner.witchery.registry.WitcheryItems;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\rH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0010J\u000f\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0015J\u0017\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJA\u0010%\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u00172\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001f2\u0006\u0010$\u001a\u00020#H\u0002\u00a2\u0006\u0004\b%\u0010&JC\u0010,\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\u001d2\n\b\u0002\u0010+\u001a\u0004\u0018\u00010\u0013H\u0002\u00a2\u0006\u0004\b,\u0010-J/\u00100\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010/\u001a\u00020.2\u0006\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b0\u00101J?\u00103\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010/\u001a\u00020.2\u0006\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u00132\u0006\u00102\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b3\u00104J'\u00108\u001a\u00020\u00192\u0006\u00106\u001a\u0002052\u0006\u00107\u001a\u00020\u00022\u0006\u0010+\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b8\u00109J\u001f\u00108\u001a\u00020\u00192\u0006\u00106\u001a\u0002052\u0006\u00107\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b8\u0010:R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010;\u001a\u0004\b<\u0010\fR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010=\u001a\u0004\b>\u0010?\u00a8\u0006@"}, d2={"Ldev/sterner/witchery/integration/emi/RitualEmiRecipe;", "Ldev/emi/emi/api/recipe/EmiRecipe;", "Lnet/minecraft/class_2960;", "recipeId", "Ldev/sterner/witchery/recipe/ritual/RitualRecipe;", "recipe", "<init>", "(Lnet/minecraft/class_2960;Ldev/sterner/witchery/recipe/ritual/RitualRecipe;)V", "Ldev/emi/emi/api/recipe/EmiRecipeCategory;", "getCategory", "()Ldev/emi/emi/api/recipe/EmiRecipeCategory;", "getId", "()Lnet/minecraft/class_2960;", "", "Ldev/emi/emi/api/stack/EmiIngredient;", "getInputs", "()Ljava/util/List;", "Ldev/emi/emi/api/stack/EmiStack;", "getOutputs", "", "getDisplayWidth", "()I", "getDisplayHeight", "Ldev/emi/emi/api/widget/WidgetHolder;", "widgets", "", "addWidgets", "(Ldev/emi/emi/api/widget/WidgetHolder;)V", "", "", "pattern", "", "", "Lnet/minecraft/class_2248;", "blockMapping", "", "offsetY", "renderRitualCircle", "(Ldev/emi/emi/api/widget/WidgetHolder;Ljava/util/List;Ljava/util/Map;D)V", "posX", "posY", "size", "texturePath", "color", "addChalkCircleWidget", "(Ldev/emi/emi/api/widget/WidgetHolder;IIILjava/lang/String;Ljava/lang/Integer;)V", "Lnet/minecraft/class_1799;", "itemStack", "addItemCircleWidget", "(Ldev/emi/emi/api/widget/WidgetHolder;Lnet/minecraft/class_1799;II)V", "index", "renderItem", "(Ldev/emi/emi/api/widget/WidgetHolder;Lnet/minecraft/class_1799;IIII)V", "Lnet/minecraft/class_4587;", "poseStack", "texture", "renderChalk", "(Lnet/minecraft/class_4587;Lnet/minecraft/class_2960;I)V", "(Lnet/minecraft/class_4587;Lnet/minecraft/class_2960;)V", "Lnet/minecraft/class_2960;", "getRecipeId", "Ldev/sterner/witchery/recipe/ritual/RitualRecipe;", "getRecipe", "()Ldev/sterner/witchery/recipe/ritual/RitualRecipe;", "witchery-common"})
public final class RitualEmiRecipe
implements EmiRecipe {
    @NotNull
    private final class_2960 recipeId;
    @NotNull
    private final RitualRecipe recipe;

    public RitualEmiRecipe(@NotNull class_2960 recipeId, @NotNull RitualRecipe recipe) {
        Intrinsics.checkNotNullParameter((Object)recipeId, (String)"recipeId");
        Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
        this.recipeId = recipeId;
        this.recipe = recipe;
    }

    @NotNull
    public final class_2960 getRecipeId() {
        return this.recipeId;
    }

    @NotNull
    public final RitualRecipe getRecipe() {
        return this.recipe;
    }

    @NotNull
    public EmiRecipeCategory getCategory() {
        return WitcheryEmiPlugin.Companion.getRITUAL_CATEGORY();
    }

    @NotNull
    public class_2960 getId() {
        return this.recipeId;
    }

    @NotNull
    public List<EmiIngredient> getInputs() {
        List mutableList = new ArrayList();
        for (class_1799 ingredients : this.recipe.getInputItems()) {
            class_1799[] class_1799Array = new class_1799[]{ingredients};
            EmiIngredient emiIngredient = EmiIngredient.of((class_1856)class_1856.method_8101((class_1799[])class_1799Array));
            Intrinsics.checkNotNullExpressionValue((Object)emiIngredient, (String)"of(...)");
            mutableList.add(emiIngredient);
        }
        return mutableList;
    }

    @NotNull
    public List<EmiStack> getOutputs() {
        List mutableList = new ArrayList();
        for (class_1799 itemStacks : this.recipe.getOutputItems()) {
            EmiStack emiStack = EmiStack.of((class_1799)itemStacks);
            Intrinsics.checkNotNullExpressionValue((Object)emiStack, (String)"of(...)");
            mutableList.add(emiStack);
        }
        return mutableList;
    }

    public int getDisplayWidth() {
        return 144;
    }

    public int getDisplayHeight() {
        return 144;
    }

    public void addWidgets(@NotNull WidgetHolder widgets) {
        Intrinsics.checkNotNullParameter((Object)widgets, (String)"widgets");
        Map<Character, class_2248> blockMapping = this.recipe.getBlockMapping();
        List<String> pattern = this.recipe.getPattern();
        widgets.addText((class_2561)class_2561.method_43471((String)this.getId().toString()), this.getDisplayWidth() / 2, 4, 0xFFFFFF, true).horizontalAlign(TextWidget.Alignment.CENTER);
        widgets.addTooltipText(CollectionsKt.listOf((Object)class_2561.method_43471((String)(this.getId() + ".tooltip"))), 9, 4, 126, 18);
        int itemsPerRow = 6;
        int itemSize = 18;
        int rowIndex = 0;
        int colIndex = 0;
        for (class_1799 item : this.recipe.getInputItems()) {
            int posX = 9 + colIndex * itemSize;
            int posY = 18 + rowIndex * itemSize;
            widgets.add((Widget)new WitcherySlotWidget(EmiStack.of((class_1799)item), posX, posY, 0.0, 8, null));
            if (++colIndex < itemsPerRow) continue;
            colIndex = 0;
            ++rowIndex;
        }
        double scale = 0.3333333333333333;
        double ritualCircleOffsetY = (double)(rowIndex * itemSize) * scale + (double)36;
        this.renderRitualCircle(widgets, pattern, blockMapping, ritualCircleOffsetY);
        int colXOffset = this.getDisplayWidth() - itemSize - 9;
        rowIndex = 0;
        for (class_1799 item : this.recipe.getOutputItems()) {
            int posY = rowIndex * itemSize + this.getDisplayHeight() - itemsPerRow * itemSize - 18;
            widgets.add((Widget)new WitcherySlotWidget(EmiStack.of((class_1799)item), colXOffset, posY, 0.0, 8, null).recipeContext(this));
            ++rowIndex;
        }
        String append = this.recipe.isInfinite() ? "/s" : "";
        widgets.addText((class_2561)class_2561.method_43470((String)("Altar Power: " + this.recipe.getAltarPower() + append)), this.getDisplayWidth() / 4 - 9, this.getDisplayHeight() - 18 - 9, 0xFFFFFF, true);
    }

    private final void renderRitualCircle(WidgetHolder widgets, List<String> pattern, Map<Character, ? extends class_2248> blockMapping, double offsetY) {
        if (!((Collection)pattern).isEmpty()) {
            double scale = 0.3333333333333333;
            int itemSize = (int)((double)16 * scale);
            int totalWidth = pattern.get(0).length() * itemSize;
            int startingX = (widgets.getWidth() - totalWidth) / 2;
            int n = ((Collection)pattern).size();
            for (int y = 0; y < n; ++y) {
                String row = pattern.get(y);
                int n2 = ((CharSequence)row).length();
                for (int x = 0; x < n2; ++x) {
                    char c = row.charAt(x);
                    class_2248 block = blockMapping.get(Character.valueOf(c));
                    class_2248 class_22482 = block;
                    if (class_22482 == null || (class_22482 = class_22482.method_8389()) == null || (class_22482 = class_22482.method_7854()) == null) continue;
                    class_2248 itemStack = class_22482;
                    int posX = startingX + x * itemSize;
                    double posY = (double)(y * itemSize) + offsetY;
                    this.renderItem(widgets, (class_1799)itemStack, posX, (int)posY, itemSize, y + x);
                }
            }
        }
    }

    private final void addChalkCircleWidget(WidgetHolder widgets, int posX, int posY, int size, String texturePath, Integer color) {
        widgets.addDrawable(posX, posY, size, size, (arg_0, arg_1, arg_2, arg_3) -> RitualEmiRecipe.addChalkCircleWidget$lambda$0(color, this, texturePath, arg_0, arg_1, arg_2, arg_3));
    }

    static /* synthetic */ void addChalkCircleWidget$default(RitualEmiRecipe ritualEmiRecipe, WidgetHolder widgetHolder, int n, int n2, int n3, String string, Integer n4, int n5, Object object) {
        if ((n5 & 0x20) != 0) {
            n4 = null;
        }
        ritualEmiRecipe.addChalkCircleWidget(widgetHolder, n, n2, n3, string, n4);
    }

    private final void addItemCircleWidget(WidgetHolder widgets, class_1799 itemStack, int posX, int posY) {
        widgets.add((Widget)new WitcherySlotWidget(EmiStack.of((class_1799)itemStack), posX - 5, posY + 5, 0.3).drawBack(false));
    }

    private final void renderItem(WidgetHolder widgets, class_1799 itemStack, int posX, int posY, int size, int index) {
        if (itemStack.method_31574((class_1792)WitcheryItems.INSTANCE.getGOLDEN_CHALK().get())) {
            RitualEmiRecipe.addChalkCircleWidget$default(this, widgets, posX, posY, size, "textures/block/golden_chalk.png", null, 32, null);
        } else if (itemStack.method_31574((class_1792)WitcheryItems.INSTANCE.getRITUAL_CHALK().get())) {
            RitualEmiRecipe.addChalkCircleWidget$default(this, widgets, posX, posY, size, "textures/block/chalk_" + index % 15 + ".png", null, 32, null);
        } else if (itemStack.method_31574((class_1792)WitcheryItems.INSTANCE.getOTHERWHERE_CHALK().get())) {
            this.addChalkCircleWidget(widgets, posX, posY, size, "textures/block/chalk_" + index % 15 + ".png", new Color(190, 55, 250).getRGB());
        } else if (itemStack.method_31574((class_1792)WitcheryItems.INSTANCE.getINFERNAL_CHALK().get())) {
            this.addChalkCircleWidget(widgets, posX, posY, size, "textures/block/chalk_" + index % 15 + ".png", new Color(230, 0, 75).getRGB());
        } else {
            this.addItemCircleWidget(widgets, itemStack, posX, posY);
        }
    }

    private final void renderChalk(class_4587 poseStack, class_2960 texture, int color) {
        RenderUtils.INSTANCE.blitWithAlpha(poseStack, texture, 1, 33, 0.0f, 0.0f, 16, 16, 16, 16, 0.45f, 0);
        RenderUtils.INSTANCE.blitWithAlpha(poseStack, texture, 0, 32, 0.0f, 0.0f, 16, 16, 16, 16, 1.0f, color);
    }

    private final void renderChalk(class_4587 poseStack, class_2960 texture) {
        RenderUtils.INSTANCE.blitWithAlpha(poseStack, texture, 1, 33, 0.0f, 0.0f, 16, 16, 16, 16, 0.45f, 0);
        RenderUtils.blitWithAlpha$default(RenderUtils.INSTANCE, poseStack, texture, 0, 32, 0.0f, 0.0f, 16, 16, 16, 16, 0.0f, 0, 3072, null);
    }

    private static final void addChalkCircleWidget$lambda$0(Integer $color, RitualEmiRecipe this$0, String $texturePath, class_332 graphics, int n, int n2, float f) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$texturePath, (String)"$texturePath");
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        poseStack.method_22905(0.33333334f, 0.33333334f, 0.33333334f);
        if ($color != null) {
            Intrinsics.checkNotNull((Object)poseStack);
            this$0.renderChalk(poseStack, Witchery.INSTANCE.id($texturePath), $color);
        } else {
            Intrinsics.checkNotNull((Object)poseStack);
            this$0.renderChalk(poseStack, Witchery.INSTANCE.id($texturePath));
        }
        poseStack.method_22909();
    }
}

