/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.platform.fabric;

import dev.architectury.fluid.FluidStack;
import dev.sterner.witchery.api.fluid.WitcheryFluidHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_3611;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000e\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0004B\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0014\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\u000f\u001a\u00020\u000e2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0014\u00a2\u0006\u0004\b\u000f\u0010\u0010J+\u0010\u0016\u001a\u00020\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J+\u0010\u0018\u001a\u00020\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0017J\u000f\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001c\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001e\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010 \u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b \u0010\u001fR\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010!\u001a\u0004\b\"\u0010#R\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010$\u001a\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Ldev/sterner/witchery/platform/fabric/WitcheryFluidHandlerFabric;", "Lnet/fabricmc/fabric/api/transfer/v1/transaction/base/SnapshotParticipant;", "Lnet/fabricmc/fabric/api/transfer/v1/storage/base/ResourceAmount;", "Lnet/fabricmc/fabric/api/transfer/v1/fluid/FluidVariant;", "Lnet/fabricmc/fabric/api/transfer/v1/storage/base/SingleSlotStorage;", "Ldev/sterner/witchery/api/fluid/WitcheryFluidHandler;", "witcheryFluidHandler", "", "tank", "<init>", "(Ldev/sterner/witchery/api/fluid/WitcheryFluidHandler;I)V", "createSnapshot", "()Lnet/fabricmc/fabric/api/transfer/v1/storage/base/ResourceAmount;", "snapshot", "", "readSnapshot", "(Lnet/fabricmc/fabric/api/transfer/v1/storage/base/ResourceAmount;)V", "resource", "", "maxAmount", "Lnet/fabricmc/fabric/api/transfer/v1/transaction/TransactionContext;", "transaction", "insert", "(Lnet/fabricmc/fabric/api/transfer/v1/fluid/FluidVariant;JLnet/fabricmc/fabric/api/transfer/v1/transaction/TransactionContext;)J", "extract", "", "isResourceBlank", "()Z", "getResource", "()Lnet/fabricmc/fabric/api/transfer/v1/fluid/FluidVariant;", "getAmount", "()J", "getCapacity", "Ldev/sterner/witchery/api/fluid/WitcheryFluidHandler;", "getWitcheryFluidHandler", "()Ldev/sterner/witchery/api/fluid/WitcheryFluidHandler;", "I", "getTank", "()I", "witchery-fabric"})
public final class WitcheryFluidHandlerFabric
extends SnapshotParticipant<ResourceAmount<FluidVariant>>
implements SingleSlotStorage<FluidVariant> {
    @NotNull
    private final WitcheryFluidHandler witcheryFluidHandler;
    private final int tank;

    public WitcheryFluidHandlerFabric(@NotNull WitcheryFluidHandler witcheryFluidHandler, int tank) {
        Intrinsics.checkNotNullParameter((Object)witcheryFluidHandler, (String)"witcheryFluidHandler");
        this.witcheryFluidHandler = witcheryFluidHandler;
        this.tank = tank;
    }

    @NotNull
    public final WitcheryFluidHandler getWitcheryFluidHandler() {
        return this.witcheryFluidHandler;
    }

    public final int getTank() {
        return this.tank;
    }

    @NotNull
    protected ResourceAmount<FluidVariant> createSnapshot() {
        return new ResourceAmount((Object)FluidVariant.of((class_3611)this.witcheryFluidHandler.getFluidInTank(this.tank).getFluid()), this.witcheryFluidHandler.getFluidInTank(this.tank).getAmount());
    }

    protected void readSnapshot(@NotNull ResourceAmount<FluidVariant> snapshot) {
        Intrinsics.checkNotNullParameter(snapshot, (String)"snapshot");
        FluidStack fluidStack = FluidStack.create((class_3611)((FluidVariant)snapshot.resource()).getFluid(), (long)snapshot.amount());
        Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"create(...)");
        this.witcheryFluidHandler.setFluidInTank(this.tank, fluidStack);
    }

    public long insert(@Nullable FluidVariant resource, long maxAmount, @Nullable TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)((TransferVariant)resource), (long)maxAmount);
        FluidVariant fluidVariant = resource;
        Intrinsics.checkNotNull((Object)fluidVariant);
        FluidStack stack = FluidStack.create((class_3611)fluidVariant.getFluid(), (long)maxAmount);
        Intrinsics.checkNotNull((Object)stack);
        long insertedAmount = this.witcheryFluidHandler.fill(stack, true);
        if (insertedAmount > 0L) {
            this.updateSnapshots(transaction);
            return this.witcheryFluidHandler.fill(stack, false);
        }
        return 0L;
    }

    public long extract(@Nullable FluidVariant resource, long maxAmount, @Nullable TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)((TransferVariant)resource), (long)maxAmount);
        FluidVariant fluidVariant = resource;
        Intrinsics.checkNotNull((Object)fluidVariant);
        FluidStack stack = FluidStack.create((class_3611)fluidVariant.getFluid(), (long)maxAmount);
        Intrinsics.checkNotNull((Object)stack);
        long extractedAmount = this.witcheryFluidHandler.drain(stack, true).getAmount();
        if (extractedAmount > 0L) {
            this.updateSnapshots(transaction);
            return this.witcheryFluidHandler.drain(stack, false).getAmount();
        }
        return 0L;
    }

    public boolean isResourceBlank() {
        return this.witcheryFluidHandler.getFluidInTank(this.tank).isEmpty();
    }

    @NotNull
    public FluidVariant getResource() {
        FluidVariant fluidVariant = FluidVariant.of((class_3611)this.witcheryFluidHandler.getFluidInTank(this.tank).getFluid());
        Intrinsics.checkNotNullExpressionValue((Object)fluidVariant, (String)"of(...)");
        return fluidVariant;
    }

    public long getAmount() {
        return this.witcheryFluidHandler.getFluidInTank(this.tank).getAmount();
    }

    public long getCapacity() {
        return this.witcheryFluidHandler.getTankCapacity(this.tank);
    }
}

