/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.network;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import net.bettercombat.config.ServerConfig;
import net.bettercombat.logic.AnimatedHand;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class Packets {

    public record Ack(String code) implements class_8710
    {
        public static class_2960 ID = class_2960.method_60655((String)"bettercombat", (String)"ack");
        public static final class_8710.class_9154<Ack> PACKET_ID = new class_8710.class_9154(ID);
        public static final class_9139<class_2540, Ack> CODEC = class_9139.method_56438(Ack::write, Ack::read);

        public void write(class_2540 buffer) {
            buffer.method_10814(this.code);
        }

        public static Ack read(class_2540 buffer) {
            String code = buffer.method_19772();
            return new Ack(code);
        }

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }
    }

    public record ConfigSync(String json) implements class_8710
    {
        public static class_2960 ID = class_2960.method_60655((String)"bettercombat", (String)"config_sync");
        public static final class_8710.class_9154<ConfigSync> PACKET_ID = new class_8710.class_9154(ID);
        public static final class_9139<class_2540, ConfigSync> CODEC = class_9139.method_56438(ConfigSync::write, ConfigSync::read);
        private static final Gson gson = new Gson();

        public static String serialize(ServerConfig config) {
            return gson.toJson((Object)config);
        }

        public void write(class_2540 buffer) {
            buffer.method_10814(this.json);
        }

        public static ConfigSync read(class_2540 buffer) {
            String json = buffer.method_19772();
            return new ConfigSync(json);
        }

        public ServerConfig deserialized() {
            return (ServerConfig)gson.fromJson(this.json, ServerConfig.class);
        }

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }
    }

    public record WeaponRegistrySync(List<String> chunks) implements class_8710
    {
        public static class_2960 ID = class_2960.method_60655((String)"bettercombat", (String)"weapon_registry");
        public static final class_8710.class_9154<WeaponRegistrySync> PACKET_ID = new class_8710.class_9154(ID);
        public static final class_9139<class_2540, WeaponRegistrySync> CODEC = class_9139.method_56438(WeaponRegistrySync::write, WeaponRegistrySync::read);

        public void write(class_2540 buffer) {
            buffer.method_53002(this.chunks.size());
            for (String chunk : this.chunks) {
                buffer.method_10814(chunk);
            }
        }

        public static WeaponRegistrySync read(class_2540 buffer) {
            int chunkCount = buffer.readInt();
            ArrayList<String> chunks = new ArrayList<String>();
            for (int i = 0; i < chunkCount; ++i) {
                chunks.add(buffer.method_19772());
            }
            return new WeaponRegistrySync(chunks);
        }

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }
    }

    public record AttackSound(double x, double y, double z, String soundId, float volume, float pitch, long seed) implements class_8710
    {
        public static class_2960 ID = class_2960.method_60655((String)"bettercombat", (String)"attack_sound");
        public static final class_8710.class_9154<AttackSound> PACKET_ID = new class_8710.class_9154(ID);
        public static final class_9139<class_9129, AttackSound> CODEC = class_9139.method_56438(AttackSound::write, AttackSound::read);

        public void write(class_2540 buffer) {
            buffer.method_52940(this.x);
            buffer.method_52940(this.y);
            buffer.method_52940(this.z);
            buffer.method_10814(this.soundId);
            buffer.method_52941(this.volume);
            buffer.method_52941(this.pitch);
            buffer.method_52974(this.seed);
        }

        public static AttackSound read(class_2540 buffer) {
            double x = buffer.readDouble();
            double y = buffer.readDouble();
            double z = buffer.readDouble();
            String soundId = buffer.method_19772();
            float volume = buffer.readFloat();
            float pitch = buffer.readFloat();
            long seed = buffer.readLong();
            return new AttackSound(x, y, z, soundId, volume, pitch, seed);
        }

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }
    }

    public record AttackAnimation(int playerId, AnimatedHand animatedHand, String animationName, float length, float upswing) implements class_8710
    {
        public static class_2960 ID = class_2960.method_60655((String)"bettercombat", (String)"attack_animation");
        public static final class_8710.class_9154<AttackAnimation> PACKET_ID = new class_8710.class_9154(ID);
        public static final class_9139<class_9129, AttackAnimation> CODEC = class_9139.method_56438(AttackAnimation::write, AttackAnimation::read);
        public static String StopSymbol = "!STOP!";

        public static AttackAnimation stop(int playerId, int length) {
            return new AttackAnimation(playerId, AnimatedHand.MAIN_HAND, StopSymbol, length, 0.0f);
        }

        public void write(class_2540 buffer) {
            buffer.method_53002(this.playerId);
            buffer.method_53002(this.animatedHand.ordinal());
            buffer.method_10814(this.animationName);
            buffer.method_52941(this.length);
            buffer.method_52941(this.upswing);
        }

        public static AttackAnimation read(class_2540 buffer) {
            int playerId = buffer.readInt();
            AnimatedHand animatedHand = AnimatedHand.values()[buffer.readInt()];
            String animationName = buffer.method_19772();
            float length = buffer.readFloat();
            float upswing = buffer.readFloat();
            return new AttackAnimation(playerId, animatedHand, animationName, length, upswing);
        }

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }
    }

    public record C2S_AttackRequest(int comboCount, boolean isSneaking, int selectedSlot, int[] entityIds) implements class_8710
    {
        public static class_2960 ID = class_2960.method_60655((String)"bettercombat", (String)"c2s_request_attack");
        public static final class_8710.class_9154<C2S_AttackRequest> PACKET_ID = new class_8710.class_9154(ID);
        public static final class_9139<class_9129, C2S_AttackRequest> CODEC = class_9139.method_56438(C2S_AttackRequest::write, C2S_AttackRequest::read);
        public static boolean UseVanillaPacket = true;

        public C2S_AttackRequest(int comboCount, boolean isSneaking, int selectedSlot, List<class_1297> entities) {
            this(comboCount, isSneaking, selectedSlot, C2S_AttackRequest.convertEntityList(entities));
        }

        private static int[] convertEntityList(List<class_1297> entities) {
            int[] ids = new int[entities.size()];
            for (int i = 0; i < entities.size(); ++i) {
                ids[i] = entities.get(i).method_5628();
            }
            return ids;
        }

        public void write(class_2540 buffer) {
            buffer.method_53002(this.comboCount);
            buffer.method_52964(this.isSneaking);
            buffer.method_53002(this.selectedSlot);
            buffer.method_10806(this.entityIds);
        }

        public static C2S_AttackRequest read(class_2540 buffer) {
            int comboCount = buffer.readInt();
            boolean isSneaking = buffer.readBoolean();
            int selectedSlot = buffer.readInt();
            int[] ids = buffer.method_10787();
            return new C2S_AttackRequest(comboCount, isSneaking, selectedSlot, ids);
        }

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }
    }
}

