/*
 * Decompiled with CFR 0.152.
 */
package net.paladins.client.entity;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4668;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import net.minecraft.class_918;
import net.paladins.entity.BarrierEntity;
import net.spell_engine.api.render.CustomLayers;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.client.compatibility.ShaderCompatibility;
import net.spell_engine.client.util.Color;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class BarrierEntityRenderer<T extends BarrierEntity>
extends class_897<T> {
    private final class_918 itemRenderer;
    public static final class_2960 blankTextureId = class_2960.method_60655((String)"paladins", (String)"item/barrier");
    public static final List<BarrierEntity> activeBarriers = new ArrayList<BarrierEntity>();
    private static final int[] LIGHT_UP_ORDER = new int[]{0, 2, 8, 6, 4, 3, 9, 1, 5, 10, 7, 11};

    public static void setup() {
        WorldRenderEvents.AFTER_TRANSLUCENT.register(context -> {
            class_4597.class_4598 vcProvider = class_310.method_1551().method_22940().method_23000();
            BarrierEntityRenderer.renderAllInWorld(context.matrixStack(), vcProvider, context.camera(), 0xF000F0, context.tickCounter().method_60637(true));
        });
    }

    public BarrierEntityRenderer(class_5617.class_5618 context) {
        super(context);
        this.itemRenderer = context.method_32168();
    }

    public class_2960 getTexture(T entity) {
        return null;
    }

    public void render(T entity, float yaw, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light) {
        if (entity.method_5805()) {
            activeBarriers.add((BarrierEntity)((Object)entity));
        }
        super.method_3936(entity, yaw, tickDelta, matrices, vertexConsumers, light);
    }

    public static void renderAllInWorld(class_4587 matrices, class_4597.class_4598 vertexConsumers, class_4184 camera, int light, float tickDelta) {
        matrices.method_22903();
        class_243 camPos = camera.method_19326();
        matrices.method_22904(-camPos.field_1352, -camPos.field_1351, -camPos.field_1350);
        Config config = ShaderCompatibility.isShaderPackInUse() ? Config.IRIS : Config.VANILLA;
        class_4588 vertexConsumer = vertexConsumers.getBuffer(config.layer());
        for (BarrierEntity entity : activeBarriers) {
            matrices.method_22903();
            matrices.method_22904(entity.method_23317(), entity.method_23318() + 1.0, entity.method_23321());
            BarrierEntityRenderer.renderShield(entity, matrices, vertexConsumer, light, tickDelta, config);
            matrices.method_22909();
        }
        vertexConsumers.method_22993();
        matrices.method_22909();
        activeBarriers.clear();
    }

    public static void renderShield(BarrierEntity entity, class_4587 matrices, class_4588 vertexConsumer, int light, float tickDelta, Config config) {
        long time;
        Spell spell = entity.getSpell();
        if (spell == null) {
            return;
        }
        float radius = spell.range * 0.8f;
        float zSlant = 0.3926991f;
        float size = radius * class_3532.method_15355((float)3.0f) / 3.0f;
        float offset = radius * (class_3532.method_15374((float)zSlant) + 1.0f);
        int overlayUV = class_4608.field_21444;
        class_1058 sprite = (class_1058)class_310.method_1551().method_1549(class_1059.field_5275).apply(blankTextureId);
        float u1 = sprite.method_4594();
        float u2 = sprite.method_4577();
        float v1 = sprite.method_4593();
        float v2 = sprite.method_4575();
        double fullTime = (double)entity.method_37908().method_8510() / 20.0;
        double delta = (fullTime - (double)(time = entity.method_37908().method_8510() / 20L)) * 2.0;
        if (delta > 1.0) {
            delta = 2.0 - delta;
        }
        delta = 1.0 - Math.pow(1.0 - delta, 4.0);
        for (int m = 0; m < 2; ++m) {
            for (int i = 0; i < 6; ++i) {
                matrices.method_22903();
                if (m == 0) {
                    matrices.method_22907(class_7833.field_40714.rotation((float)Math.PI));
                }
                matrices.method_46416(offset, 0.0f, 0.0f);
                matrices.method_49278(class_7833.field_40716.rotation((float)((double)((float)i / 3.0f) * Math.PI)), -offset, 0.0f, 0.0f);
                matrices.method_22907(class_7833.field_40718.rotation(zSlant));
                float r = config.red();
                float g = config.green();
                float b = config.blue();
                float alpha = config.alpha();
                if (entity.field_6012 >= entity.getTimeToLive() - entity.expirationDuration()) {
                    int relAge = entity.getTimeToLive() - entity.expirationDuration() - entity.field_6012;
                    alpha = config.expirationPulseAlpha * Math.abs(class_3532.method_15362((float)((float)((double)((float)relAge * 1.25f / 10.0f) * Math.PI))));
                } else if (time % 12L == (long)LIGHT_UP_ORDER[i + m * 6]) {
                    float glow = (float)(0.5 * delta);
                    r = BarrierEntityRenderer.blend(r, 1.0f, glow);
                    g = BarrierEntityRenderer.blend(g, 1.0f, glow);
                    b = BarrierEntityRenderer.blend(b, 1.0f, glow);
                    alpha = BarrierEntityRenderer.blend(alpha, config.panelFlashAlpha(), glow);
                }
                Matrix4f matrix = new Matrix4f((Matrix4fc)matrices.method_23760().method_23761());
                class_4587.class_4665 matrixEntry = matrices.method_23760();
                vertexConsumer.method_22918(matrix, 0.0f, radius, -size).method_22915(r, g, b, 0.0f).method_22913(u1, v2).method_22922(overlayUV).method_60803(light).method_60831(matrixEntry, 0.0f, 0.0f, 0.0f);
                vertexConsumer.method_22918(matrix, 0.0f, 0.0f, -size).method_22915(r, g, b, alpha).method_22913(u1, v1).method_22922(overlayUV).method_60803(light).method_60831(matrixEntry, 0.0f, 0.0f, 0.0f);
                vertexConsumer.method_22918(matrix, 0.0f, 0.0f, size).method_22915(r, g, b, alpha).method_22913(u2, v1).method_22922(overlayUV).method_60803(light).method_60831(matrixEntry, 0.0f, 0.0f, 0.0f);
                vertexConsumer.method_22918(matrix, 0.0f, radius, size).method_22915(r, g, b, 0.0f).method_22913(u2, v2).method_22922(overlayUV).method_60803(light).method_60831(matrixEntry, 0.0f, 0.0f, 0.0f);
                vertexConsumer.method_22918(matrix, 0.0f, radius, size).method_22915(r, g, b, 0.0f).method_22913(u1, v2).method_22922(overlayUV).method_60803(light).method_60831(matrixEntry, 0.0f, 0.0f, 0.0f);
                vertexConsumer.method_22918(matrix, 0.0f, 0.0f, size).method_22915(r, g, b, alpha).method_22913(u1, v1).method_22922(overlayUV).method_60803(light).method_60831(matrixEntry, 0.0f, 0.0f, 0.0f);
                vertexConsumer.method_22918(matrix, 0.0f, 0.0f, -size).method_22915(r, g, b, alpha).method_22913(u2, v1).method_22922(overlayUV).method_60803(light).method_60831(matrixEntry, 0.0f, 0.0f, 0.0f);
                vertexConsumer.method_22918(matrix, 0.0f, radius, -size).method_22915(r, g, b, 0.0f).method_22913(u2, v2).method_22922(overlayUV).method_60803(light).method_60831(matrixEntry, 0.0f, 0.0f, 0.0f);
                matrices.method_22909();
                matrices.method_22903();
                Matrix4f newMatrix = matrices.method_23760().method_23761();
                if (m == 0) {
                    matrices.method_22907(class_7833.field_40714.rotation((float)Math.PI));
                }
                matrices.method_46416(offset, 0.0f, 0.0f);
                matrices.method_49278(class_7833.field_40716.rotation((float)((double)((float)(i - 1) / 3.0f) * Math.PI)), -offset, 0.0f, 0.0f);
                matrices.method_22907(class_7833.field_40718.rotation(zSlant));
                vertexConsumer.method_22918(matrix, 0.0f, radius, size).method_22915(r, g, b, 0.0f).method_22913(u2, v2).method_22922(overlayUV).method_60803(light).method_60831(matrixEntry, 0.0f, 0.0f, 0.0f);
                vertexConsumer.method_22918(matrix, 0.0f, 0.0f, size).method_22915(r, g, b, alpha).method_22913(u2, v1).method_22922(overlayUV).method_60803(light).method_60831(matrixEntry, 0.0f, 0.0f, 0.0f);
                vertexConsumer.method_22918(newMatrix, 0.0f, 0.0f, -size).method_22915(r, g, b, alpha).method_22913(u1, v1).method_22922(overlayUV).method_60803(light).method_60831(matrixEntry, 0.0f, 0.0f, 0.0f);
                vertexConsumer.method_22918(matrix, 0.0f, radius, size).method_22915(r, g, b, 0.0f).method_22913(u1, v2).method_22922(overlayUV).method_60803(light).method_60831(matrixEntry, 0.0f, 0.0f, 0.0f);
                vertexConsumer.method_22918(matrix, 0.0f, radius, size).method_22915(r, g, b, 0.0f).method_22913(u2, v2).method_22922(overlayUV).method_60803(light).method_60831(matrixEntry, 0.0f, 0.0f, 0.0f);
                vertexConsumer.method_22918(newMatrix, 0.0f, 0.0f, -size).method_22915(r, g, b, alpha).method_22913(u1, v1).method_22922(overlayUV).method_60803(light).method_60831(matrixEntry, 0.0f, 0.0f, 0.0f);
                vertexConsumer.method_22918(matrix, 0.0f, 0.0f, size).method_22915(r, g, b, alpha).method_22913(u2, v1).method_22922(overlayUV).method_60803(light).method_60831(matrixEntry, 0.0f, 0.0f, 0.0f);
                vertexConsumer.method_22918(matrix, 0.0f, radius, size).method_22915(r, g, b, 0.0f).method_22913(u1, v2).method_22922(overlayUV).method_60803(light).method_60831(matrixEntry, 0.0f, 0.0f, 0.0f);
                matrices.method_22909();
            }
        }
    }

    public static float blend(float min, float max, float delta) {
        return min + (max - min) * delta;
    }

    private record Config(class_1921 layer, float red, float green, float blue, float alpha, float panelFlashAlpha, float expirationPulseAlpha) {
        private static final Color shield = Color.from((int)0xFFCC66);
        public static final Config VANILLA = new Config(CustomLayers.create((class_2960)class_1059.field_5275, (class_4668.class_5942)class_4668.field_29409, (class_4668.class_4685)class_4668.field_21370, (class_4668.class_4671)class_4668.field_21345, (class_4668.class_4686)class_4668.field_21350, (class_4668.class_4679)class_4668.field_21385, (class_4668.class_4678)class_4668.field_21358, (boolean)true), shield.red(), shield.green(), shield.blue(), 0.8f, 0.9f, 1.0f);
        public static final Config IRIS = new Config(CustomLayers.create((class_2960)class_1059.field_5275, (class_4668.class_5942)class_4668.field_29429, (class_4668.class_4685)class_4668.field_21367, (class_4668.class_4671)class_4668.field_21345, (class_4668.class_4686)class_4668.field_21350, (class_4668.class_4679)class_4668.field_21385, (class_4668.class_4678)class_4668.field_21358, (boolean)false), shield.red(), shield.green(), shield.blue(), 0.5f, 1.0f, 0.8f);
    }
}

