/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.neoforge.blockentities;

import com.fizzware.dramaticdoors.neoforge.blockentities.DDBlockEntities;
import com.fizzware.dramaticdoors.neoforge.tags.DDItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TallNetheriteDoorBlockEntity
extends BlockEntity {
    public String password = null;

    public TallNetheriteDoorBlockEntity(BlockPos pos, BlockState state) {
        super(DDBlockEntities.TALL_NETHERITE_DOOR, pos, state);
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (this.password != null) {
            tag.putString("Password", this.password);
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains("Password")) {
            this.password = tag.getString("Password");
        }
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPassword(ItemStack stack) {
        this.setPassword(stack.getHoverName().getString());
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    public void clearOwner() {
        this.password = null;
    }

    public static boolean isCorrectKey(ItemStack key, String password) {
        return key.getHoverName().getString().equals(password);
    }

    public boolean isCorrectKey(ItemStack key) {
        return TallNetheriteDoorBlockEntity.isCorrectKey(key, this.password);
    }

    public static KeyStatus hasKeyInInventory(Player player, String key) {
        if (key == null) {
            return KeyStatus.CORRECT_KEY;
        }
        KeyStatus found = KeyStatus.INCORRECT_KEY;
        Inventory inventory = player.getInventory();
        for (int idx = 0; idx < inventory.getContainerSize(); ++idx) {
            ItemStack stack = inventory.getItem(idx);
            if (!stack.is(DDItemTags.KEY)) continue;
            found = KeyStatus.INCORRECT_KEY;
            if (!TallNetheriteDoorBlockEntity.isCorrectKey(stack, key)) continue;
            return KeyStatus.CORRECT_KEY;
        }
        return found;
    }

    public static boolean doesPlayerHaveKeyToOpen(Player player, String lockPassword, boolean feedbackMessage, @Nullable String translName) {
        KeyStatus key = TallNetheriteDoorBlockEntity.hasKeyInInventory(player, lockPassword);
        if (key == KeyStatus.INCORRECT_KEY) {
            if (feedbackMessage) {
                player.displayClientMessage((Component)Component.translatable((String)"message.supplementaries.safe.incorrect_key"), true);
            }
            return false;
        }
        if (key == KeyStatus.CORRECT_KEY) {
            return true;
        }
        if (feedbackMessage) {
            player.displayClientMessage((Component)Component.translatable((String)("message.supplementaries." + translName + ".locked")), true);
        }
        return false;
    }

    public boolean handleAction(Player player, InteractionHand handIn, String translName) {
        if (player.isSpectator()) {
            return false;
        }
        ItemStack stack = player.getItemInHand(handIn);
        boolean isKey = stack.is(DDItemTags.KEY);
        if (player.isCrouching() && isKey && (player.isCreative() || this.isCorrectKey(stack))) {
            this.clearOwner();
            player.displayClientMessage((Component)Component.translatable((String)"message.supplementaries.safe.cleared"), true);
            this.level.playSound(null, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5, SoundEvents.IRON_TRAPDOOR_OPEN, SoundSource.BLOCKS, 0.5f, 1.5f);
            return false;
        }
        if (this.password == null) {
            if (isKey) {
                this.setPassword(stack);
                player.displayClientMessage((Component)Component.translatable((String)"message.supplementaries.safe.assigned_key", (Object[])new Object[]{this.password}), true);
                this.level.playSound(null, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5, SoundEvents.IRON_TRAPDOOR_OPEN, SoundSource.BLOCKS, 0.5f, 1.5f);
                return false;
            }
            return true;
        }
        return player.isCreative() || TallNetheriteDoorBlockEntity.doesPlayerHaveKeyToOpen(player, this.password, true, translName);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public static enum KeyStatus {
        CORRECT_KEY,
        INCORRECT_KEY,
        NO_KEY;

    }
}

