/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.neoforge.blocks;

import com.fizzware.dramaticdoors.neoforge.blocks.TallDoorBlock;
import com.fizzware.dramaticdoors.neoforge.state.properties.DDBlockStateProperties;
import com.fizzware.dramaticdoors.neoforge.state.properties.TripleBlockPart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class TallLeadDoorBlock
extends TallDoorBlock {
    public static final IntegerProperty OPENING_PROGRESS = DDBlockStateProperties.OPENING_PROGRESS;

    public TallLeadDoorBlock(BlockSetType blockset, Block from) {
        super(blockset, from);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.FALSE)).setValue((Property)HINGE, (Comparable)DoorHingeSide.LEFT)).setValue((Property)POWERED, (Comparable)Boolean.FALSE)).setValue((Property)THIRD, (Comparable)((Object)TripleBlockPart.LOWER))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)OPENING_PROGRESS, (Comparable)Integer.valueOf(0)));
    }

    public boolean canBeOpened(BlockState state) {
        return (Integer)state.getValue((Property)OPENING_PROGRESS) == 2;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{THIRD, FACING, OPEN, HINGE, POWERED, WATERLOGGED, OPENING_PROGRESS});
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (this.canBeOpened(state)) {
            TallDoorBlock.tryOpenDoubleDoor(level, state, pos);
            state = (BlockState)((BlockState)state.cycle((Property)OPEN)).setValue((Property)OPENING_PROGRESS, (Comparable)Integer.valueOf(0));
            level.setBlock(pos, state, 10);
            level.levelEvent(player, (Boolean)state.getValue((Property)OPEN) != false ? 1005 : 1011, pos, 0);
        } else {
            int p = (Integer)state.getValue((Property)OPENING_PROGRESS) + 1;
            if (state.getValue((Property)THIRD) == TripleBlockPart.UPPER) {
                level.setBlock(pos.below(1), (BlockState)level.getBlockState(pos.below(1)).setValue((Property)OPENING_PROGRESS, (Comparable)Integer.valueOf(p)), 18);
                level.setBlock(pos.below(2), (BlockState)level.getBlockState(pos.below(2)).setValue((Property)OPENING_PROGRESS, (Comparable)Integer.valueOf(p)), 18);
            } else if (state.getValue((Property)THIRD) == TripleBlockPart.MIDDLE) {
                level.setBlock(pos.above(), (BlockState)level.getBlockState(pos.above()).setValue((Property)OPENING_PROGRESS, (Comparable)Integer.valueOf(p)), 18);
                level.setBlock(pos.below(), (BlockState)level.getBlockState(pos.below()).setValue((Property)OPENING_PROGRESS, (Comparable)Integer.valueOf(p)), 18);
            } else {
                level.setBlock(pos.above(1), (BlockState)level.getBlockState(pos.above(1)).setValue((Property)OPENING_PROGRESS, (Comparable)Integer.valueOf(p)), 18);
                level.setBlock(pos.above(2), (BlockState)level.getBlockState(pos.above(2)).setValue((Property)OPENING_PROGRESS, (Comparable)Integer.valueOf(p)), 18);
            }
            level.setBlock(pos, (BlockState)state.setValue((Property)OPENING_PROGRESS, (Comparable)Integer.valueOf(p)), 18);
            level.playSound(player, pos, SoundEvents.NETHERITE_BLOCK_STEP, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.scheduleTick(pos, (Block)this, 20);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    @Override
    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource pRandom) {
        level.setBlock(pos, (BlockState)state.setValue((Property)OPENING_PROGRESS, (Comparable)Integer.valueOf(0)), 18);
        if (state.getValue((Property)THIRD) == TripleBlockPart.UPPER) {
            level.setBlock(pos.below(1), (BlockState)level.getBlockState(pos.below(1)).setValue((Property)OPENING_PROGRESS, (Comparable)Integer.valueOf(0)), 18);
            level.setBlock(pos.below(2), (BlockState)level.getBlockState(pos.below(2)).setValue((Property)OPENING_PROGRESS, (Comparable)Integer.valueOf(0)), 18);
        } else if (state.getValue((Property)THIRD) == TripleBlockPart.MIDDLE) {
            level.setBlock(pos.above(), (BlockState)level.getBlockState(pos.above()).setValue((Property)OPENING_PROGRESS, (Comparable)Integer.valueOf(0)), 18);
            level.setBlock(pos.below(), (BlockState)level.getBlockState(pos.below()).setValue((Property)OPENING_PROGRESS, (Comparable)Integer.valueOf(0)), 18);
        } else {
            level.setBlock(pos.above(1), (BlockState)level.getBlockState(pos.above(1)).setValue((Property)OPENING_PROGRESS, (Comparable)Integer.valueOf(0)), 18);
            level.setBlock(pos.above(2), (BlockState)level.getBlockState(pos.above(2)).setValue((Property)OPENING_PROGRESS, (Comparable)Integer.valueOf(0)), 18);
        }
    }
}

