/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.neoforge.neoforge.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FenceGateBlock.class})
public class FenceGateBlockMixin
extends Block {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public FenceGateBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Inject(at={@At(value="TAIL")}, method={"<init>(Lnet/minecraft/world/level/block/state/properties/WoodType;Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V"})
    private void enhanceConstructor(WoodType woodtype, BlockBehaviour.Properties properties, CallbackInfo callback) {
        ((FenceGateBlock)this).registerDefaultState((BlockState)((FenceGateBlock)this).defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Inject(at={@At(value="TAIL")}, method={"createBlockStateDefinition(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V"})
    protected void injectBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder, CallbackInfo callback) {
        builder.add(new Property[]{WATERLOGGED});
    }

    @Inject(at={@At(value="HEAD")}, method={"getStateForPlacement(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/level/block/state/BlockState;"}, cancellable=true)
    private void injectPlacementState(BlockPlaceContext context, CallbackInfoReturnable<BlockState> callback) {
        BlockPos blockpos = context.getClickedPos();
        Level level = context.getLevel();
        boolean flag = level.hasNeighborSignal(blockpos);
        boolean waterfilled = level.getFluidState(blockpos).getType() == Fluids.WATER;
        Direction direction = context.getHorizontalDirection();
        Direction.Axis direction$axis = direction.getAxis();
        boolean flag1 = direction$axis == Direction.Axis.Z && (((FenceGateBlock)this).isWall(level.getBlockState(blockpos.west())) || ((FenceGateBlock)this).isWall(level.getBlockState(blockpos.east()))) || direction$axis == Direction.Axis.X && (((FenceGateBlock)this).isWall(level.getBlockState(blockpos.north())) || ((FenceGateBlock)this).isWall(level.getBlockState(blockpos.south())));
        callback.setReturnValue((Object)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((FenceGateBlock)this).defaultBlockState().setValue((Property)FenceGateBlock.FACING, (Comparable)direction)).setValue((Property)FenceGateBlock.OPEN, (Comparable)Boolean.valueOf(flag))).setValue((Property)FenceGateBlock.POWERED, (Comparable)Boolean.valueOf(flag))).setValue((Property)FenceGateBlock.IN_WALL, (Comparable)Boolean.valueOf(flag1))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterfilled))));
        callback.cancel();
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }
}

