/*
 * Decompiled with CFR 0.152.
 */
package com.saltywater.simplywalk.client;

import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_1792;
import net.minecraft.class_1829;
import net.minecraft.class_1831;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_742;
import net.minecraft.class_746;

public class SimplyWalkClient
implements ClientModInitializer {
    private static class_304 walkKeyBinding;
    private static class_304 combatKeyBinding;
    private boolean isWalking = false;
    private boolean isInCombat = false;
    private KeyframeAnimationPlayer walkAnimationPlayer;
    private static final float WALK_SPEED_MULTIPLIER = 0.05f;
    private static final float NORMAL_SPEED_MULTIPLIER = 0.1f;
    private int initialFov;
    private class_2960 lastAnimationId;

    public void onInitializeClient() {
        System.out.println("[SimplyWalk] Initializing client-side networking");
        walkKeyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.simplywalk.toggle", 67, "category.simplywalk"));
        combatKeyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.simplywalk.toggleCombat", 86, "category.simplywalk"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (combatKeyBinding.method_1436()) {
                this.toggleCombatState(client);
            }
            if (!this.isInCombat && walkKeyBinding.method_1436()) {
                this.toggleWalkState(client);
            }
            if (this.isInCombat && client.field_1724 != null) {
                if (this.isPlayerMoving(client)) {
                    if (client.field_1724.field_6250 < 0.0f) {
                        this.triggerBackCombatWalkAnimation(client);
                    } else {
                        this.triggerCombatWalkAnimation(client);
                    }
                    this.applyWalkingVelocity(client);
                } else {
                    this.stopWalkAnimation(client);
                }
            } else if (this.isWalking && client.field_1724 != null) {
                if (this.isPlayerMoving(client)) {
                    if (client.field_1724.field_6250 < 0.0f) {
                        boolean isHoldingWeaponOrTool;
                        class_1792 heldItem = client.field_1724.method_6047().method_7909();
                        boolean bl = isHoldingWeaponOrTool = heldItem instanceof class_1831 || heldItem instanceof class_1829;
                        if (isHoldingWeaponOrTool) {
                            this.triggerBackSwordWalkAnimation(client);
                        } else {
                            this.triggerBackWalkAnimation(client);
                        }
                    } else {
                        this.triggerWalkAnimation(client);
                    }
                    this.applyWalkingVelocity(client);
                } else {
                    this.stopWalkAnimation(client);
                }
            }
        });
    }

    private void toggleWalkState(class_310 client) {
        boolean bl = this.isWalking = !this.isWalking;
        if (client.field_1724 != null) {
            if (this.isWalking) {
                this.initialFov = (Integer)client.field_1690.method_41808().method_41753();
                client.field_1690.method_41808().method_41748((Object)this.initialFov);
                System.out.println("[SimplyWalk] Walking state enabled");
            } else {
                this.stopWalkAnimation(client);
                System.out.println("[SimplyWalk] Walking state disabled");
            }
        }
    }

    private void toggleCombatState(class_310 client) {
        boolean bl = this.isInCombat = !this.isInCombat;
        if (client.field_1724 != null) {
            if (this.isInCombat) {
                this.isWalking = false;
                this.initialFov = (Integer)client.field_1690.method_41808().method_41753();
                client.field_1690.method_41808().method_41748((Object)this.initialFov);
                System.out.println("[SimplyWalk] Combat mode enabled");
            } else {
                this.stopWalkAnimation(client);
                System.out.println("[SimplyWalk] Combat mode disabled");
            }
        }
    }

    private void applyWalkingVelocity(class_310 client) {
        if (client.field_1724 != null) {
            float forward = client.field_1724.field_6250;
            float sideways = client.field_1724.field_6212;
            client.field_1724.method_18800(client.field_1724.method_18798().field_1352 * (double)0.05f, client.field_1724.method_18798().field_1351, client.field_1724.method_18798().field_1350 * (double)0.05f);
            client.field_1724.field_6037 = true;
        }
    }

    private void triggerWalkAnimation(class_310 client) {
        if (client.field_1724 != null) {
            class_2960 animationId;
            class_746 player = client.field_1724;
            class_1792 heldItem = player.method_6047().method_7909();
            boolean isHoldingWeaponOrTool = heldItem instanceof class_1831 || heldItem instanceof class_1829;
            class_2960 class_29602 = animationId = isHoldingWeaponOrTool ? class_2960.method_60655((String)"simplywalk", (String)"swordwalk") : class_2960.method_60655((String)"simplywalk", (String)"walk");
            if (!animationId.equals((Object)this.lastAnimationId)) {
                this.stopWalkAnimation(client);
                KeyframeAnimation selectedAnimation = (KeyframeAnimation)PlayerAnimationRegistry.getAnimation((class_2960)animationId);
                if (selectedAnimation != null) {
                    AnimationStack animationStack = PlayerAnimationAccess.getPlayerAnimLayer((class_742)player);
                    this.walkAnimationPlayer = new KeyframeAnimationPlayer(selectedAnimation);
                    animationStack.addAnimLayer(0, (IAnimation)this.walkAnimationPlayer);
                    this.lastAnimationId = animationId;
                }
            }
        }
    }

    private void triggerBackWalkAnimation(class_310 client) {
        if (client.field_1724 != null) {
            class_746 player = client.field_1724;
            class_2960 animationId = class_2960.method_60655((String)"simplywalk", (String)"backwalk");
            if (!animationId.equals((Object)this.lastAnimationId)) {
                this.stopWalkAnimation(client);
                KeyframeAnimation backWalkAnimation = (KeyframeAnimation)PlayerAnimationRegistry.getAnimation((class_2960)animationId);
                if (backWalkAnimation != null) {
                    AnimationStack animationStack = PlayerAnimationAccess.getPlayerAnimLayer((class_742)player);
                    this.walkAnimationPlayer = new KeyframeAnimationPlayer(backWalkAnimation);
                    animationStack.addAnimLayer(0, (IAnimation)this.walkAnimationPlayer);
                    this.lastAnimationId = animationId;
                }
            }
        }
    }

    private void triggerBackSwordWalkAnimation(class_310 client) {
        if (client.field_1724 != null) {
            class_746 player = client.field_1724;
            class_2960 animationId = class_2960.method_60655((String)"simplywalk", (String)"backswordwalk");
            if (!animationId.equals((Object)this.lastAnimationId)) {
                this.stopWalkAnimation(client);
                KeyframeAnimation backSwordAnimation = (KeyframeAnimation)PlayerAnimationRegistry.getAnimation((class_2960)animationId);
                if (backSwordAnimation != null) {
                    AnimationStack animationStack = PlayerAnimationAccess.getPlayerAnimLayer((class_742)player);
                    this.walkAnimationPlayer = new KeyframeAnimationPlayer(backSwordAnimation);
                    animationStack.addAnimLayer(0, (IAnimation)this.walkAnimationPlayer);
                    this.lastAnimationId = animationId;
                }
            }
        }
    }

    private void triggerCombatWalkAnimation(class_310 client) {
        if (client.field_1724 != null) {
            class_746 player = client.field_1724;
            class_2960 animationId = class_2960.method_60655((String)"simplywalk", (String)"combatwalk");
            if (!animationId.equals((Object)this.lastAnimationId)) {
                this.stopWalkAnimation(client);
                KeyframeAnimation combatAnimation = (KeyframeAnimation)PlayerAnimationRegistry.getAnimation((class_2960)animationId);
                if (combatAnimation != null) {
                    AnimationStack animationStack = PlayerAnimationAccess.getPlayerAnimLayer((class_742)player);
                    this.walkAnimationPlayer = new KeyframeAnimationPlayer(combatAnimation);
                    animationStack.addAnimLayer(0, (IAnimation)this.walkAnimationPlayer);
                    this.lastAnimationId = animationId;
                }
            }
        }
    }

    private void triggerBackCombatWalkAnimation(class_310 client) {
        if (client.field_1724 != null) {
            class_746 player = client.field_1724;
            class_2960 animationId = class_2960.method_60655((String)"simplywalk", (String)"backcombatwalk");
            if (!animationId.equals((Object)this.lastAnimationId)) {
                this.stopWalkAnimation(client);
                KeyframeAnimation backCombatAnimation = (KeyframeAnimation)PlayerAnimationRegistry.getAnimation((class_2960)animationId);
                if (backCombatAnimation != null) {
                    AnimationStack animationStack = PlayerAnimationAccess.getPlayerAnimLayer((class_742)player);
                    this.walkAnimationPlayer = new KeyframeAnimationPlayer(backCombatAnimation);
                    animationStack.addAnimLayer(0, (IAnimation)this.walkAnimationPlayer);
                    this.lastAnimationId = animationId;
                }
            }
        }
    }

    private void stopWalkAnimation(class_310 client) {
        if (client.field_1724 != null) {
            class_746 player = client.field_1724;
            AnimationStack animationStack = PlayerAnimationAccess.getPlayerAnimLayer((class_742)player);
            if (this.walkAnimationPlayer != null) {
                animationStack.removeLayer((IAnimation)this.walkAnimationPlayer);
                this.walkAnimationPlayer = null;
                this.lastAnimationId = null;
            }
        }
    }

    private boolean isPlayerMoving(class_310 client) {
        return client.field_1724 != null && (client.field_1724.field_6250 != 0.0f || client.field_1724.field_6212 != 0.0f);
    }
}

