/*
 * Decompiled with CFR 0.152.
 */
package net.spell_power.config;

import java.util.Map;
import net.spell_power.api.SpellPowerMechanics;
import net.spell_power.internals.SpellStatusEffect;

public class AttributesConfig {
    public AttributeScope attributes_container_injection_scope = AttributeScope.LIVING_ENTITY;
    public double base_spell_critical_chance_percentage = 5.0;
    public double base_spell_critical_damage_percentage = 50.0;
    public SpellStatusEffect.Config spell_power_effect = new SpellStatusEffect.Config(0.1f);
    public Map<String, SpellStatusEffect.Config> secondary_effects;
    public float resistance_reduction_cap = 0.75f;

    public static AttributesConfig defaults() {
        AttributesConfig config = new AttributesConfig();
        config.secondary_effects = Map.of(SpellPowerMechanics.CRITICAL_CHANCE.name, new SpellStatusEffect.Config(0.05f), SpellPowerMechanics.CRITICAL_DAMAGE.name, new SpellStatusEffect.Config(0.1f), SpellPowerMechanics.HASTE.name, new SpellStatusEffect.Config(0.05f));
        return config;
    }

    public boolean isValid() {
        AttributesConfig defaults = AttributesConfig.defaults();
        if (this.attributes_container_injection_scope == null) {
            return false;
        }
        if (this.secondary_effects == null) {
            return false;
        }
        for (Map.Entry<String, SpellStatusEffect.Config> entry : defaults.secondary_effects.entrySet()) {
            if (this.secondary_effects.containsKey(entry.getKey())) continue;
            return false;
        }
        return this.spell_power_effect != null;
    }

    public static enum AttributeScope {
        LIVING_ENTITY,
        PLAYER_ENTITY;

    }
}

