/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_pin_cushions;

import com.mojang.datafixers.util.Pair;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.random.RandomGenerator;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1667;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4592;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5597;
import net.minecraft.class_5617;
import net.minecraft.class_5819;
import net.minecraft.class_583;
import net.minecraft.class_630;
import net.minecraft.class_7198;
import net.minecraft.class_7833;
import net.minecraft.class_898;
import net.minecraft.class_922;
import org.jetbrains.annotations.Nullable;

public abstract class PinCushionLayer<T extends class_1309, M extends class_583<T>>
extends class_3887<T, M> {
    public PinCushionLayer(class_922<T, M> renderer) {
        super(renderer);
    }

    protected abstract int numStuck(T var1);

    protected abstract void renderStuckItem(class_4587 var1, class_4597 var2, int var3, class_1297 var4, float var5, float var6, float var7, float var8);

    public void render(class_4587 poseStack, class_4597 buffer, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        int i = this.numStuck(livingEntity);
        class_5819 randomSource = class_5819.method_43049((long)livingEntity.method_5628());
        if (i > 0) {
            for (int j = 0; j < i; ++j) {
                Pair<class_630, Runnable> modelPart;
                class_583 class_5832;
                Random partRand = new Random(j);
                poseStack.method_22903();
                class_583 model = this.method_17165();
                Objects.requireNonNull(model);
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_4592.class, class_7198.class, class_5597.class}, (Object)class_5832, n)) {
                    case 0: {
                        class_4592 animal = (class_4592)class_5832;
                        Pair<class_630, Runnable> pair = this.bestFromList(animal.method_22946(), animal.method_22948(), partRand, poseStack);
                        break;
                    }
                    case 1: {
                        class_7198 frogModel = (class_7198)class_5832;
                        Pair<class_630, Runnable> pair = this.bestFromListMutable(new ArrayList<class_630>(Collections.singleton(frogModel.method_32008())), partRand, poseStack, true);
                        break;
                    }
                    case 2: {
                        class_5597 hierarchicalModel = (class_5597)class_5832;
                        Pair<class_630, Runnable> pair = this.bestFromListMutable(new ArrayList<class_630>(hierarchicalModel.method_32008().field_3661.values()), partRand, poseStack, true);
                        break;
                    }
                    default: {
                        Pair<class_630, Runnable> pair = modelPart = null;
                    }
                }
                if (modelPart == null) {
                    poseStack.method_22909();
                    return;
                }
                ((Runnable)modelPart.getSecond()).run();
                float f = randomSource.method_43057();
                float g = randomSource.method_43057();
                float h = randomSource.method_43057();
                if (!((class_630)modelPart.getFirst()).field_3663.isEmpty()) {
                    class_630.class_628 cube = ((class_630)modelPart.getFirst()).method_22700(randomSource);
                    float k = class_3532.method_16439((float)f, (float)cube.field_3645, (float)cube.field_3648) / 16.0f;
                    float l = class_3532.method_16439((float)g, (float)cube.field_3644, (float)cube.field_3647) / 16.0f;
                    float m = class_3532.method_16439((float)h, (float)cube.field_3643, (float)cube.field_3646) / 16.0f;
                    poseStack.method_46416(k, l, m);
                }
                f = -1.0f * (f * 2.0f - 1.0f);
                g = -1.0f * (g * 2.0f - 1.0f);
                h = -1.0f * (h * 2.0f - 1.0f);
                this.renderStuckItem(poseStack, buffer, packedLight, (class_1297)livingEntity, f, g, h, partialTicks);
                poseStack.method_22909();
            }
        }
    }

    @Nullable
    private Pair<class_630, Runnable> bestFromList(Iterable<class_630> part1, Iterable<class_630> part2, RandomGenerator randomSource, class_4587 poseStack) {
        ArrayList<class_630> list = new ArrayList<class_630>();
        part1.forEach(list::add);
        part2.forEach(list::add);
        return this.bestFromListMutable(list, randomSource, poseStack, true);
    }

    @Nullable
    private Pair<class_630, Runnable> bestFromListMutable(List<class_630> partsMutable, RandomGenerator randomSource, class_4587 poseStack, boolean firstIteration) {
        Collections.shuffle(partsMutable, randomSource);
        for (class_630 modelPart : partsMutable) {
            Pair<class_630, Runnable> child;
            if (!modelPart.field_3665) continue;
            if (!modelPart.field_3663.isEmpty() && !modelPart.field_38456) {
                return Pair.of((Object)modelPart, () -> modelPart.method_22703(poseStack));
            }
            if (modelPart.field_3661.isEmpty() || (child = this.bestFromListMutable(new ArrayList<class_630>(modelPart.field_3661.values()), randomSource, poseStack, false)) == null) continue;
            Runnable runnable = (Runnable)child.getSecond();
            return Pair.of((Object)((class_630)child.getFirst()), () -> {
                modelPart.method_22703(poseStack);
                runnable.run();
            });
        }
        if (firstIteration && !partsMutable.isEmpty()) {
            class_630 part = partsMutable.getFirst();
            return Pair.of((Object)part, () -> part.method_22703(poseStack));
        }
        return null;
    }

    public static class BeeStingerLayer<T extends class_1309, M extends class_583<T>>
    extends PinCushionLayer<T, M> {
        private static final class_2960 BEE_STINGER_LOCATION = class_2960.method_60656((String)"textures/entity/bee/bee_stinger.png");

        public BeeStingerLayer(class_922<T, M> renderer) {
            super(renderer);
        }

        @Override
        protected int numStuck(T entity) {
            return entity.method_21753();
        }

        @Override
        protected void renderStuckItem(class_4587 poseStack, class_4597 buffer, int packedLight, class_1297 entity, float x, float y, float z, float partialTick) {
            float f = class_3532.method_15355((float)(x * x + z * z));
            float g = (float)(Math.atan2(x, z) * 57.2957763671875);
            float h = (float)(Math.atan2(y, f) * 57.2957763671875);
            poseStack.method_46416(0.0f, 0.0f, 0.0f);
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(g - 90.0f));
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(h));
            float i = 0.0f;
            float j = 0.125f;
            float k = 0.0f;
            float l = 0.0625f;
            float m = 0.03125f;
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(45.0f));
            poseStack.method_22905(0.03125f, 0.03125f, 0.03125f);
            poseStack.method_46416(2.5f, 0.0f, 0.0f);
            class_4588 vertexConsumer = buffer.getBuffer(class_1921.method_23578((class_2960)BEE_STINGER_LOCATION));
            for (int n = 0; n < 4; ++n) {
                poseStack.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
                class_4587.class_4665 pose = poseStack.method_23760();
                BeeStingerLayer.vertex(vertexConsumer, pose, -4.5f, -1, 0.0f, 0.0f, packedLight);
                BeeStingerLayer.vertex(vertexConsumer, pose, 4.5f, -1, 0.125f, 0.0f, packedLight);
                BeeStingerLayer.vertex(vertexConsumer, pose, 4.5f, 1, 0.125f, 0.0625f, packedLight);
                BeeStingerLayer.vertex(vertexConsumer, pose, -4.5f, 1, 0.0f, 0.0625f, packedLight);
            }
        }

        private static void vertex(class_4588 consumer, class_4587.class_4665 pose, float x, int y, float u, float v, int packedLight) {
            consumer.method_56824(pose, x, (float)y, 0.0f).method_39415(-1).method_22913(u, v).method_22922(class_4608.field_21444).method_60803(packedLight).method_60831(pose, 0.0f, 1.0f, 0.0f);
        }
    }

    public static class ArrowLayer<T extends class_1309, M extends class_583<T>>
    extends PinCushionLayer<T, M> {
        private final class_898 dispatcher;

        public ArrowLayer(class_5617.class_5618 context, class_922<T, M> renderer) {
            super(renderer);
            this.dispatcher = context.method_32166();
        }

        @Override
        protected int numStuck(T entity) {
            return entity.method_6022();
        }

        @Override
        protected void renderStuckItem(class_4587 poseStack, class_4597 buffer, int packedLight, class_1297 entity, float x, float y, float z, float partialTick) {
            float f = class_3532.method_15355((float)(x * x + z * z));
            class_1667 arrow = new class_1667(this, entity.method_37908(), entity.method_23317(), entity.method_23318(), entity.method_23321(), class_1799.field_8037, null){

                public boolean method_5757() {
                    return true;
                }

                public boolean method_24828() {
                    return true;
                }
            };
            arrow.method_36456((float)(Math.atan2(x, z) * 57.2957763671875));
            arrow.method_36457((float)(Math.atan2(y, f) * 57.2957763671875));
            arrow.field_5982 = arrow.method_36454();
            arrow.field_6004 = arrow.method_36455();
            this.dispatcher.method_3954((class_1297)arrow, 0.0, 0.0, 0.0, 0.0f, partialTick, poseStack, buffer, packedLight);
        }
    }
}

