/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.common.entity.ai.brain.FowlPlayMemoryModuleType;
import aqario.fowlplay.common.entity.ai.control.BirdBodyControl;
import aqario.fowlplay.common.entity.ai.control.BirdLookControl;
import net.minecraft.class_1266;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1330;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4174;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public abstract class BirdEntity
extends class_1429 {
    private int eatingTime;
    public int callChance;
    public int songChance;

    protected BirdEntity(class_1299<? extends BirdEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5952(true);
        this.field_6206 = new BirdLookControl((class_1308)this, 85);
        this.callChance = this.field_5974.method_43048(this.getCallDelay()) - this.getCallDelay();
        this.songChance = this.field_5974.method_43048(this.getSongDelay()) - this.getSongDelay();
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 6.0).method_26868(class_5134.field_23719, (double)0.2f);
    }

    public boolean method_18397(class_1799 stack) {
        class_1304 equipmentSlot = this.method_32326(stack);
        if (!this.method_6118(equipmentSlot).method_7960()) {
            return false;
        }
        return equipmentSlot == class_1304.field_6173 && super.method_18397(stack);
    }

    public boolean method_6481(class_1799 stack) {
        return false;
    }

    public abstract class_1856 getFood();

    public boolean method_5939(class_1799 stack) {
        class_1799 heldStack = this.method_6118(class_1304.field_6173);
        return this.getFood().method_8093(stack) && !this.getFood().method_8093(heldStack);
    }

    private void dropWithoutDelay(class_1799 stack, class_1297 thrower) {
        class_1542 item = new class_1542(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), stack);
        if (thrower != null) {
            item.method_6981(thrower);
        }
        this.method_37908().method_8649((class_1297)item);
    }

    protected void method_5949(class_1542 item) {
        class_1297 thrower = item.method_24921();
        class_1799 stack = item.method_6983();
        if (this.method_5939(stack)) {
            int i = stack.method_7947();
            if (i > 1) {
                this.dropWithoutDelay(stack.method_7971(i - 1), thrower);
            }
            this.method_5775(this.method_6118(class_1304.field_6173));
            this.method_29499(item);
            this.method_5673(class_1304.field_6173, stack.method_7971(1));
            this.method_25939(class_1304.field_6173);
            this.method_6103((class_1297)item, stack.method_7947());
            item.method_31472();
            this.eatingTime = 0;
            if (this.method_18868().method_18876(FowlPlayMemoryModuleType.SEES_FOOD, class_4141.field_18456)) {
                this.method_18868().method_18875(FowlPlayMemoryModuleType.SEES_FOOD);
            }
            if (this.method_18868().method_18876(class_4140.field_22332, class_4141.field_18456)) {
                this.method_18868().method_18875(class_4140.field_22332);
            }
        }
    }

    private boolean canEat(class_1799 stack) {
        return this.getFood().method_8093(stack);
    }

    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().field_9236 && this.method_5805()) {
            ++this.eatingTime;
            class_1799 stack = this.method_6118(class_1304.field_6173);
            if (this.canEat(stack)) {
                if (this.eatingTime > 40 && this.field_5974.method_43057() < 0.05f || this.eatingTime > 200) {
                    if (stack.method_7909().method_57347().method_57832(class_9334.field_50075)) {
                        this.method_6025(((class_4174)stack.method_7909().method_57347().method_57829(class_9334.field_50075)).comp_2491());
                    } else {
                        stack.method_7934(1);
                    }
                    class_1799 usedStack = stack.method_7910(this.method_37908(), (class_1309)this);
                    if (!usedStack.method_7960()) {
                        this.method_5673(class_1304.field_6173, usedStack);
                    }
                    this.method_5783(this.method_18869(stack), 1.0f, 1.0f);
                    this.method_37908().method_8421((class_1297)this, (byte)45);
                    this.eatingTime = 0;
                    return;
                }
                if (this.eatingTime > 20 && this.field_5974.method_43057() < 0.05f) {
                    this.method_5783(this.method_18869(stack), 1.0f, 1.0f);
                    this.method_37908().method_8421((class_1297)this, (byte)45);
                }
            } else if (!stack.method_7960() && !this.getFood().method_8093(stack) && this.field_5974.method_43057() < 0.1f) {
                this.method_5775(this.method_6118(class_1304.field_6173));
                this.method_5673(class_1304.field_6173, class_1799.field_8037);
            }
        }
    }

    public void method_5711(byte status) {
        if (status == 45) {
            class_1799 food = this.method_6118(class_1304.field_6173);
            if (!food.method_7960()) {
                for (int i = 0; i < 8; ++i) {
                    class_243 vec3d = new class_243(((double)this.field_5974.method_43057() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).method_1037(-this.method_36455() * ((float)Math.PI / 180)).method_1024(-this.method_36454() * ((float)Math.PI / 180));
                    this.method_37908().method_8406((class_2394)new class_2392(class_2398.field_11218, food), this.method_23317() + this.method_5720().field_1352 / 2.0, this.method_23318(), this.method_23321() + this.method_5720().field_1350 / 2.0, vec3d.field_1352, vec3d.field_1351 + 0.05, vec3d.field_1350);
                }
            }
        } else {
            super.method_5711(status);
        }
    }

    public void method_5670() {
        super.method_5670();
        this.method_37908().method_16107().method_15396("birdBaseTick");
        if (this.method_5805() && this.field_5974.method_43048(1000) < this.callChance++) {
            this.resetCallDelay();
            if (this.canCall()) {
                this.playCallSound();
            }
        } else if (this.method_5805() && this.field_5974.method_43048(1000) < this.songChance++) {
            this.resetSongDelay();
            if (this.canSing()) {
                this.playSongSound();
            }
        }
        this.method_37908().method_16107().method_15407();
    }

    protected boolean canCall() {
        return this.method_37908().method_8530() || this.field_5974.method_43057() < 0.05f;
    }

    protected boolean canSing() {
        return this.method_37908().method_8530();
    }

    private void resetCallDelay() {
        this.callChance = -(this.getCallDelay() - 100 + this.field_5974.method_43048(200));
    }

    private void resetSongDelay() {
        this.songChance = -(this.getSongDelay() - 100 + this.field_5974.method_43048(200));
    }

    public final void playCallSound() {
        class_3414 call = this.getCallSound();
        if (call != null) {
            this.method_5783(call, this.getCallVolume(), this.method_6017());
        }
    }

    public final void playSongSound() {
        class_3414 song = this.getSongSound();
        if (song != null) {
            this.method_5783(song, this.getSongVolume(), this.method_6017());
        }
    }

    public int getCallDelay() {
        return 240;
    }

    public int getSongDelay() {
        return 720;
    }

    @Nullable
    protected class_3414 getCallSound() {
        return null;
    }

    @Nullable
    protected class_3414 getSongSound() {
        return null;
    }

    protected float getCallVolume() {
        return 1.0f;
    }

    protected float getSongVolume() {
        return 1.0f;
    }

    public int method_20240() {
        return 100;
    }

    public int method_5978() {
        return 100;
    }

    public int method_5986() {
        return 270;
    }

    protected class_1330 method_5963() {
        return new BirdBodyControl(this);
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28631;
    }

    public float method_6017() {
        return (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.05f + 1.0f;
    }
}

