/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.ai.control.BirdFlightMoveControl;
import aqario.fowlplay.common.entity.ai.control.BirdMoveControl;
import aqario.fowlplay.common.entity.ai.pathing.BirdNavigation;
import aqario.fowlplay.common.tags.FowlPlayBlockTags;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1313;
import net.minecraft.class_1335;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;

public abstract class FlyingBirdEntity
extends BirdEntity {
    private static final class_2940<Boolean> FLYING = class_2945.method_12791(FlyingBirdEntity.class, (class_2941)class_2943.field_13323);
    private boolean isFlightMoveControl;
    private float prevRoll;
    private float visualRoll;
    public int timeFlying = 0;

    protected FlyingBirdEntity(class_1299<? extends BirdEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.setMoveControl(false);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 6.0).method_26868(class_5134.field_23719, (double)0.28f).method_26868(class_5134.field_23720, (double)0.2f);
    }

    public static boolean canSpawnPasserines(class_1299<? extends BirdEntity> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return world.method_8320(pos.method_10074()).method_26164(FowlPlayBlockTags.PASSERINES_SPAWNABLE_ON);
    }

    public static boolean canSpawnShorebirds(class_1299<? extends BirdEntity> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return world.method_8320(pos.method_10074()).method_26164(FowlPlayBlockTags.SHOREBIRDS_SPAWNABLE_ON);
    }

    protected class_1408 method_5965(class_1937 world) {
        this.setMoveControl(this.isFlying());
        return this.field_6189;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(FLYING, (Object)false);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("flying", this.isFlying());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setFlying(nbt.method_10577("flying"));
    }

    public abstract int getFlapFrequency();

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            if (this.isFlying()) {
                ++this.timeFlying;
                this.method_5875(true);
                this.field_6017 = 0.0f;
                if (this.method_24828() || this.method_5816()) {
                    this.stopFlying();
                }
            } else {
                this.timeFlying = 0;
                this.method_5875(false);
            }
            if (this.isFlying() != this.isFlightMoveControl) {
                this.setMoveControl(this.isFlying());
            }
        }
        this.prevRoll = this.visualRoll;
        this.visualRoll = this.calculateRoll(this.field_5982, this.method_36454());
    }

    private float calculateRoll(float prevYaw, float currentYaw) {
        float difference = currentYaw - prevYaw;
        if (difference >= 180.0f) {
            difference = 360.0f - difference;
        }
        if (difference < -180.0f) {
            difference = -(360.0f + difference);
        }
        return -difference * 3.0f;
    }

    public float getRoll(float tickDelta) {
        return tickDelta == 1.0f ? this.visualRoll : class_3532.method_16439((float)tickDelta, (float)this.prevRoll, (float)this.visualRoll);
    }

    protected class_1335 getLandMoveControl() {
        return new BirdMoveControl(this);
    }

    protected class_1408 getLandNavigation() {
        return new class_1409((class_1308)this, this.method_37908());
    }

    protected BirdFlightMoveControl getFlightMoveControl() {
        return new BirdFlightMoveControl(this, 40, 8);
    }

    protected BirdNavigation getFlightNavigation() {
        BirdNavigation birdNavigation = new BirdNavigation((class_1308)this, this.method_37908());
        birdNavigation.method_6363(false);
        birdNavigation.method_35139(true);
        birdNavigation.method_6354(false);
        return birdNavigation;
    }

    protected void setMoveControl(boolean isFlying) {
        if (isFlying) {
            this.field_6207 = this.getFlightMoveControl();
            this.field_6189 = this.getFlightNavigation();
            this.isFlightMoveControl = true;
        } else {
            this.field_6207 = this.getLandMoveControl();
            this.field_6189 = this.getLandNavigation();
            this.isFlightMoveControl = false;
        }
    }

    protected float method_49484() {
        return this.isFlying() ? this.method_6029() : super.method_49484();
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return !this.isFlying() && super.method_5747(fallDistance, damageMultiplier, damageSource);
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 landedState, class_2338 landedPosition) {
        if (!this.isFlying()) {
            super.method_5623(heightDifference, onGround, landedState, landedPosition);
        }
    }

    public void startFlying() {
        if (this.method_6032() > 2.0f) {
            this.setFlying(true);
            this.setMoveControl(true);
        }
    }

    public void stopFlying() {
        this.setFlying(false);
        this.setMoveControl(false);
    }

    public boolean isFlying() {
        return (Boolean)this.field_6011.method_12789(FLYING);
    }

    public void setFlying(boolean flying) {
        this.field_6011.method_12778(FLYING, (Object)flying);
    }

    public void method_6091(class_243 movementInput) {
        if (!this.isFlying()) {
            super.method_6091(movementInput);
            return;
        }
        if (this.method_5787()) {
            if (this.method_5799()) {
                this.method_5724(0.02f, movementInput);
                this.method_5784(class_1313.field_6308, this.method_18798());
                this.method_18799(this.method_18798().method_1021((double)0.8f));
            } else if (this.method_5771()) {
                this.method_5724(0.02f, movementInput);
                this.method_5784(class_1313.field_6308, this.method_18798());
                this.method_18799(this.method_18798().method_1021(0.5));
            } else {
                float friction = 0.75f;
                this.method_5724(this.method_6029(), movementInput);
                this.method_5784(class_1313.field_6308, this.method_18798());
                this.method_18799(this.method_18798().method_1021((double)friction));
            }
        }
    }
}

