/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.common.entity.FowlPlayEntityType;
import aqario.fowlplay.common.entity.PenguinEntity;
import aqario.fowlplay.common.entity.ai.brain.FowlPlayActivities;
import aqario.fowlplay.common.entity.ai.brain.FowlPlayMemoryModuleType;
import aqario.fowlplay.common.entity.ai.brain.sensor.FowlPlaySensorType;
import aqario.fowlplay.common.entity.ai.brain.task.BreatheAirTask;
import aqario.fowlplay.common.entity.ai.brain.task.GoToNearestWantedItemTask;
import aqario.fowlplay.common.entity.ai.brain.task.LocateFoodTask;
import aqario.fowlplay.common.tags.FowlPlayBlockTags;
import aqario.fowlplay.common.tags.FowlPlayItemTags;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1542;
import net.minecraft.class_1856;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4101;
import net.minecraft.class_4110;
import net.minecraft.class_4112;
import net.minecraft.class_4118;
import net.minecraft.class_4119;
import net.minecraft.class_4120;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4142;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4168;
import net.minecraft.class_4215;
import net.minecraft.class_4806;
import net.minecraft.class_4813;
import net.minecraft.class_4816;
import net.minecraft.class_4818;
import net.minecraft.class_4822;
import net.minecraft.class_4824;
import net.minecraft.class_4828;
import net.minecraft.class_5355;
import net.minecraft.class_5753;
import net.minecraft.class_5754;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_6028;
import net.minecraft.class_7687;
import net.minecraft.class_7893;
import net.minecraft.class_7894;
import net.minecraft.class_7898;
import org.jetbrains.annotations.Nullable;

public class PenguinBrain {
    private static final ImmutableList<class_4149<? extends class_4148<? super PenguinEntity>>> SENSORS = ImmutableList.of((Object)class_4149.field_18466, (Object)class_4149.field_22358, (Object)class_4149.field_25362, (Object)class_4149.field_18469, (Object)class_4149.field_37447, FowlPlaySensorType.PENGUIN_TEMPTATIONS, FowlPlaySensorType.PENGUIN_ATTACKABLES);
    private static final ImmutableList<class_4140<?>> MEMORIES = ImmutableList.of((Object)class_4140.field_18446, (Object)class_4140.field_18441, (Object)class_4140.field_18442, (Object)class_4140.field_18445, (Object)class_4140.field_19293, (Object)class_4140.field_18449, (Object)class_4140.field_18448, (Object)class_4140.field_18444, (Object)class_4140.field_22354, (Object)class_4140.field_22475, (Object)class_4140.field_25359, (Object)class_4140.field_22355, (Object[])new class_4140[]{class_4140.field_30246, class_4140.field_28325, class_4140.field_28326, class_4140.field_40127, class_4140.field_28327, class_4140.field_18451, class_4140.field_18452, class_4140.field_30243, class_4140.field_37442, class_4140.field_37443, class_4140.field_39408, class_4140.field_22332, class_4140.field_22349, class_4140.field_38397, FowlPlayMemoryModuleType.SEES_FOOD, FowlPlayMemoryModuleType.CANNOT_PICKUP_FOOD});
    private static final class_6019 FOLLOW_ADULT_RANGE = class_6019.method_35017((int)5, (int)16);
    private static final int PICK_UP_RANGE = 32;
    private static final float RUN_SPEED = 1.5f;
    private static final float TEMPTED_SPEED = 0.8f;
    private static final float WALK_SPEED = 1.0f;
    private static final float SWIM_SPEED = 4.0f;

    public static class_4095.class_5303<PenguinEntity> createProfile() {
        return class_4095.method_28311(MEMORIES, SENSORS);
    }

    public static class_4095<?> create(class_4095<PenguinEntity> brain) {
        PenguinBrain.addCoreActivities(brain);
        PenguinBrain.addIdleActivities(brain);
        PenguinBrain.addSwimActivities(brain);
        PenguinBrain.addPickupFoodActivities(brain);
        PenguinBrain.addFightActivities(brain);
        brain.method_18890((Set)ImmutableSet.of((Object)class_4168.field_18594));
        brain.method_18897(class_4168.field_18595);
        brain.method_24536();
        return brain;
    }

    public static void reset(PenguinEntity penguin) {
        class_4095<PenguinEntity> brain = penguin.method_18868();
        class_4168 activity = brain.method_24538().orElse(null);
        brain.method_24531((List)ImmutableList.of((Object)class_4168.field_18595, (Object)class_4168.field_37504, (Object)FowlPlayActivities.PICKUP_FOOD, (Object)class_4168.field_22396));
        if (activity == class_4168.field_22396 && brain.method_24538().orElse(null) != class_4168.field_22396) {
            brain.method_24525(class_4140.field_30246, (Object)true, 2400L);
        }
    }

    private static void addCoreActivities(class_4095<PenguinEntity> brain) {
        brain.method_18882(class_4168.field_18594, 0, ImmutableList.of((Object)((Object)new BreatheAirTask(4.0f)), (Object)new class_6028(1.5f), LocateFoodTask.run(), (Object)new class_4110(45, 90), (Object)new class_4112(), (Object)new class_5753(class_4140.field_28326), (Object)new class_5753(class_4140.field_40127)));
    }

    private static void addIdleActivities(class_4095<PenguinEntity> brain) {
        brain.method_24529(class_4168.field_18595, ImmutableList.of((Object)Pair.of((Object)0, (Object)new class_4806(FowlPlayEntityType.PENGUIN, 1.0f, 10)), (Object)Pair.of((Object)1, (Object)class_4119.method_47057((class_1299)class_1299.field_6097, (float)32.0f)), (Object)Pair.of((Object)2, (Object)new class_5754(penguin -> Float.valueOf(0.8f))), (Object)Pair.of((Object)3, (Object)class_5355.method_46896((class_6019)FOLLOW_ADULT_RANGE, (float)1.0f)), (Object)Pair.of((Object)4, (Object)new class_7687((class_6017)class_6019.method_35017((int)150, (int)250), 30.0f, 0.0f, 0.0f)), (Object)Pair.of((Object)5, (Object)class_4824.method_47119(PenguinBrain::getAttackTarget)), (Object)Pair.of((Object)6, (Object)new class_4118((Map)ImmutableMap.of((Object)class_4140.field_18445, (Object)class_4141.field_18457), (List)ImmutableList.of((Object)Pair.of((Object)class_4818.method_47014((float)1.0f), (Object)2), (Object)Pair.of((Object)class_4120.method_47104((float)1.0f, (int)10), (Object)3), (Object)Pair.of((Object)((Object)new RandomSlideTask(20)), (Object)5), (Object)Pair.of((Object)new class_4101(400, 800), (Object)5))))), (Set)ImmutableSet.of((Object)Pair.of((Object)class_4140.field_37442, (Object)class_4141.field_18457), (Object)Pair.of(FowlPlayMemoryModuleType.SEES_FOOD, (Object)class_4141.field_18457), (Object)Pair.of((Object)class_4140.field_22355, (Object)class_4141.field_18457)));
    }

    private static void addSwimActivities(class_4095<PenguinEntity> brain) {
        brain.method_24529(class_4168.field_37504, ImmutableList.of((Object)Pair.of((Object)0, (Object)class_5355.method_46896((class_6019)FOLLOW_ADULT_RANGE, (float)4.0f)), (Object)Pair.of((Object)1, (Object)class_4824.method_47119(PenguinBrain::getAttackTarget)), (Object)Pair.of((Object)2, (Object)new class_4118((Map)ImmutableMap.of((Object)class_4140.field_18445, (Object)class_4141.field_18457), (List)ImmutableList.of((Object)Pair.of(PenguinSwimTask.create(4.0f), (Object)2))))), (Set)ImmutableSet.of((Object)Pair.of((Object)class_4140.field_37442, (Object)class_4141.field_18456), (Object)Pair.of(FowlPlayMemoryModuleType.SEES_FOOD, (Object)class_4141.field_18457), (Object)Pair.of((Object)class_4140.field_22355, (Object)class_4141.field_18457)));
    }

    private static void addPickupFoodActivities(class_4095<PenguinEntity> brain) {
        brain.method_24527(FowlPlayActivities.PICKUP_FOOD, 10, ImmutableList.of(GoToNearestWantedItemTask.create(PenguinBrain::doesNotHaveFoodInHand, entity -> Float.valueOf(entity.method_5816() ? 4.0f : 1.5f), true, 32), (Object)class_4813.method_46922(PenguinBrain::noFoodInRange, FowlPlayMemoryModuleType.SEES_FOOD)), FowlPlayMemoryModuleType.SEES_FOOD);
    }

    private static void addFightActivities(class_4095<PenguinEntity> brain) {
        brain.method_24527(class_4168.field_22396, 0, ImmutableList.of((Object)class_4828.method_47132(), (Object)class_4822.method_47094((float)4.0f), (Object)class_4816.method_46987((int)20), (Object)class_4813.method_46922(class_4215::method_41331, (class_4140)class_4140.field_22355)), class_4140.field_22355);
    }

    private static Optional<? extends class_1309> getAttackTarget(PenguinEntity penguin) {
        return class_4215.method_41331((class_1309)penguin) ? Optional.empty() : penguin.method_18868().method_18904(class_4140.field_30243);
    }

    private static boolean noFoodInRange(PenguinEntity penguin) {
        Optional item = penguin.method_18868().method_18904(class_4140.field_22332);
        return item.isEmpty() || !((class_1542)item.get()).method_24516((class_1297)penguin, 32.0);
    }

    private static boolean doesNotHaveFoodInHand(PenguinEntity penguin) {
        return !PenguinBrain.getFood().method_8093(penguin.method_6047());
    }

    public static class_1856 getFood() {
        return class_1856.method_8106(FowlPlayItemTags.PENGUIN_FOOD);
    }

    public static class RandomSlideTask
    extends class_4097<PenguinEntity> {
        private final int minimalSlideTicks;

        public RandomSlideTask(int seconds) {
            super((Map)ImmutableMap.of());
            this.minimalSlideTicks = seconds * 20;
        }

        protected boolean shouldRun(class_3218 world, PenguinEntity penguin) {
            return !penguin.method_5799() && penguin.getAnimationTicks() >= (long)this.minimalSlideTicks && !penguin.method_5782() && penguin.method_24828() && (penguin.isSliding() || world.method_8320(penguin.method_24515()).method_26164(FowlPlayBlockTags.PENGUINS_SLIDE_ON));
        }

        protected void run(class_3218 serverWorld, PenguinEntity penguin, long l) {
            if (penguin.isSliding()) {
                penguin.standUp();
            } else {
                penguin.startSliding();
            }
        }
    }

    public static class PenguinSwimTask {
        private static final int[][] SWIM_DISTANCES = new int[][]{{31, 15}};

        public static class_7893<class_1314> create(float speed) {
            return PenguinSwimTask.create(speed, PenguinSwimTask::findSwimTargetPos, class_1297::method_5816);
        }

        private static class_7894<class_1314> create(float speed, Function<class_1314, class_243> targetGetter, Predicate<class_1314> predicate) {
            return class_7898.method_47224(instance -> instance.group((App)instance.method_47245(class_4140.field_18445)).apply((Applicative)instance, memoryAccessor -> (world, entity, time) -> {
                if (!predicate.test((class_1314)entity)) {
                    return false;
                }
                Optional<class_243> optional = Optional.ofNullable((class_243)targetGetter.apply((class_1314)entity));
                memoryAccessor.method_47251(optional.map(vec3d -> new class_4142(vec3d, speed, 0)));
                return true;
            }));
        }

        @Nullable
        private static class_243 findSwimTargetPos(class_1314 entity) {
            class_243 vec3d = null;
            class_243 vec3d2 = null;
            for (int[] is : SWIM_DISTANCES) {
                vec3d2 = vec3d == null ? class_4215.method_33193((class_1314)entity, (int)is[0], (int)is[1]) : entity.method_19538().method_1019(entity.method_19538().method_1035(vec3d).method_1029().method_18805((double)is[0], (double)is[1], (double)is[0]));
                if (vec3d2 == null || entity.method_37908().method_8316(class_2338.method_49638((class_2374)vec3d2)).method_15769()) {
                    return vec3d;
                }
                vec3d = vec3d2;
            }
            return vec3d2;
        }
    }
}

