/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.FowlPlayEntityType;
import aqario.fowlplay.common.entity.PenguinBrain;
import aqario.fowlplay.common.sound.FowlPlaySoundEvents;
import aqario.fowlplay.common.tags.FowlPlayBiomeTags;
import aqario.fowlplay.common.tags.FowlPlayBlockTags;
import aqario.fowlplay.common.tags.FowlPlayItemTags;
import com.google.common.collect.Lists;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1332;
import net.minecraft.class_1335;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4095;
import net.minecraft.class_4209;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5275;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5757;
import net.minecraft.class_5766;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7;
import net.minecraft.class_7094;
import org.jetbrains.annotations.Nullable;

public class PenguinEntity
extends BirdEntity {
    public static final class_2940<Long> LAST_ANIMATION_TICK = class_2945.method_12791(PenguinEntity.class, (class_2941)class_2943.field_39965);
    private boolean isAquaticMoveControl;
    public final class_7094 idleState = new class_7094();
    public final class_7094 slideState = new class_7094();
    public final class_7094 fallingState = new class_7094();
    public final class_7094 standUpState = new class_7094();
    public final class_7094 flapState = new class_7094();
    public final class_7094 swimState = new class_7094();
    public final class_7094 danceState = new class_7094();
    private boolean songPlaying;
    @Nullable
    private class_2338 songSource;

    public PenguinEntity(class_1299<? extends PenguinEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.setMoveControl(false);
        this.method_5941(class_7.field_18, 0.0f);
        this.field_6206 = new class_1332((class_1308)this, 85);
    }

    protected float method_49484() {
        return this.method_5816() ? this.method_6029() : super.method_49484();
    }

    protected void setMoveControl(boolean isSwimming) {
        if (isSwimming) {
            this.field_6207 = new class_5757((class_1308)this, 85, 15, 1.0f, 1.0f, true);
            this.isAquaticMoveControl = true;
        } else {
            this.field_6207 = new class_1335((class_1308)this);
            this.isAquaticMoveControl = false;
        }
    }

    protected class_1408 method_5965(class_1937 world) {
        return new class_5766((class_1308)this, world);
    }

    @Nullable
    public class_1309 method_5968() {
        return this.method_59664();
    }

    @Override
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        this.setLastAnimationTick(world.method_8410().method_8510());
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return (class_1296)FowlPlayEntityType.PENGUIN.method_5883((class_1937)world);
    }

    @Override
    public boolean method_6481(class_1799 stack) {
        return this.getFood().method_8093(stack);
    }

    @Override
    public class_1856 getFood() {
        return class_1856.method_8106(FowlPlayItemTags.PENGUIN_FOOD);
    }

    public static class_5132.class_5133 createAttributes() {
        return BirdEntity.createAttributes().method_26868(class_5134.field_23716, 16.0).method_26868(class_5134.field_23721, 4.0).method_26868(class_5134.field_23719, (double)0.135f).method_26868(class_5134.field_51578, 1.0);
    }

    public void method_6006(class_2338 songPosition, boolean playing) {
        this.songSource = songPosition;
        this.songPlaying = playing;
    }

    @Override
    public void method_6007() {
        if (this.songSource == null || !this.songSource.method_19769((class_2374)this.method_19538(), 5.0) || !this.method_37908().method_8320(this.songSource).method_27852(class_2246.field_10223)) {
            this.songPlaying = false;
            this.songSource = null;
        }
        super.method_6007();
    }

    public boolean isSongPlaying() {
        return this.songPlaying;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(LAST_ANIMATION_TICK, (Object)0L);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10544("lastPoseTick", ((Long)this.field_6011.method_12789(LAST_ANIMATION_TICK)).longValue());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        long l = nbt.method_10537("lastPoseTick");
        if (l < 0L) {
            this.method_18380(class_4050.field_47246);
        }
        this.setLastAnimationTick(l);
    }

    public void method_48850(List<class_2945.class_7834<?>> entries) {
        super.method_48850(entries);
        this.method_18382();
    }

    public void method_5773() {
        if (this.method_5642() != null && this.method_5816()) {
            this.method_5642().method_5848();
        }
        if (this.method_37908().method_8608()) {
            this.idleState.method_45317(this.method_24828() && !this.method_5816(), this.field_6012);
            this.swimState.method_45317(this.method_5816(), this.field_6012);
            if (this.isVisuallyFallingDown()) {
                this.idleState.method_41325();
                if (this.isVisuallySliding()) {
                    this.slideState.method_41324(this.field_6012);
                    this.fallingState.method_41325();
                } else {
                    this.slideState.method_41325();
                    this.fallingState.method_41324(this.field_6012);
                }
            } else {
                this.slideState.method_41325();
                this.fallingState.method_41325();
                this.standUpState.method_45317(this.isInAnimationTransition() && this.getAnimationTicks() >= 0L, this.field_6012);
            }
            this.danceState.method_45317(this.isSongPlaying(), this.field_6012);
        }
        if (!this.method_37908().field_9236) {
            if (this.isSliding() && this.method_5816()) {
                this.standUp();
            }
            if (this.method_5816() != this.isAquaticMoveControl) {
                this.setMoveControl(this.method_5816());
            }
        }
        super.method_5773();
        if (this.method_37908().field_9236 && this.method_5816() && this.method_18798().method_1027() > 0.02) {
            this.addSwimParticles();
        }
        if (this.method_5681()) {
            this.method_18380(class_4050.field_18079);
        } else if (this.method_18376() != class_4050.field_47246) {
            this.method_18380(class_4050.field_18076);
        }
    }

    private void addSwimParticles() {
        for (int i = 0; i < 20; ++i) {
            this.method_37908().method_8406((class_2394)class_2398.field_11222, this.method_23317() + (double)(this.field_5974.method_43057() * 0.5f - 0.25f), this.method_23318() + this.method_5829().method_17940() / 2.0 + (double)(this.field_5974.method_43057() * 0.5f - 0.25f), this.method_23321() + (double)(this.field_5974.method_43057() * 0.5f - 0.25f), 0.0, 0.0, 0.0);
        }
    }

    public void method_5790() {
        this.method_5796(this.method_5816() && !this.method_5765());
    }

    protected void clampPassengerYaw(class_1297 entity) {
        entity.method_5636(this.method_36454());
        float f = class_3532.method_15393((float)(entity.method_36454() - this.method_36454()));
        float g = class_3532.method_15363((float)f, (float)-105.0f, (float)105.0f);
        entity.field_5982 += g - f;
        entity.method_36456(entity.method_36454() + g - f);
        entity.method_5847(entity.method_36454());
    }

    public void method_5644(class_1297 passenger) {
        this.clampPassengerYaw(passenger);
    }

    public class_243 method_24829(class_1309 passenger) {
        class_243 vec3d = PenguinEntity.method_24826((double)(this.method_17681() * class_3532.field_15724), (double)passenger.method_17681(), (float)passenger.method_36454());
        double d = this.method_23317() + vec3d.field_1352;
        double e = this.method_23321() + vec3d.field_1350;
        class_2338 blockPos = new class_2338((int)d, (int)this.method_53511().field_1325, (int)e);
        class_2338 blockPos2 = blockPos.method_10074();
        if (!this.method_37908().method_22351(blockPos2)) {
            double g;
            ArrayList list = Lists.newArrayList();
            double f = this.method_37908().method_30347(blockPos);
            if (class_5275.method_27932((double)f)) {
                list.add(new class_243(d, (double)blockPos.method_10264() + f, e));
            }
            if (class_5275.method_27932((double)(g = this.method_37908().method_30347(blockPos2)))) {
                list.add(new class_243(d, (double)blockPos2.method_10264() + g, e));
            }
            for (class_4050 entityPose : passenger.method_24831()) {
                for (class_243 vec3d2 : list) {
                    if (!class_5275.method_33353((class_1941)this.method_37908(), (class_243)vec3d2, (class_1309)passenger, (class_4050)entityPose)) continue;
                    passenger.method_18380(entityPose);
                    return vec3d2;
                }
            }
        }
        return super.method_24829(passenger);
    }

    public float method_49476() {
        return this.method_18376() == class_4050.field_47246 ? 1.1f : super.method_49476();
    }

    public class_4048 method_55694(class_4050 pose) {
        class_4048 dimensions = super.method_55694(pose);
        return pose == class_4050.field_47246 || pose == class_4050.field_18079 ? dimensions.method_19539(1.0f, 0.35f) : dimensions;
    }

    public boolean method_5675() {
        return false;
    }

    public boolean method_5810() {
        return !this.method_5782();
    }

    protected boolean canBreed() {
        return !this.method_5782() && !this.method_5765() && !this.method_6109() && this.method_6032() >= this.method_6063() && this.method_6479();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean method_6474(class_1429 other) {
        if (other == this) return false;
        if (!(other instanceof PenguinEntity)) return false;
        PenguinEntity penguin = (PenguinEntity)other;
        if (!this.canBreed()) return false;
        if (!penguin.canBreed()) return false;
        return true;
    }

    public boolean shouldStepDown() {
        class_2338 pos = this.method_24515();
        return !this.method_24828() && this.field_6017 > 0.0f && this.field_6017 < 0.1f && !this.method_37908().method_8320(pos.method_10074()).method_26220((class_1922)this.method_37908(), pos.method_10074()).method_1110();
    }

    @Nullable
    public class_1309 method_5642() {
        return (class_1309)this.method_31483();
    }

    protected boolean method_5818(class_1297 passenger) {
        return super.method_5818(passenger) && !this.method_5869();
    }

    protected boolean method_5876() {
        boolean touchingWater = this.method_5799();
        boolean bl = super.method_5876();
        if (touchingWater != this.method_5799()) {
            this.method_18380(this.method_5799() ? class_4050.field_18079 : class_4050.field_18076);
            this.method_18382();
        }
        return bl;
    }

    public static boolean canSpawn(class_1299<? extends BirdEntity> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return world.method_23753(pos).method_40220(FowlPlayBiomeTags.SPAWNS_PENGUINS) && world.method_8320(pos.method_10074()).method_26164(FowlPlayBlockTags.PENGUINS_SPAWNABLE_ON);
    }

    protected void method_49481(class_1657 player, class_243 input) {
        super.method_49481(player, input);
        float sidewaysMovement = player.field_6212;
        double rotation = 3.0;
        if (Math.abs(sidewaysMovement) == 0.0f) {
            rotation = 0.0;
        }
        this.method_5710((float)((double)this.method_36454() + rotation * (double)(sidewaysMovement < 0.0f ? 1 : -1)), this.method_36455());
        player.method_36456((float)((double)player.method_36454() + rotation * (double)(sidewaysMovement < 0.0f ? 1 : -1)) % 360.0f);
        this.field_6283 = this.field_6241 = this.method_36454();
        this.field_5982 = this.field_6241;
    }

    protected class_243 method_49482(class_1657 player, class_243 input) {
        float forwardMovement = player.field_6250 * 0.2f;
        if (this.method_37908().method_8320(this.method_23314()).method_26164(FowlPlayBlockTags.PENGUINS_SLIDE_ON) || this.method_55667().method_26164(FowlPlayBlockTags.PENGUINS_SLIDE_ON)) {
            forwardMovement *= 2.0f;
        }
        return new class_243(0.0, 0.0, (double)Math.max(forwardMovement, 0.0f));
    }

    protected float method_49485(class_1657 player) {
        return (float)this.method_45325(class_5134.field_23719);
    }

    public int method_5748() {
        return 9600;
    }

    protected int method_6064(int air) {
        return this.method_5748();
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        boolean bl = this.method_6481(player.method_5998(hand));
        if (!(bl || this.method_5782() || player.method_21823() || this.method_6109() || !this.isSliding())) {
            if (!this.method_37908().field_9236) {
                player.method_5804((class_1297)this);
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return super.method_5992(player, hand);
    }

    public boolean isSliding() {
        return (Long)this.field_6011.method_12789(LAST_ANIMATION_TICK) < 0L;
    }

    public boolean isVisuallyFallingDown() {
        return this.getAnimationTicks() < 0L != this.isSliding();
    }

    public boolean isInAnimationTransition() {
        long l = this.getAnimationTicks();
        return l < (long)(this.isSliding() ? 40 : 52);
    }

    private boolean isVisuallySliding() {
        return this.isSliding() && this.getAnimationTicks() < 40L && this.getAnimationTicks() >= 0L;
    }

    public void startSliding() {
        if (!this.isSliding()) {
            this.method_43077(class_3417.field_40079);
            this.method_18380(class_4050.field_47246);
            this.method_32876((class_6880)class_5712.field_45148);
            this.setLastAnimationTick(-this.method_37908().method_8510());
        }
    }

    public void standUp() {
        if (this.isSliding()) {
            this.method_43077(class_3417.field_40080);
            this.method_18380(class_4050.field_18076);
            this.method_32876((class_6880)class_5712.field_45148);
            this.setLastAnimationTick(this.method_37908().method_8510());
        }
    }

    public long getAnimationTicks() {
        return this.method_37908().method_8510() - Math.abs((Long)this.field_6011.method_12789(LAST_ANIMATION_TICK));
    }

    public void setLastAnimationTick(long tick) {
        this.field_6011.method_12778(LAST_ANIMATION_TICK, (Object)tick);
    }

    protected int method_23329(float fallDistance, float damageMultiplier) {
        if (this.method_18376() == class_4050.field_47246) {
            return (super.method_23329(fallDistance, damageMultiplier) - 3) / 2;
        }
        return super.method_23329(fallDistance, damageMultiplier);
    }

    @Override
    protected boolean canCall() {
        return !this.method_5816() && super.canCall();
    }

    @Override
    @Nullable
    protected class_3414 getCallSound() {
        return this.method_6109() ? FowlPlaySoundEvents.ENTITY_PENGUIN_BABY_CALL : FowlPlaySoundEvents.ENTITY_PENGUIN_CALL;
    }

    @Override
    protected float getCallVolume() {
        return 4.0f;
    }

    protected class_3414 method_5737() {
        return FowlPlaySoundEvents.ENTITY_PENGUIN_SWIM;
    }

    public class_3414 method_18869(class_1799 stack) {
        return class_3417.field_14960;
    }

    protected class_3414 method_6011(class_1282 source) {
        return FowlPlaySoundEvents.ENTITY_PENGUIN_HURT;
    }

    protected class_3414 method_6002() {
        return FowlPlaySoundEvents.ENTITY_PENGUIN_DEATH;
    }

    protected class_4095.class_5303<PenguinEntity> method_28306() {
        return PenguinBrain.createProfile();
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return PenguinBrain.create((class_4095<PenguinEntity>)this.method_28306().method_28335(dynamic));
    }

    public class_4095<PenguinEntity> method_18868() {
        return super.method_18868();
    }

    protected void method_5958() {
        this.method_37908().method_16107().method_15396("penguinBrain");
        this.method_18868().method_19542((class_3218)this.method_37908(), (class_1309)this);
        this.method_37908().method_16107().method_15407();
        this.method_37908().method_16107().method_15396("penguinActivityUpdate");
        PenguinBrain.reset(this);
        this.method_37908().method_16107().method_15407();
        super.method_5958();
    }

    protected void method_18409() {
        super.method_18409();
        class_4209.method_19774((class_1309)this);
    }
}

