/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.common.entity.FowlPlayEntityType;
import aqario.fowlplay.common.entity.PigeonEntity;
import aqario.fowlplay.common.entity.ai.brain.FowlPlayActivities;
import aqario.fowlplay.common.entity.ai.brain.FowlPlayMemoryModuleType;
import aqario.fowlplay.common.entity.ai.brain.sensor.FowlPlaySensorType;
import aqario.fowlplay.common.entity.ai.brain.task.DeliverBundleTask;
import aqario.fowlplay.common.entity.ai.brain.task.DelivererFollowOwnerTask;
import aqario.fowlplay.common.entity.ai.brain.task.FlightTaskControl;
import aqario.fowlplay.common.entity.ai.brain.task.FlyTask;
import aqario.fowlplay.common.entity.ai.brain.task.GoToNearestWantedItemTask;
import aqario.fowlplay.common.entity.ai.brain.task.GoToWalkTargetTask;
import aqario.fowlplay.common.entity.ai.brain.task.LocateFoodTask;
import aqario.fowlplay.common.entity.ai.brain.task.StayNearClosestEntityTask;
import aqario.fowlplay.common.entity.ai.brain.task.TeleportToTargetTask;
import aqario.fowlplay.common.tags.FowlPlayItemTags;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1856;
import net.minecraft.class_4095;
import net.minecraft.class_4101;
import net.minecraft.class_4110;
import net.minecraft.class_4112;
import net.minecraft.class_4118;
import net.minecraft.class_4119;
import net.minecraft.class_4120;
import net.minecraft.class_4125;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4168;
import net.minecraft.class_4802;
import net.minecraft.class_4806;
import net.minecraft.class_4809;
import net.minecraft.class_4813;
import net.minecraft.class_4818;
import net.minecraft.class_5355;
import net.minecraft.class_5753;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_6028;
import net.minecraft.class_7687;
import net.minecraft.class_7893;
import net.minecraft.class_7894;
import net.minecraft.class_7898;

public class PigeonBrain {
    private static final ImmutableList<class_4149<? extends class_4148<? super PigeonEntity>>> SENSORS = ImmutableList.of((Object)class_4149.field_18466, (Object)class_4149.field_18467, (Object)class_4149.field_22358, (Object)class_4149.field_25362, (Object)class_4149.field_18469, (Object)class_4149.field_37447, FowlPlaySensorType.IS_FLYING, FowlPlaySensorType.NEAREST_ADULTS, FowlPlaySensorType.PIGEON_TEMPTATIONS, FowlPlaySensorType.PIGEON_SPECIFIC_SENSOR);
    private static final ImmutableList<class_4140<?>> MEMORIES = ImmutableList.of((Object)class_4140.field_18446, (Object)class_4140.field_18441, (Object)class_4140.field_18442, (Object)class_4140.field_18445, (Object)class_4140.field_19293, (Object)class_4140.field_18449, (Object)class_4140.field_18448, (Object)class_4140.field_18444, (Object)class_4140.field_22354, (Object)class_4140.field_22357, (Object)class_4140.field_22475, (Object)class_4140.field_25359, (Object[])new class_4140[]{class_4140.field_22355, class_4140.field_30246, class_4140.field_28325, class_4140.field_28326, class_4140.field_40127, class_4140.field_28327, class_4140.field_18451, class_4140.field_18452, class_4140.field_30243, class_4140.field_37442, class_4140.field_37443, class_4140.field_39408, class_4140.field_22332, class_4140.field_22349, class_4140.field_38397, FowlPlayMemoryModuleType.IS_FLYING, FowlPlayMemoryModuleType.SEES_FOOD, FowlPlayMemoryModuleType.CANNOT_PICKUP_FOOD, FowlPlayMemoryModuleType.NEAREST_VISIBLE_ADULTS, FowlPlayMemoryModuleType.TELEPORT_TARGET, FowlPlayMemoryModuleType.RECIPIENT});
    private static final class_6019 RUN_FROM_PLAYER_MEMORY_DURATION = class_4802.method_24505((int)1, (int)3);
    private static final class_6019 FOLLOW_ADULT_RANGE = class_6019.method_35017((int)5, (int)16);
    private static final class_6019 STAY_NEAR_ENTITY_RANGE = class_6019.method_35017((int)16, (int)32);
    private static final int PICK_UP_RANGE = 32;
    private static final int AVOID_PLAYER_RADIUS = 5;
    private static final float RUN_SPEED = 1.4f;
    private static final float WALK_SPEED = 1.0f;
    private static final float FLY_SPEED = 2.0f;

    public static class_4095.class_5303<PigeonEntity> createProfile() {
        return class_4095.method_28311(MEMORIES, SENSORS);
    }

    public static class_4095<?> create(class_4095<PigeonEntity> brain) {
        PigeonBrain.addCoreActivities(brain);
        PigeonBrain.addIdleActivities(brain);
        PigeonBrain.addFlyActivities(brain);
        PigeonBrain.addDeliverActivities(brain);
        PigeonBrain.addAvoidActivities(brain);
        PigeonBrain.addPickupFoodActivities(brain);
        brain.method_18890((Set)ImmutableSet.of((Object)class_4168.field_18594));
        brain.method_18897(class_4168.field_18595);
        brain.method_24536();
        return brain;
    }

    public static void reset(PigeonEntity pigeon) {
        pigeon.method_18868().method_24531((List)ImmutableList.of((Object)class_4168.field_18595, (Object)FowlPlayActivities.FLY, (Object)FowlPlayActivities.DELIVER, (Object)class_4168.field_22399, (Object)FowlPlayActivities.PICKUP_FOOD));
    }

    private static void addCoreActivities(class_4095<PigeonEntity> brain) {
        brain.method_18882(class_4168.field_18594, 0, ImmutableList.of((Object)new class_4125(0.5f), FlightTaskControl.stopFalling(), (Object)((Object)new TeleportToTargetTask()), (Object)new class_6028(1.4f), (Object)((Object)new DelivererFollowOwnerTask(1.0f, 5.0f, 10.0f)), PigeonBrain.makeAddPlayerToAvoidTargetTask(), LocateFoodTask.run(pigeon -> !pigeon.isSitting() && pigeon.getRecipientUuid() == null), (Object)new class_4110(45, 90), (Object)new class_4112(), (Object)new class_5753(class_4140.field_28326), (Object)new class_5753(class_4140.field_40127)));
    }

    private static void addIdleActivities(class_4095<PigeonEntity> brain) {
        brain.method_24529(class_4168.field_18595, ImmutableList.of((Object)Pair.of((Object)1, (Object)new class_4806(FowlPlayEntityType.PIGEON, 1.0f, 20)), (Object)Pair.of((Object)2, (Object)class_5355.method_46896((class_6019)FOLLOW_ADULT_RANGE, (float)1.0f)), (Object)Pair.of((Object)3, (Object)class_4119.method_47065(PigeonBrain::isPlayerHoldingFood, (float)32.0f)), (Object)Pair.of((Object)4, StayNearClosestEntityTask.create(STAY_NEAR_ENTITY_RANGE, 1.0f)), (Object)Pair.of((Object)5, (Object)new class_7687((class_6017)class_6019.method_35017((int)150, (int)250), 30.0f, 0.0f, 0.0f)), (Object)Pair.of((Object)6, (Object)new class_4118((Map)ImmutableMap.of((Object)class_4140.field_18445, (Object)class_4141.field_18457), (List)ImmutableList.of((Object)Pair.of((Object)class_4818.method_47014((float)1.0f), (Object)4), (Object)Pair.of((Object)class_7898.method_47225(class_1297::method_5816), (Object)3), (Object)Pair.of((Object)new class_4101(100, 300), (Object)3), (Object)Pair.of(FlightTaskControl.startFlying(pigeon -> !pigeon.isSitting() && pigeon.method_59922().method_43057() < 0.1f), (Object)1))))), (Set)ImmutableSet.of((Object)Pair.of(FowlPlayMemoryModuleType.IS_FLYING, (Object)class_4141.field_18457), (Object)Pair.of((Object)class_4140.field_22357, (Object)class_4141.field_18457), (Object)Pair.of(FowlPlayMemoryModuleType.SEES_FOOD, (Object)class_4141.field_18457), (Object)Pair.of(FowlPlayMemoryModuleType.RECIPIENT, (Object)class_4141.field_18457)));
    }

    private static void addFlyActivities(class_4095<PigeonEntity> brain) {
        brain.method_24529(FowlPlayActivities.FLY, ImmutableList.of((Object)Pair.of((Object)1, FlightTaskControl.tryStopFlying(pigeon -> true)), (Object)Pair.of((Object)2, StayNearClosestEntityTask.create(STAY_NEAR_ENTITY_RANGE, 2.0f)), (Object)Pair.of((Object)3, (Object)new class_4118((Map)ImmutableMap.of((Object)class_4140.field_18445, (Object)class_4141.field_18457), (List)ImmutableList.of((Object)Pair.of(FlyTask.create(2.0f, 64, 32), (Object)1))))), (Set)ImmutableSet.of((Object)Pair.of(FowlPlayMemoryModuleType.IS_FLYING, (Object)class_4141.field_18456), (Object)Pair.of((Object)class_4140.field_22357, (Object)class_4141.field_18457), (Object)Pair.of(FowlPlayMemoryModuleType.SEES_FOOD, (Object)class_4141.field_18457), (Object)Pair.of(FowlPlayMemoryModuleType.RECIPIENT, (Object)class_4141.field_18457)));
    }

    private static void addDeliverActivities(class_4095<PigeonEntity> brain) {
        brain.method_24527(FowlPlayActivities.DELIVER, 0, ImmutableList.of(FlightTaskControl.stopFlying(PigeonBrain::shouldStopFlyingToRecipient), FlightTaskControl.startFlying(PigeonBrain::shouldFlyToRecipient), DeliverBundleTask.run(pigeon -> true, pigeon -> Float.valueOf(pigeon.isFlying() ? 2.0f : 1.0f))), FowlPlayMemoryModuleType.RECIPIENT);
    }

    private static void addAvoidActivities(class_4095<PigeonEntity> brain) {
        brain.method_24527(class_4168.field_22399, 10, ImmutableList.of(FlightTaskControl.startFlying(pigeon -> true), GoToWalkTargetTask.toEntity((class_4140<? extends class_1297>)class_4140.field_22357, pigeon -> Float.valueOf(pigeon.isFlying() ? 2.0f : 1.4f), 5, true), PigeonBrain.makeRandomFollowTask(), PigeonBrain.makeRandomWanderTask(), (Object)class_4813.method_46922(entity -> true, (class_4140)class_4140.field_22357)), class_4140.field_22357);
    }

    private static void addPickupFoodActivities(class_4095<PigeonEntity> brain) {
        brain.method_24529(FowlPlayActivities.PICKUP_FOOD, ImmutableList.of((Object)Pair.of((Object)0, FlightTaskControl.startFlying(pigeon -> !pigeon.isTamed())), (Object)Pair.of((Object)1, GoToNearestWantedItemTask.create(PigeonBrain::doesNotHaveFoodInHand, entity -> Float.valueOf(entity.isFlying() ? 2.0f : 1.4f), true, 32)), (Object)Pair.of((Object)2, (Object)class_4813.method_46922(PigeonBrain::noFoodInRange, FowlPlayMemoryModuleType.SEES_FOOD))), Set.of(Pair.of(FowlPlayMemoryModuleType.SEES_FOOD, (Object)class_4141.field_18456), Pair.of((Object)class_4140.field_22357, (Object)class_4141.field_18457), Pair.of(FowlPlayMemoryModuleType.RECIPIENT, (Object)class_4141.field_18457)));
    }

    private static ImmutableList<Pair<class_7894<class_1309>, Integer>> createLookTasks() {
        return ImmutableList.of((Object)Pair.of((Object)class_4119.method_47057(FowlPlayEntityType.PIGEON, (float)8.0f), (Object)1), (Object)Pair.of((Object)class_4119.method_47056((float)8.0f), (Object)1));
    }

    private static class_4118<class_1309> makeRandomFollowTask() {
        return new class_4118((List)ImmutableList.builder().addAll(PigeonBrain.createLookTasks()).add((Object)Pair.of((Object)new class_4101(30, 60), (Object)1)).build());
    }

    private static class_4118<PigeonEntity> makeRandomWanderTask() {
        return new class_4118((List)ImmutableList.of((Object)Pair.of((Object)class_4818.method_47014((float)0.6f), (Object)2), (Object)Pair.of((Object)class_7898.method_47227(livingEntity -> true, (class_7894)class_4120.method_47104((float)0.6f, (int)3)), (Object)2), (Object)Pair.of((Object)new class_4101(30, 60), (Object)1)));
    }

    private static class_7893<PigeonEntity> makeAddPlayerToAvoidTargetTask() {
        return class_4809.method_46914(PigeonBrain::hasAvoidTarget, (class_4140)class_4140.field_18444, (class_4140)class_4140.field_22357, (class_6019)RUN_FROM_PLAYER_MEMORY_DURATION);
    }

    private static boolean hasAvoidTarget(PigeonEntity pigeon) {
        if (pigeon.isTamed()) {
            return false;
        }
        class_4095<PigeonEntity> brain = pigeon.method_18868();
        if (!brain.method_18896(class_4140.field_18444)) {
            return false;
        }
        class_1657 player = (class_1657)brain.method_18904(class_4140.field_18444).get();
        if (!class_1301.field_6156.test(player) || pigeon.isTrusted(player)) {
            return false;
        }
        return pigeon.method_24516((class_1297)player, 5.0);
    }

    public static void onAttacked(PigeonEntity pigeon, class_1309 attacker) {
        if (attacker instanceof PigeonEntity || attacker == pigeon.method_35057()) {
            return;
        }
        class_4095<PigeonEntity> brain = pigeon.method_18868();
        brain.method_18875(FowlPlayMemoryModuleType.SEES_FOOD);
        if (attacker instanceof class_1657) {
            class_1657 player = (class_1657)attacker;
            brain.method_24525(FowlPlayMemoryModuleType.CANNOT_PICKUP_FOOD, (Object)true, 1200L);
            pigeon.stopTrusting(player);
        }
        brain.method_24525(class_4140.field_22357, (Object)attacker, 160L);
        PigeonBrain.alertOthers(pigeon, attacker);
    }

    protected static void alertOthers(PigeonEntity pigeon, class_1309 attacker) {
        PigeonBrain.getNearbyVisiblePigeons(pigeon).forEach(other -> {
            if (attacker instanceof class_1657) {
                class_1657 player = (class_1657)attacker;
                other.method_18868().method_24525(FowlPlayMemoryModuleType.CANNOT_PICKUP_FOOD, (Object)true, 1200L);
                ((PigeonEntity)((Object)other)).stopTrusting(player);
            }
            PigeonBrain.runAwayFrom((PigeonEntity)((Object)other), attacker);
        });
    }

    protected static void runAwayFrom(PigeonEntity pigeon, class_1309 target) {
        pigeon.method_18868().method_18875(class_4140.field_19293);
        pigeon.method_18868().method_24525(class_4140.field_22357, (Object)target, 160L);
    }

    protected static List<class_1296> getNearbyVisiblePigeons(PigeonEntity pigeon) {
        return (List)pigeon.method_18868().method_18904(FowlPlayMemoryModuleType.NEAREST_VISIBLE_ADULTS).orElse(ImmutableList.of());
    }

    private static boolean noFoodInRange(PigeonEntity pigeon) {
        Optional item = pigeon.method_18868().method_18904(class_4140.field_22332);
        return item.isEmpty() || !((class_1542)item.get()).method_24516((class_1297)pigeon, 32.0);
    }

    public static boolean isPlayerHoldingFood(class_1309 target) {
        return target.method_5864() == class_1299.field_6097 && target.method_24520(stack -> PigeonBrain.getFood().method_8093(stack));
    }

    private static boolean doesNotHaveFoodInHand(PigeonEntity pigeon) {
        return !PigeonBrain.getFood().method_8093(pigeon.method_6047());
    }

    private static boolean shouldFlyToRecipient(PigeonEntity pigeon) {
        UUID recipientUuid = pigeon.method_18868().method_18904(FowlPlayMemoryModuleType.RECIPIENT).orElse(null);
        if (recipientUuid == null) {
            return false;
        }
        class_1657 recipient = pigeon.method_37908().method_18470(recipientUuid);
        if (recipient == null) {
            return false;
        }
        return pigeon.method_5858((class_1297)recipient) > 64.0;
    }

    private static boolean shouldStopFlyingToRecipient(PigeonEntity pigeon) {
        UUID recipientUuid = pigeon.method_18868().method_18904(FowlPlayMemoryModuleType.RECIPIENT).orElse(null);
        if (recipientUuid == null) {
            return true;
        }
        class_1657 recipient = pigeon.method_37908().method_18470(recipientUuid);
        if (recipient == null) {
            return true;
        }
        return pigeon.method_5858((class_1297)recipient) < 16.0;
    }

    public static class_1856 getFood() {
        return class_1856.method_8106(FowlPlayItemTags.PIGEON_FOOD);
    }
}

