/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.entity.PigeonBrain;
import aqario.fowlplay.common.entity.TameableBirdEntity;
import aqario.fowlplay.common.sound.FowlPlaySoundEvents;
import aqario.fowlplay.common.tags.FowlPlayBiomeTags;
import aqario.fowlplay.common.tags.FowlPlayBlockTags;
import aqario.fowlplay.common.tags.FowlPlayItemTags;
import com.mojang.serialization.Dynamic;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_4095;
import net.minecraft.class_4209;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5537;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import net.minecraft.class_7094;
import net.minecraft.class_7988;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class PigeonEntity
extends TameableBirdEntity
implements class_7988<Variant> {
    private static final class_2940<Optional<UUID>> RECIPIENT = class_2945.method_12791(PigeonEntity.class, (class_2941)class_2943.field_13313);
    private static final class_2940<String> VARIANT = class_2945.method_12791(PigeonEntity.class, (class_2941)class_2943.field_13326);
    public final class_7094 idleState = new class_7094();
    public final class_7094 glideState = new class_7094();
    public final class_7094 flapState = new class_7094();
    public final class_7094 floatState = new class_7094();
    public final class_7094 sitState = new class_7094();

    public PigeonEntity(class_1299<? extends PigeonEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5941(class_7.field_9, -1.0f);
        this.method_5941(class_7.field_18, -3.0f);
        this.method_5941(class_7.field_4, 12.0f);
        this.method_5941(class_7.field_36432, -1.0f);
        this.method_5941(class_7.field_21516, -1.0f);
        this.method_5941(class_7.field_10, -1.0f);
    }

    public static boolean canSpawn(class_1299<? extends BirdEntity> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return world.method_23753(pos).method_40220(FowlPlayBiomeTags.SPAWNS_PIGEONS) && world.method_8320(pos.method_10074()).method_26164(FowlPlayBlockTags.SHOREBIRDS_SPAWNABLE_ON);
    }

    @Override
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        this.setVariant((Variant)((Object)class_156.method_32309(Variant.VARIANTS, (class_5819)world.method_8409())));
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    protected void method_5964(class_5819 random, class_1266 difficulty) {
        this.method_5946(class_1304.field_6173, 1.0f);
        this.method_5946(class_1304.field_6171, 1.0f);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(RECIPIENT, Optional.empty());
        builder.method_56912(VARIANT, (Object)Variant.BANDED.toString());
    }

    public Variant getVariant() {
        return Variant.valueOf((String)this.field_6011.method_12789(VARIANT));
    }

    public void setVariant(Variant variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant.toString());
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10582("variant", this.getVariant().toString());
        if (this.getRecipientUuid() != null) {
            nbt.method_25927("recipient", this.getRecipientUuid());
        }
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (!nbt.method_25928("recipient")) {
            this.setRecipientUuid(null);
            return;
        }
        this.setRecipientUuid(nbt.method_25926("recipient"));
        if (nbt.method_10545("variant")) {
            this.setVariant(Variant.valueOf(nbt.method_10558("variant")));
        }
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        class_1297 class_12972;
        boolean bl = super.method_5643(source, amount);
        if (this.method_37908().field_9236) {
            return false;
        }
        if (bl && (class_12972 = source.method_5529()) instanceof class_1309) {
            class_1309 entity = (class_1309)class_12972;
            PigeonBrain.onAttacked(this, entity);
        }
        return bl;
    }

    @Override
    public int getFlapFrequency() {
        return 7;
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return null;
    }

    public boolean method_6109() {
        return false;
    }

    public static class_5132.class_5133 createAttributes() {
        return FlyingBirdEntity.createAttributes().method_26868(class_5134.field_23716, 8.0).method_26868(class_5134.field_23719, (double)0.2f).method_26868(class_5134.field_23720, 0.25);
    }

    @Override
    protected class_1408 getLandNavigation() {
        class_1409 mobNavigation = new class_1409((class_1308)this, this.method_37908());
        mobNavigation.method_6363(false);
        mobNavigation.method_35139(true);
        mobNavigation.method_6354(false);
        return mobNavigation;
    }

    @Override
    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 playerStack = player.method_5998(hand);
        class_1799 bundleStack = this.method_5998(class_1268.field_5810);
        if (bundleStack.method_7960() && playerStack.method_7909() instanceof class_5537 && playerStack.method_57353().method_57832(class_9334.field_49631) && this.isTamed()) {
            if (!this.method_37908().field_9236) {
                this.method_6122(class_1268.field_5810, playerStack);
                player.method_6122(hand, class_1799.field_8037);
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        if (playerStack.method_7960() && bundleStack.method_7909() instanceof class_5537) {
            if (!this.method_37908().field_9236) {
                player.method_6122(hand, bundleStack);
                this.method_6122(class_1268.field_5810, class_1799.field_8037);
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        if (this.method_6481(playerStack) && !this.isTamed()) {
            if (!this.method_37908().field_9236) {
                this.method_6475(player, hand, playerStack);
                if (this.field_5974.method_43048(4) == 0) {
                    this.setOwner(player);
                    this.field_6189.method_6340();
                    this.method_37908().method_8421((class_1297)this, (byte)7);
                } else {
                    this.method_37908().method_8421((class_1297)this, (byte)6);
                }
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        if (this.method_24828() && this.isTamed() && this.isOwner((class_1309)player)) {
            if (!this.method_37908().field_9236) {
                this.setSitting(!this.isSitting());
                this.field_6282 = false;
                this.field_6189.method_6340();
                this.method_5980(null);
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return super.method_5992(player, hand);
    }

    @Override
    public boolean method_6481(class_1799 stack) {
        return !this.isTamed() && this.getFood().method_8093(stack);
    }

    @Override
    public boolean method_18397(class_1799 stack) {
        class_1304 equipmentSlot = this.method_32326(stack);
        if (!this.method_6118(equipmentSlot).method_7960()) {
            return false;
        }
        return equipmentSlot == class_1304.field_6173 || equipmentSlot == class_1304.field_6171 && super.method_18397(stack);
    }

    @Override
    public class_1856 getFood() {
        return class_1856.method_8106(FowlPlayItemTags.PIGEON_FOOD);
    }

    protected void method_16078() {
        super.method_16078();
        this.method_5775(this.method_6118(class_1304.field_6173));
        this.method_5673(class_1304.field_6173, class_1799.field_8037);
        this.method_5775(this.method_6118(class_1304.field_6171));
        this.method_5673(class_1304.field_6171, class_1799.field_8037);
    }

    @Override
    public void method_5773() {
        if (this.method_37908().method_8608()) {
            this.idleState.method_45317(!this.isFlying() && !this.method_5816() && !this.isInSittingPose(), this.field_6012);
            this.flapState.method_45317(this.isFlying(), this.field_6012);
            this.floatState.method_45317(this.method_5816(), this.field_6012);
            this.sitState.method_45317(this.isInSittingPose(), this.field_6012);
        }
        super.method_5773();
    }

    protected void method_5958() {
        this.method_37908().method_16107().method_15396("pigeonBrain");
        this.method_18868().method_19542((class_3218)this.method_37908(), (class_1309)this);
        this.method_37908().method_16107().method_15407();
        this.method_37908().method_16107().method_15396("pigeonActivityUpdate");
        PigeonBrain.reset(this);
        this.method_37908().method_16107().method_15407();
        super.method_5958();
        if (this.method_5682() == null) {
            return;
        }
        if (!this.isTamed()) {
            return;
        }
        class_1799 stack = this.method_6118(class_1304.field_6171);
        class_3222 recipient = this.method_5682().method_3760().method_14566(stack.method_7964().getString());
        if (!(stack.method_7909() instanceof class_5537) || !stack.method_57353().method_57832(class_9334.field_49631) || recipient == null || recipient.method_5667() == null) {
            this.setRecipientUuid(null);
            return;
        }
        this.setRecipientUuid(recipient.method_5667());
    }

    protected void method_5801() {
        this.method_5783(class_3417.field_14925, 0.15f, 1.0f);
    }

    public UUID getRecipientUuid() {
        return ((Optional)this.field_6011.method_12789(RECIPIENT)).orElse(null);
    }

    public void setRecipientUuid(@Nullable UUID uuid) {
        this.field_6011.method_12778(RECIPIENT, Optional.ofNullable(uuid));
    }

    public class_243 method_29919() {
        return new class_243(0.0, (double)(0.5f * this.method_5751()), (double)(this.method_17681() * 0.4f));
    }

    @Override
    protected boolean canSing() {
        if (this.method_37908().method_8530()) {
            return false;
        }
        List list = this.method_37908().method_8390(class_1657.class, this.method_53511().method_1009(16.0, 16.0, 16.0), class_1301.field_6155);
        if (list.isEmpty()) {
            return false;
        }
        return super.canSing();
    }

    @Override
    @Nullable
    protected class_3414 getCallSound() {
        return FowlPlaySoundEvents.ENTITY_PIGEON_CALL;
    }

    @Override
    @Nullable
    protected class_3414 getSongSound() {
        return FowlPlaySoundEvents.ENTITY_PIGEON_SONG;
    }

    @Override
    public int getCallDelay() {
        return 120;
    }

    @Override
    protected float getSongVolume() {
        return 8.0f;
    }

    public class_3414 method_18869(class_1799 stack) {
        return class_3417.field_14960;
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return null;
    }

    @Nullable
    protected class_3414 method_6002() {
        return null;
    }

    protected class_4095.class_5303<PigeonEntity> method_28306() {
        return PigeonBrain.createProfile();
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return PigeonBrain.create((class_4095<PigeonEntity>)this.method_28306().method_28335(dynamic));
    }

    public class_4095<PigeonEntity> method_18868() {
        return super.method_18868();
    }

    protected void method_18409() {
        super.method_18409();
        class_4209.method_19774((class_1309)this);
    }

    public static enum Variant {
        BANDED("banded"),
        CHECKERED("checkered"),
        GRAY("gray"),
        RUSTY("rusty"),
        WHITE("white");

        public static final List<Variant> VARIANTS;
        private final String id;

        private Variant(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        static {
            VARIANTS = List.of((Variant[])Arrays.stream(Variant.values()).toArray(Variant[]::new));
        }
    }
}

