/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.common.entity.FowlPlayEntityType;
import aqario.fowlplay.common.entity.RavenEntity;
import aqario.fowlplay.common.entity.ai.brain.FowlPlayActivities;
import aqario.fowlplay.common.entity.ai.brain.FowlPlayMemoryModuleType;
import aqario.fowlplay.common.entity.ai.brain.sensor.FowlPlaySensorType;
import aqario.fowlplay.common.entity.ai.brain.task.FlightTaskControl;
import aqario.fowlplay.common.entity.ai.brain.task.FlyTask;
import aqario.fowlplay.common.entity.ai.brain.task.GoToNearestWantedItemTask;
import aqario.fowlplay.common.entity.ai.brain.task.GoToWalkTargetTask;
import aqario.fowlplay.common.entity.ai.brain.task.LocateFoodTask;
import aqario.fowlplay.common.entity.ai.brain.task.StayNearClosestEntityTask;
import aqario.fowlplay.common.tags.FowlPlayItemTags;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1856;
import net.minecraft.class_4095;
import net.minecraft.class_4101;
import net.minecraft.class_4110;
import net.minecraft.class_4112;
import net.minecraft.class_4118;
import net.minecraft.class_4119;
import net.minecraft.class_4120;
import net.minecraft.class_4125;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4168;
import net.minecraft.class_4215;
import net.minecraft.class_4802;
import net.minecraft.class_4806;
import net.minecraft.class_4809;
import net.minecraft.class_4813;
import net.minecraft.class_4816;
import net.minecraft.class_4818;
import net.minecraft.class_4822;
import net.minecraft.class_4824;
import net.minecraft.class_4828;
import net.minecraft.class_5355;
import net.minecraft.class_5753;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_6028;
import net.minecraft.class_7687;
import net.minecraft.class_7893;
import net.minecraft.class_7894;
import net.minecraft.class_7898;

public class RavenBrain {
    private static final ImmutableList<class_4149<? extends class_4148<? super RavenEntity>>> SENSORS = ImmutableList.of((Object)class_4149.field_18466, (Object)class_4149.field_18467, (Object)class_4149.field_22358, (Object)class_4149.field_25362, (Object)class_4149.field_18469, (Object)class_4149.field_37447, FowlPlaySensorType.IS_FLYING, FowlPlaySensorType.NEAREST_ADULTS, FowlPlaySensorType.RAVEN_TEMPTATIONS, FowlPlaySensorType.RAVEN_ATTACKABLES);
    private static final ImmutableList<class_4140<?>> MEMORIES = ImmutableList.of((Object)class_4140.field_18446, (Object)class_4140.field_18441, (Object)class_4140.field_18442, (Object)class_4140.field_18445, (Object)class_4140.field_19293, (Object)class_4140.field_18449, (Object)class_4140.field_18448, (Object)class_4140.field_18444, (Object)class_4140.field_22354, (Object)class_4140.field_22357, (Object)class_4140.field_22475, (Object)class_4140.field_25359, (Object[])new class_4140[]{class_4140.field_22355, class_4140.field_30246, class_4140.field_28325, class_4140.field_28326, class_4140.field_40127, class_4140.field_28327, class_4140.field_18451, class_4140.field_18452, class_4140.field_30243, class_4140.field_37442, class_4140.field_37443, class_4140.field_39408, class_4140.field_22332, class_4140.field_22349, class_4140.field_38397, FowlPlayMemoryModuleType.IS_FLYING, FowlPlayMemoryModuleType.SEES_FOOD, FowlPlayMemoryModuleType.CANNOT_PICKUP_FOOD, FowlPlayMemoryModuleType.NEAREST_VISIBLE_ADULTS});
    private static final class_6019 RUN_FROM_PLAYER_MEMORY_DURATION = class_4802.method_24505((int)5, (int)7);
    private static final class_6019 FOLLOW_ADULT_RANGE = class_6019.method_35017((int)5, (int)16);
    private static final class_6019 STAY_NEAR_ENTITY_RANGE = class_6019.method_35017((int)16, (int)32);
    private static final int PICK_UP_RANGE = 32;
    private static final int AVOID_PLAYER_RADIUS = 10;
    private static final float RUN_SPEED = 1.4f;
    private static final float WALK_SPEED = 1.0f;
    private static final float FLY_SPEED = 2.0f;

    public static class_4095.class_5303<RavenEntity> createProfile() {
        return class_4095.method_28311(MEMORIES, SENSORS);
    }

    public static class_4095<?> create(class_4095<RavenEntity> brain) {
        RavenBrain.addCoreActivities(brain);
        RavenBrain.addIdleActivities(brain);
        RavenBrain.addFlyActivities(brain);
        RavenBrain.addAvoidActivities(brain);
        RavenBrain.addPickupFoodActivities(brain);
        RavenBrain.addFightActivities(brain);
        brain.method_18890((Set)ImmutableSet.of((Object)class_4168.field_18594));
        brain.method_18897(class_4168.field_18595);
        brain.method_24536();
        return brain;
    }

    public static void reset(RavenEntity raven) {
        class_4095<RavenEntity> brain = raven.method_18868();
        class_4168 activity = brain.method_24538().orElse(null);
        brain.method_24531((List)ImmutableList.of((Object)class_4168.field_18595, (Object)FowlPlayActivities.FLY, (Object)class_4168.field_22399, (Object)FowlPlayActivities.PICKUP_FOOD, (Object)class_4168.field_22396));
        if (activity == class_4168.field_22396 && brain.method_24538().orElse(null) != class_4168.field_22396) {
            brain.method_24525(class_4140.field_30246, (Object)true, 2400L);
        }
    }

    private static void addCoreActivities(class_4095<RavenEntity> brain) {
        brain.method_18882(class_4168.field_18594, 0, ImmutableList.of(FlightTaskControl.stopFalling(), (Object)new class_4125(0.5f), (Object)new class_6028(1.4f), RavenBrain.makeAddPlayerToAvoidTargetTask(), LocateFoodTask.run(), (Object)new class_4110(45, 90), (Object)new class_4112(), (Object)new class_5753(class_4140.field_28326), (Object)new class_5753(class_4140.field_40127)));
    }

    private static void addIdleActivities(class_4095<RavenEntity> brain) {
        brain.method_24529(class_4168.field_18595, ImmutableList.of((Object)Pair.of((Object)1, (Object)new class_4806(FowlPlayEntityType.RAVEN, 1.0f, 20)), (Object)Pair.of((Object)2, (Object)class_5355.method_46896((class_6019)FOLLOW_ADULT_RANGE, (float)1.0f)), (Object)Pair.of((Object)3, (Object)class_4119.method_47065(RavenBrain::isPlayerHoldingFood, (float)32.0f)), (Object)Pair.of((Object)4, (Object)class_4824.method_47120(raven -> !raven.method_5816(), RavenBrain::getAttackTarget)), (Object)Pair.of((Object)5, StayNearClosestEntityTask.create(STAY_NEAR_ENTITY_RANGE, 1.0f)), (Object)Pair.of((Object)6, (Object)new class_7687((class_6017)class_6019.method_35017((int)150, (int)250), 30.0f, 0.0f, 0.0f)), (Object)Pair.of((Object)7, (Object)new class_4118((Map)ImmutableMap.of((Object)class_4140.field_18445, (Object)class_4141.field_18457), (List)ImmutableList.of((Object)Pair.of((Object)class_4818.method_47014((float)1.0f), (Object)4), (Object)Pair.of((Object)new class_4101(100, 300), (Object)3), (Object)Pair.of(FlightTaskControl.startFlying(raven -> raven.method_5816() || raven.method_59922().method_43057() < 0.3f), (Object)1))))), (Set)ImmutableSet.of((Object)Pair.of(FowlPlayMemoryModuleType.IS_FLYING, (Object)class_4141.field_18457), (Object)Pair.of((Object)class_4140.field_22357, (Object)class_4141.field_18457), (Object)Pair.of(FowlPlayMemoryModuleType.SEES_FOOD, (Object)class_4141.field_18457), (Object)Pair.of((Object)class_4140.field_22355, (Object)class_4141.field_18457)));
    }

    private static void addFlyActivities(class_4095<RavenEntity> brain) {
        brain.method_24529(FowlPlayActivities.FLY, ImmutableList.of((Object)Pair.of((Object)1, FlightTaskControl.tryStopFlying(raven -> true)), (Object)Pair.of((Object)2, (Object)class_4824.method_47119(RavenBrain::getAttackTarget)), (Object)Pair.of((Object)3, StayNearClosestEntityTask.create(STAY_NEAR_ENTITY_RANGE, 2.0f)), (Object)Pair.of((Object)4, (Object)new class_4118((Map)ImmutableMap.of((Object)class_4140.field_18445, (Object)class_4141.field_18457), (List)ImmutableList.of((Object)Pair.of(FlyTask.create(2.0f, 64, 32), (Object)1))))), (Set)ImmutableSet.of((Object)Pair.of(FowlPlayMemoryModuleType.IS_FLYING, (Object)class_4141.field_18456), (Object)Pair.of((Object)class_4140.field_22357, (Object)class_4141.field_18457), (Object)Pair.of(FowlPlayMemoryModuleType.SEES_FOOD, (Object)class_4141.field_18457), (Object)Pair.of((Object)class_4140.field_22355, (Object)class_4141.field_18457)));
    }

    private static void addAvoidActivities(class_4095<RavenEntity> brain) {
        brain.method_24527(class_4168.field_22399, 10, ImmutableList.of(FlightTaskControl.startFlying(raven -> true), GoToWalkTargetTask.toEntity((class_4140<? extends class_1297>)class_4140.field_22357, raven -> Float.valueOf(raven.isFlying() ? 2.0f : 1.4f), 10, true), RavenBrain.makeRandomFollowTask(), RavenBrain.makeRandomWanderTask(), (Object)class_4813.method_46922(entity -> true, (class_4140)class_4140.field_22357)), class_4140.field_22357);
    }

    private static void addPickupFoodActivities(class_4095<RavenEntity> brain) {
        brain.method_24529(FowlPlayActivities.PICKUP_FOOD, ImmutableList.of((Object)Pair.of((Object)0, FlightTaskControl.startFlying(raven -> true)), (Object)Pair.of((Object)1, GoToNearestWantedItemTask.create(RavenBrain::doesNotHaveFoodInHand, entity -> Float.valueOf(entity.isFlying() ? 2.0f : 1.4f), true, 32)), (Object)Pair.of((Object)2, (Object)class_4813.method_46922(RavenBrain::noFoodInRange, FowlPlayMemoryModuleType.SEES_FOOD))), Set.of(Pair.of(FowlPlayMemoryModuleType.SEES_FOOD, (Object)class_4141.field_18456), Pair.of((Object)class_4140.field_22357, (Object)class_4141.field_18457)));
    }

    private static void addFightActivities(class_4095<RavenEntity> brain) {
        brain.method_24527(class_4168.field_22396, 0, ImmutableList.of(FlightTaskControl.startFlying(raven -> true), (Object)class_4828.method_47132(), (Object)class_4822.method_47094((float)2.0f), (Object)class_4816.method_46987((int)20), (Object)class_4813.method_46922(class_4215::method_41331, (class_4140)class_4140.field_22355)), class_4140.field_22355);
    }

    private static Optional<? extends class_1309> getAttackTarget(RavenEntity raven) {
        return class_4215.method_41331((class_1309)raven) ? Optional.empty() : raven.method_18868().method_18904(class_4140.field_30243);
    }

    private static ImmutableList<Pair<class_7894<class_1309>, Integer>> createLookTasks() {
        return ImmutableList.of((Object)Pair.of((Object)class_4119.method_47057(FowlPlayEntityType.RAVEN, (float)8.0f), (Object)1), (Object)Pair.of((Object)class_4119.method_47056((float)8.0f), (Object)1));
    }

    private static class_4118<class_1309> makeRandomFollowTask() {
        return new class_4118((List)ImmutableList.builder().addAll(RavenBrain.createLookTasks()).add((Object)Pair.of((Object)new class_4101(30, 60), (Object)1)).build());
    }

    private static class_4118<RavenEntity> makeRandomWanderTask() {
        return new class_4118((List)ImmutableList.of((Object)Pair.of((Object)class_4818.method_47014((float)0.6f), (Object)2), (Object)Pair.of((Object)class_7898.method_47227(livingEntity -> true, (class_7894)class_4120.method_47104((float)0.6f, (int)3)), (Object)2), (Object)Pair.of((Object)new class_4101(30, 60), (Object)1)));
    }

    private static class_7893<RavenEntity> makeAddPlayerToAvoidTargetTask() {
        return class_4809.method_46914(RavenBrain::hasAvoidTarget, (class_4140)class_4140.field_18444, (class_4140)class_4140.field_22357, (class_6019)RUN_FROM_PLAYER_MEMORY_DURATION);
    }

    private static boolean hasAvoidTarget(RavenEntity raven) {
        class_4095<RavenEntity> brain = raven.method_18868();
        if (!brain.method_18896(class_4140.field_18444)) {
            return false;
        }
        class_1657 player = (class_1657)brain.method_18904(class_4140.field_18444).get();
        if (!class_1301.field_6156.test(player) || raven.isTrusted(player)) {
            return false;
        }
        return raven.method_24516((class_1297)player, 10.0);
    }

    public static void onAttacked(RavenEntity raven, class_1309 attacker) {
        if (attacker instanceof RavenEntity) {
            return;
        }
        class_4095<RavenEntity> brain = raven.method_18868();
        brain.method_18875(FowlPlayMemoryModuleType.SEES_FOOD);
        if (attacker instanceof class_1657) {
            class_1657 player = (class_1657)attacker;
            brain.method_24525(FowlPlayMemoryModuleType.CANNOT_PICKUP_FOOD, (Object)true, 1200L);
            raven.stopTrusting(player);
        }
        brain.method_24525(class_4140.field_22357, (Object)attacker, 160L);
        RavenBrain.alertOthers(raven, attacker);
    }

    protected static void alertOthers(RavenEntity raven, class_1309 attacker) {
        RavenBrain.getNearbyVisibleRavens(raven).forEach(other -> {
            if (attacker instanceof class_1657) {
                class_1657 player = (class_1657)attacker;
                other.method_18868().method_24525(FowlPlayMemoryModuleType.CANNOT_PICKUP_FOOD, (Object)true, 1200L);
                ((RavenEntity)((Object)other)).stopTrusting(player);
            }
            RavenBrain.runAwayFrom((RavenEntity)((Object)other), attacker);
        });
    }

    protected static void runAwayFrom(RavenEntity raven, class_1309 target) {
        raven.method_18868().method_18875(class_4140.field_19293);
        raven.method_18868().method_24525(class_4140.field_22357, (Object)target, 160L);
    }

    protected static List<class_1296> getNearbyVisibleRavens(RavenEntity raven) {
        return (List)raven.method_18868().method_18904(FowlPlayMemoryModuleType.NEAREST_VISIBLE_ADULTS).orElse(ImmutableList.of());
    }

    private static boolean noFoodInRange(RavenEntity raven) {
        Optional item = raven.method_18868().method_18904(class_4140.field_22332);
        return item.isEmpty() || !((class_1542)item.get()).method_24516((class_1297)raven, 32.0);
    }

    public static boolean isPlayerHoldingFood(class_1309 target) {
        return target.method_5864() == class_1299.field_6097 && target.method_24520(stack -> RavenBrain.getFood().method_8093(stack));
    }

    private static boolean doesNotHaveFoodInHand(RavenEntity raven) {
        return !RavenBrain.getFood().method_8093(raven.method_6047());
    }

    public static class_1856 getFood() {
        return class_1856.method_8106(FowlPlayItemTags.RAVEN_FOOD);
    }
}

