/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.entity.data.FowlPlayTrackedDataHandlerRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2945;

public abstract class TrustingBirdEntity
extends FlyingBirdEntity {
    protected static final class_2940<List<UUID>> TRUSTED = class_2945.method_12791(TrustingBirdEntity.class, FowlPlayTrackedDataHandlerRegistry.UUID_LIST);

    protected TrustingBirdEntity(class_1299<? extends BirdEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(TRUSTED, new ArrayList());
    }

    protected class_2499 toNbtList(List<UUID> uuids) {
        class_2499 nbtList = new class_2499();
        for (UUID uuid : uuids) {
            nbtList.add((Object)class_2512.method_25929((UUID)uuid));
        }
        return nbtList;
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10566("trusted", (class_2520)this.toNbtList(this.getTrustedUuids()));
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (!nbt.method_10545("trusted")) {
            return;
        }
        class_2499 list = (class_2499)nbt.method_10580("trusted");
        if (list != null) {
            list.forEach(element -> this.addTrustedUuid(class_2512.method_25930((class_2520)element)));
        }
    }

    @Override
    protected void method_5949(class_1542 item) {
        UUID thrower;
        super.method_5949(item);
        UUID uUID = thrower = item.method_24921() != null ? item.method_24921().method_5667() : null;
        if (thrower != null && !this.isTrustedUuid(thrower)) {
            if (this.field_5974.method_43048(3) == 0) {
                this.addTrustedUuid(thrower);
                this.method_37908().method_8421((class_1297)this, (byte)7);
            } else {
                this.method_37908().method_8421((class_1297)this, (byte)6);
            }
        }
    }

    protected void showEmoteParticle(boolean positive) {
        class_2400 particleEffect = positive ? class_2398.field_11201 : class_2398.field_11251;
        for (int i = 0; i < 7; ++i) {
            double d = this.field_5974.method_43059() * 0.02;
            double e = this.field_5974.method_43059() * 0.02;
            double f = this.field_5974.method_43059() * 0.02;
            this.method_37908().method_8406((class_2394)particleEffect, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), d, e, f);
        }
    }

    @Override
    public void method_5711(byte status) {
        if (status == 7) {
            this.showEmoteParticle(true);
        } else if (status == 6) {
            this.showEmoteParticle(false);
        } else {
            super.method_5711(status);
        }
    }

    public List<UUID> getTrustedUuids() {
        return (List)this.field_6011.method_12789(TRUSTED);
    }

    public void addTrustedUuid(UUID uuid) {
        List trusted = (List)this.field_6011.method_12789(TRUSTED);
        trusted.add(uuid);
        this.field_6011.method_12778(TRUSTED, (Object)trusted);
    }

    public void removeTrustedUuid(UUID uuid) {
        List trusted = (List)this.field_6011.method_12789(TRUSTED);
        trusted.remove(uuid);
        this.field_6011.method_12778(TRUSTED, (Object)trusted);
    }

    public void stopTrusting(class_1657 player) {
        this.removeTrustedUuid(player.method_5667());
    }

    public List<class_1657> getTrusted() {
        List<UUID> uuids = this.getTrustedUuids();
        ArrayList<class_1657> entities = new ArrayList<class_1657>();
        for (UUID uuid : uuids) {
            entities.add(this.method_37908().method_18470(uuid));
        }
        return entities;
    }

    public boolean method_18395(class_1309 target) {
        class_1657 player;
        return (!(target instanceof class_1657) || !this.isTrusted(player = (class_1657)target)) && super.method_18395(target);
    }

    public boolean isTrusted(class_1657 player) {
        return this.getTrusted().contains(player);
    }

    public boolean isTrustedUuid(UUID uuid) {
        return this.getTrustedUuids().contains(uuid);
    }
}

