/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.gui.widgets;

import io.github.kosmx.emotes.arch.screen.widget.IEmoteListWidgetHelper;
import io.github.kosmx.emotes.main.EmoteHolder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEmoteListWidget<E extends AbstractEmoteEntry<E>>
extends class_4280<E>
implements IEmoteListWidgetHelper {
    protected List<E> emotes = new ArrayList();
    private final class_437 screen;

    @Override
    public IEmoteListWidgetHelper.IEmoteEntry getSelectedEntry() {
        return (IEmoteListWidgetHelper.IEmoteEntry)this.method_25334();
    }

    public AbstractEmoteListWidget(class_310 minecraftClient, int y, int width, int height, int itemHeight, class_437 screen) {
        super(minecraftClient, width, height, y, itemHeight);
        this.field_22744 = false;
        this.screen = screen;
    }

    public int method_25322() {
        return this.field_22758 - 10;
    }

    protected abstract E newEmoteEntry(class_310 var1, EmoteHolder var2);

    @Override
    public void emotesSetLeftPos(int left) {
        this.method_46421(left);
    }

    @Override
    public void setEmotes(Iterable<EmoteHolder> list, boolean showInvalid) {
        this.emotes = new ArrayList();
        for (EmoteHolder emoteHolder : list) {
            this.emotes.add(this.newEmoteEntry(class_310.method_1551(), emoteHolder));
        }
        if (showInvalid) {
            for (EmoteHolder emoteHolder : this.getEmptyEmotes()) {
                this.emotes.add(this.newEmoteEntry(class_310.method_1551(), emoteHolder));
            }
        }
        this.emotes.sort(Comparator.comparing(o -> o.emote.name.getString().toLowerCase()));
        this.filter(() -> "");
    }

    @Override
    public void filter(Supplier<String> string) {
        this.method_25339();
        for (AbstractEmoteEntry emote : this.emotes) {
            if (!emote.emote.name.getString().toLowerCase().contains(string.get()) && !emote.emote.description.getString().toLowerCase().contains(string.get()) && !emote.emote.author.getString().toLowerCase().equals(string.get())) continue;
            this.method_25321((class_350.class_351)emote);
        }
        this.method_25307(0.0);
    }

    @Override
    public void renderThis(class_332 matrices, int mouseX, int mouseY, float tickDelta) {
        this.method_25394(matrices, mouseX, mouseY, tickDelta);
    }

    protected int method_25329() {
        return this.method_46426() + this.field_22758 - 6;
    }

    public boolean method_25370() {
        return this.screen.method_25399() == this;
    }

    public static abstract class AbstractEmoteEntry<T extends AbstractEmoteEntry<T>>
    extends class_4280.class_4281<T>
    implements IEmoteListWidgetHelper.IEmoteEntry {
        protected final class_310 client;
        public final EmoteHolder emote;

        public AbstractEmoteEntry(class_310 client, EmoteHolder emote) {
            this.client = client;
            this.emote = emote;
        }

        public void method_25343(@NotNull class_332 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.renderThis(matrices, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
        }

        @Override
        public EmoteHolder getEmote() {
            return this.emote;
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (button == 0) {
                this.onPressed();
                return true;
            }
            return false;
        }

        @NotNull
        public class_2561 method_37006() {
            return this.emote.name;
        }

        protected abstract void onPressed();
    }
}

