/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.screen;

import dev.kosmx.playerAnim.core.util.MathHelper;
import io.github.kosmx.emotes.PlatformTools;
import io.github.kosmx.emotes.arch.gui.screen.ConfigScreen;
import io.github.kosmx.emotes.arch.gui.widgets.AbstractEmoteListWidget;
import io.github.kosmx.emotes.arch.screen.EmoteConfigScreen;
import io.github.kosmx.emotes.arch.screen.ExportMenu;
import io.github.kosmx.emotes.arch.screen.widget.AbstractFastChooseWidget;
import io.github.kosmx.emotes.arch.screen.widget.IChooseWheel;
import io.github.kosmx.emotes.arch.screen.widget.IWidgetLogic;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.main.MainClientInit;
import io.github.kosmx.emotes.main.config.ClientConfig;
import io.github.kosmx.emotes.main.config.ClientSerializer;
import io.github.kosmx.emotes.server.serializer.UniversalEmoteSerializer;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmoteMenu
extends EmoteConfigScreen {
    protected int activeKeyTime = 0;
    private AbstractEmoteListWidget<?> emoteList;
    private FastChooseWidget fastMenu;
    private final class_5250 unboundText = class_3675.field_16237.method_27445().method_27662();
    private class_4185 setKeyButton;
    private boolean save = false;
    private class_342 searchBox;
    private List<PositionedText> texts = new ArrayList<PositionedText>();
    private class_4185 resetKey;
    private final class_2561 resetOneText = class_2561.method_43471((String)"controls.reset");
    private final class_2561 resetAllText = class_2561.method_43471((String)"controls.resetAll");
    private boolean resetOnlySelected;
    private int keyBoundEmotes = -1;
    private ChangeListener watcher = null;

    public EmoteMenu(@Nullable class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"emotecraft.menu"), parent);
    }

    public void method_25426() {
        block3: {
            this.texts = new ArrayList<PositionedText>();
            MainClientInit.loadEmotes();
            try {
                if (this.watcher == null || this.watcher.isClosed()) {
                    this.watcher = new ChangeListener(EmoteInstance.instance.getExternalEmoteDir().toPath());
                }
            }
            catch (IOException e) {
                EmoteInstance.instance.getLogger().log(Level.WARNING, "can't watch emotes dir for changes: " + e.getMessage());
                if (!((Boolean)EmoteInstance.config.showDebug.get()).booleanValue()) break block3;
                e.printStackTrace();
            }
        }
        int x1 = this.getWidth() / 2 - (int)((double)this.getWidth() / 2.2 - 16.0) - 12;
        int width1 = (int)((double)this.getWidth() / 2.2 - 16.0);
        class_5250 title1 = class_2561.method_43471((String)"emotecraft.search");
        this.searchBox = new class_342(class_310.method_1551().field_1772, x1, 12, width1, 20, (class_2561)title1);
        this.searchBox.method_1863(string -> this.emoteList.filter(string::toLowerCase));
        this.method_37063((class_364)this.searchBox);
        int x7 = this.getWidth() / 2 - 154;
        int y1 = this.getHeight() - 30;
        class_5250 msg4 = class_2561.method_43471((String)"emotecraft.openFolder");
        class_4185 openBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)msg4, buttonWidget -> PlatformTools.openExternalEmotesDir()::accept).method_46433(x7, y1).method_46437(150, 20).method_46431());
        this.emoteList = this.newEmoteList((int)((double)this.getWidth() / 2.2 - 16.0), this.getHeight() - this.searchBox.method_46427() - this.searchBox.method_25364());
        int downSpacing = this.getHeight() - openBtn.method_46427();
        int lsH = this.getHeight() - this.emoteList.method_46427() - downSpacing - 10;
        this.emoteList.method_53533(lsH);
        this.emoteList.emotesSetLeftPos(this.getWidth() / 2 - (int)((double)this.getWidth() / 2.2 - 16.0) - 12);
        this.addToChildren(this.emoteList);
        int x = Math.min(this.getWidth() / 4, (int)((double)this.getHeight() / 2.5));
        this.fastMenu = this.newFastChooseWidget(this.getWidth() / 2 + 2, this.getHeight() / 2 - 8, x - 7);
        this.addToChildren(this.fastMenu);
        int x6 = this.getWidth() - 100;
        class_5250 msg3 = class_2561.method_43471((String)"emotecraft.options.options");
        this.method_37063((class_364)class_4185.method_46430((class_2561)msg3, button3 -> this.openClothConfigScreen()).method_46433(x6, 4).method_46437(96, 20).method_46431());
        int x5 = this.getWidth() - 200;
        class_5250 msg2 = class_2561.method_43471((String)"emotecraft.options.export");
        this.method_37063((class_364)class_4185.method_46430((class_2561)msg2, button2 -> this.openExportMenuScreen()).method_46433(x5, 4).method_46437(96, 20).method_46431());
        int x4 = this.getWidth() / 2 + 10;
        int y = this.getHeight() - 30;
        class_2561 msg1 = class_5244.field_24334;
        this.method_37063((class_364)class_4185.method_46430((class_2561)msg1, button1 -> this.openParent()).method_46433(x4, y).method_46437(96, 20).method_46431());
        int x3 = this.getWidth() / 2 + 6;
        this.setKeyButton = class_4185.method_46430((class_2561)this.unboundText, button -> this.activateKey()::accept).method_46433(x3, 60).method_46437(96, 20).method_46431();
        this.method_37063((class_364)this.setKeyButton);
        int x2 = this.getWidth() / 2 + 124;
        class_5250 msg = class_2561.method_43471((String)"controls.reset");
        this.resetKey = class_4185.method_46430((class_2561)msg, this::resetKeyAction).method_46433(x2, 60).method_46437(96, 20).method_46431();
        this.method_37063((class_364)this.resetKey);
        this.emoteList.setEmotes((Iterable<EmoteHolder>)EmoteHolder.list, true);
        this.method_48265((class_364)this.searchBox);
        this.texts.add(new PositionedText("emotecraft.options.keybind", this.getWidth() / 2 + 115, 40));
        this.texts.add(new PositionedText((class_2561)class_2561.method_43471((String)"emotecraft.options.fastmenu"), this.getWidth() / 2 + 10 + x / 2, this.getHeight() / 2 - 54));
        this.texts.add(new PositionedText((class_2561)class_2561.method_43471((String)"emotecraft.options.fastmenu2"), this.getWidth() / 2 + 10 + x / 2, this.getHeight() / 2 - 40));
        this.texts.add(new PositionedText((class_2561)class_2561.method_43471((String)"emotecraft.options.fastmenu3"), this.getWidth() / 2 + 10 + x / 2, this.getHeight() / 2 - 26));
    }

    protected FastChooseWidget newFastChooseWidget(int x, int y, int size) {
        return new FastMenuImpl(this, x, y, size);
    }

    public void openClothConfigScreen() {
        class_310.method_1551().method_1507((class_437)new ConfigScreen(this));
    }

    public void openExportMenuScreen() {
        class_310.method_1551().method_1507((class_437)new ExportMenu(this));
    }

    private void activateKey() {
        if (this.emoteList.getSelectedEntry() != null) {
            this.setFocusedElement((class_364)this.setKeyButton);
            this.activeKeyTime = 200;
        }
    }

    public void setFocusedElement(@javax.annotation.Nullable class_364 focused) {
        if (this.activeKeyTime == 0) {
            this.method_25395(focused);
        }
    }

    private void resetKeyAction(class_4185 button) {
        if (this.resetOnlySelected) {
            if (this.emoteList.getSelectedEntry() == null) {
                return;
            }
            ((ClientConfig)EmoteInstance.config).emoteKeyMap.removeL(this.emoteList.getSelectedEntry().getEmote().getUuid());
            this.keyBoundEmotes = -1;
            this.save = true;
        } else {
            class_5250 text = class_2561.method_43471((String)"emotecraft.resetAllKeys.message").method_27693(" (" + this.keyBoundEmotes + ")");
            class_310.method_1551().method_1507((class_437)new class_410(aBoolean -> {
                if (aBoolean.booleanValue()) {
                    ((ClientConfig)EmoteInstance.config).emoteKeyMap.clear();
                    this.saveConfig();
                    this.keyBoundEmotes = -1;
                }
                this.getMinecraft().method_1507((class_437)this);
            }::accept, (class_2561)class_2561.method_43471((String)"emotecraft.resetAllKeys.title"), (class_2561)text));
        }
    }

    public void method_25393() {
        if (this.activeKeyTime == 1) {
            this.setFocusedElement(null);
        }
        if (this.activeKeyTime != 0) {
            --this.activeKeyTime;
        }
        if (this.watcher != null && this.watcher.isChanged()) {
            this.reload();
        }
        super.method_25393();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.activeKeyTime != 0 && this.emoteList.getSelectedEntry() != null) {
            return this.setKey(class_3675.class_307.field_1672.method_1447(button));
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private void countEmotesWithKeyBind() {
        this.keyBoundEmotes = ((ClientConfig)EmoteInstance.config).emoteKeyMap.size();
    }

    public void method_25394(@NotNull class_332 matrices, int mouseX, int mouseY, float delta) {
        super.method_25394(matrices, mouseX, mouseY, delta);
        if (this.emoteList.getSelectedEntry() == null) {
            this.setKeyButton.field_22763 = false;
            this.resetOnlySelected = false;
        } else {
            this.setKeyButton.field_22763 = true;
            this.resetOnlySelected = ((ClientConfig)EmoteInstance.config).emoteKeyMap.containsL(this.emoteList.getSelectedEntry().getEmote().getUuid());
        }
        if (this.resetOnlySelected) {
            this.resetKey.field_22763 = true;
            this.resetKey.method_25355(this.resetOneText);
        } else {
            if (this.keyBoundEmotes < 0) {
                this.countEmotesWithKeyBind();
            }
            if (this.keyBoundEmotes > 0) {
                this.resetKey.field_22763 = true;
                this.resetKey.method_25355((class_2561)this.resetAllText.method_27661().method_27693(" (" + this.keyBoundEmotes + ")"));
            } else {
                this.resetKey.field_22763 = false;
                this.resetKey.method_25355(this.resetOneText);
            }
        }
        for (PositionedText str : this.texts) {
            str.render(matrices);
        }
        this.emoteList.renderThis(matrices, mouseX, mouseY, delta);
        this.searchBox.method_25394(matrices, mouseX, mouseY, delta);
        this.fastMenu.render(matrices, mouseX, mouseY, delta);
        this.updateKeyText();
    }

    private boolean setKey(class_3675.class_306 key) {
        boolean bl = false;
        if (this.emoteList.getSelectedEntry() != null) {
            bl = true;
            if (!this.applyKey(false, this.emoteList.getSelectedEntry().getEmote(), key)) {
                class_5250 title1 = class_2561.method_43471((String)"emotecraft.sure");
                class_5250 text = class_2561.method_43471((String)"emotecraft.sure2");
                class_410 confirmScreen = new class_410(aBoolean -> this.confirmReturn((boolean)aBoolean, this.emoteList.getSelectedEntry().getEmote(), key)::accept, (class_2561)title1, (class_2561)text);
                class_310.method_1551().method_1507((class_437)confirmScreen);
            }
        }
        return bl;
    }

    private void confirmReturn(boolean choice, EmoteHolder emoteHolder, class_3675.class_306 key) {
        if (choice) {
            this.applyKey(true, emoteHolder, key);
            this.saveConfig();
        }
        this.getMinecraft().method_1507((class_437)this);
    }

    private boolean applyKey(boolean force, EmoteHolder emote, class_3675.class_306 key) {
        boolean bl = true;
        for (EmoteHolder emoteHolder : EmoteHolder.list) {
            if (key.equals((Object)class_3675.field_16237) || !EmoteMenu.getKey(emoteHolder.getUuid()).equals((Object)key)) continue;
            bl = false;
            if (!force) continue;
            ((ClientConfig)EmoteInstance.config).emoteKeyMap.removeL(emoteHolder.getUuid());
        }
        if (bl || force) {
            ((ClientConfig)EmoteInstance.config).emoteKeyMap.put(emote.getUuid(), key);
            this.save = true;
            this.keyBoundEmotes = -1;
        }
        this.activeKeyTime = 0;
        return bl;
    }

    @Nonnull
    public static class_3675.class_306 getKey(UUID emoteID) {
        class_3675.class_306 key = ((ClientConfig)EmoteInstance.config).emoteKeyMap.getR(emoteID);
        if (key == null) {
            return class_3675.field_16237;
        }
        return key;
    }

    public void method_25432() {
        if (this.save) {
            this.saveConfig();
        }
        this.watcher.close();
    }

    private void saveConfig() {
        ClientSerializer.saveConfig();
    }

    private void reload() {
        if (this.save) {
            this.saveConfig();
        }
        MainClientInit.loadEmotes();
        this.emoteList.setEmotes((Iterable<EmoteHolder>)EmoteHolder.list, true);
    }

    private void updateKeyText() {
        if (this.emoteList.getSelectedEntry() != null) {
            class_2561 message = EmoteMenu.getKey(this.emoteList.getSelectedEntry().getEmote().getUuid()).method_27445();
            if (this.activeKeyTime != 0) {
                message = class_2561.method_43470((String)"> ").method_10852(message).method_27692(class_124.field_1054).method_27693(" <").method_27692(class_124.field_1054);
            }
            this.setKeyButton.method_25355(message);
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int mod) {
        if (this.emoteList.getSelectedEntry() != null && this.activeKeyTime != 0) {
            if (keyCode == 256) {
                return this.setKey(class_3675.field_16237);
            }
            return this.setKey(class_3675.method_15985((int)keyCode, (int)scanCode));
        }
        return super.method_25404(keyCode, scanCode, mod);
    }

    public void method_29638(@NotNull List<Path> paths) {
        this.addEmotes(paths);
        List<Path> folders = paths.stream().filter(path -> path.toFile().isDirectory()).toList();
        for (Path folder : folders) {
            ArrayList<Path> collect = new ArrayList<Path>();
            Arrays.stream(Objects.requireNonNull(folder.toFile().listFiles((dir, name) -> name.endsWith(".json") || name.endsWith(".png")))).forEach(file -> collect.add(file.toPath()));
            this.addEmotes(collect);
        }
    }

    private void addEmotes(List<Path> emotes) {
        List<Path> newEmotes = emotes.stream().filter(path -> {
            if (path.toFile().isFile() && (path.toFile().getName().endsWith(".png") || path.toFile().getName().endsWith(".emote") && EmoteInstance.config.enableQuark.get().booleanValue())) {
                return true;
            }
            try {
                return !UniversalEmoteSerializer.readData(Files.newInputStream(path, new OpenOption[0]), path.getFileName().toString()).isEmpty();
            }
            catch (Exception e) {
                return false;
            }
        }).toList();
        Path emotesDir = EmoteInstance.instance.getExternalEmoteDir().toPath();
        for (Path path2 : newEmotes) {
            try {
                Files.copy(path2, emotesDir.resolve(path2.getFileName()), new CopyOption[0]);
            }
            catch (IOException e) {
                if (e instanceof FileAlreadyExistsException) {
                    EmoteInstance.instance.getLogger().log(Level.INFO, String.valueOf(path2.getFileName()) + " is already in the emotes directory", true);
                    continue;
                }
                EmoteInstance.instance.getLogger().log(Level.FINEST, "Unknown error while copying " + String.valueOf(path2.getFileName()) + ": " + e.getMessage(), true);
                if (!((Boolean)EmoteInstance.config.showDebug.get()).booleanValue()) continue;
                e.printStackTrace();
            }
        }
    }

    protected AbstractEmoteListWidget<?> newEmoteList(int width, int height) {
        return new EmoteListImpl(this.getMinecraft(), 51, width, height, 36, this);
    }

    @Override
    public void method_25419() {
        super.method_25419();
    }

    private static class ChangeListener
    implements AutoCloseable {
        @javax.annotation.Nullable
        private WatchService watcher;

        ChangeListener(Path path) throws IOException {
            this.watcher = path.getFileSystem().newWatchService();
            path.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        }

        boolean isChanged() {
            WatchKey key;
            boolean bl = false;
            if (this.watcher != null && (key = this.watcher.poll()) != null) {
                bl = !key.pollEvents().isEmpty();
                key.reset();
            }
            return bl;
        }

        @Override
        public void close() {
            try {
                if (this.watcher != null) {
                    this.watcher.close();
                    this.watcher = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public boolean isClosed() {
            return this.watcher == null;
        }
    }

    protected abstract class FastChooseWidget
    extends AbstractFastChooseWidget {
        public FastChooseWidget(int x, int y, int size) {
            super(x, y, size);
        }

        @Override
        protected boolean isValidClickButton(int button) {
            return (button == 0 || button == 1) && EmoteMenu.this.activeKeyTime == 0;
        }

        @Override
        protected boolean onClick(IChooseWheel.IChooseElement element, int button) {
            if (EmoteMenu.this.activeKeyTime != 0) {
                return false;
            }
            if (button == 1) {
                element.clearEmote();
                EmoteMenu.this.save = true;
                return true;
            }
            if (EmoteMenu.this.emoteList.getSelectedEntry() != null) {
                element.setEmote(EmoteMenu.this.emoteList.getSelectedEntry().getEmote());
                EmoteMenu.this.save = true;
                return true;
            }
            return false;
        }

        @Override
        protected boolean doHoverPart(IChooseWheel.IChooseElement part) {
            return EmoteMenu.this.activeKeyTime == 0;
        }

        @Override
        protected boolean doesShowInvalid() {
            return true;
        }
    }

    private static class PositionedText {
        private final class_2561 str;
        private final int x;
        private final int y;

        private PositionedText(class_2561 str, int x, int y) {
            this.str = str;
            this.x = x;
            this.y = y;
        }

        private PositionedText(String str, int x, int y) {
            this.str = class_2561.method_43471((String)str);
            this.x = x;
            this.y = y;
        }

        private void render(class_332 matrixStack) {
            matrixStack.method_27534(class_310.method_1551().field_1772, this.str, this.x, this.y, MathHelper.colorHelper((int)255, (int)255, (int)255, (int)255));
        }
    }

    public class FastMenuImpl
    extends FastChooseWidget
    implements IWidgetLogic {
        private boolean focused = true;

        public FastMenuImpl(EmoteMenu this$0, int x, int y, int size) {
            super(x, y, size);
        }

        public void method_25365(boolean bl) {
            this.focused = bl;
        }

        public boolean method_25370() {
            return this.focused;
        }
    }

    public static class EmoteListImpl
    extends AbstractEmoteListWidget<EmoteListEntryImpl> {
        public EmoteListImpl(class_310 minecraftClient, int y, int width, int height, int itemHeight, class_437 screen) {
            super(minecraftClient, y, width, height, itemHeight, screen);
        }

        @Override
        protected EmoteListEntryImpl newEmoteEntry(class_310 client, EmoteHolder emoteHolder) {
            return new EmoteListEntryImpl(client, emoteHolder);
        }

        public class EmoteListEntryImpl
        extends AbstractEmoteListWidget.AbstractEmoteEntry<EmoteListEntryImpl> {
            public EmoteListEntryImpl(class_310 client, EmoteHolder emote) {
                super(client, emote);
            }

            @Override
            protected void onPressed() {
                EmoteListImpl.this.method_25313((class_350.class_351)this);
            }
        }
    }
}

