/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.screen;

import dev.kosmx.playerAnim.core.data.AnimationFormat;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import io.github.kosmx.emotes.PlatformTools;
import io.github.kosmx.emotes.api.proxy.AbstractNetworkInstance;
import io.github.kosmx.emotes.arch.screen.EmoteConfigScreen;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.inline.TmpGetters;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.main.config.ClientConfig;
import io.github.kosmx.emotes.server.serializer.UniversalEmoteSerializer;
import io.github.kosmx.emotes.server.serializer.type.EmoteSerializerException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class ExportMenu
extends EmoteConfigScreen {
    protected ExportMenu(class_437 screen) {
        super((class_2561)class_2561.method_43471((String)"emotecraft.exportMenu"), screen);
    }

    public void method_25426() {
        int h = 10;
        int x3 = this.getWidth() / 2 - 100;
        int y3 = h += 30;
        class_5250 msg3 = class_2561.method_43471((String)"emotecraft.exportjson");
        this.method_37063((class_364)class_4185.method_46430((class_2561)msg3, iButton1 -> this.saveAllJson()).method_46433(x3, y3).method_46437(200, 20).method_46431());
        int x2 = this.getWidth() / 2 - 100;
        int y2 = h += 30;
        class_5250 msg2 = class_2561.method_43471((String)"emotecraft.exportbin");
        this.method_37063((class_364)class_4185.method_46430((class_2561)msg2, iButton -> this.saveAllBinary()).method_46433(x2, y2).method_46437(200, 20).method_46431());
        int x1 = this.getWidth() / 2 + 10;
        int y1 = this.getHeight() - 30;
        class_2561 msg1 = class_5244.field_24334;
        this.method_37063((class_364)class_4185.method_46430((class_2561)msg1, button -> this.openParent()).method_46433(x1, y1).method_46437(96, 20).method_46431());
        int x = this.getWidth() / 2 - 154;
        int y = this.getHeight() - 30;
        class_5250 msg = class_2561.method_43471((String)"emotecraft.openFolder");
        this.method_37063((class_364)class_4185.method_46430((class_2561)msg, buttonWidget -> PlatformTools.openExternalEmotesDir()::accept).method_46433(x, y).method_46437(150, 20).method_46431());
    }

    private void saveAllJson() {
        this.exportEmotesInFormat(AnimationFormat.JSON_EMOTECRAFT);
    }

    private void saveAllBinary() {
        this.exportEmotesInFormat(AnimationFormat.BINARY);
    }

    private void exportEmotesInFormat(AnimationFormat format) {
        for (EmoteHolder emoteHolder : EmoteHolder.list) {
            KeyframeAnimation emote = emoteHolder.getEmote();
            if (emote.extraData.containsKey("isBuiltin") && !((ClientConfig)EmoteInstance.config).exportBuiltin.get().booleanValue()) continue;
            EmoteInstance.instance.getLogger().log(Level.FINER, "Saving " + emoteHolder.name.getString() + " into " + format.getExtension());
            try {
                Path exportDir = EmoteInstance.instance.getExternalEmoteDir().toPath().resolve(format.getExtension() + "_export");
                if (!exportDir.toFile().isDirectory()) {
                    Files.createDirectories(exportDir, new FileAttribute[0]);
                }
                Path file = ExportMenu.createFileName(emoteHolder, exportDir, format);
                OutputStream stream = Files.newOutputStream(file, new OpenOption[0]);
                UniversalEmoteSerializer.writeKeyframeAnimation(stream, emote, format);
                stream.close();
                if (format != AnimationFormat.JSON_EMOTECRAFT || !emote.extraData.containsKey("iconData")) continue;
                Path iconPath = exportDir.resolve(file.getFileName().toString().substring(0, file.getFileName().toString().lastIndexOf(".")) + ".png");
                if (iconPath.toFile().isFile()) {
                    throw new IOException("File already exists: " + String.valueOf(iconPath));
                }
                OutputStream iconStream = Files.newOutputStream(iconPath, new OpenOption[0]);
                iconStream.write(AbstractNetworkInstance.safeGetBytesFromBuffer((ByteBuffer)emote.extraData.get("iconData")));
                iconStream.close();
            }
            catch (EmoteSerializerException | IOException | InvalidPathException e) {
                e.printStackTrace();
                TmpGetters.getClientMethods().toastExportMessage(2, (class_2561)class_2561.method_43471((String)("emotecraft.export.error." + format.getExtension())), emoteHolder.name.getString());
            }
        }
        TmpGetters.getClientMethods().toastExportMessage(1, (class_2561)class_2561.method_43471((String)("emotecraft.export.done." + format.getExtension())), "emotes/" + format.getExtension() + "_export/");
        EmoteInstance.instance.getLogger().log(Level.FINER, "All emotes are saved in " + format.getExtension() + " format", true);
    }

    private static Path createFileName(EmoteHolder emote, Path originPath, AnimationFormat format) {
        Object name = emote.name.getString().replaceAll("[\\\\/]", "#");
        String finalName = null;
        while (finalName == null) {
            try {
                originPath.resolve((String)name);
                finalName = name;
            }
            catch (InvalidPathException e) {
                int i = e.getIndex();
                name = ((String)name).substring(0, i) + "#" + ((String)name).substring(i + 1);
            }
        }
        int i = 2;
        Path file = originPath.resolve(finalName + "." + format.getExtension());
        if (!file.getParent().equals(originPath)) {
            finalName = Integer.toString(emote.hashCode());
            file = originPath.resolve(finalName + "." + format.getExtension());
        }
        while (file.toFile().isFile()) {
            file = originPath.resolve(finalName + "_" + i++ + "." + format.getExtension());
        }
        return file;
    }

    public void method_25394(@NotNull class_332 matrices, int mouseX, int mouseY, float tickDelta) {
        super.method_25394(matrices, mouseX, mouseY, tickDelta);
    }
}

