/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.fabric.mixin;

import io.github.kosmx.emotes.api.proxy.AbstractNetworkInstance;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.github.kosmx.emotes.fabric.FabricWrapper;
import io.github.kosmx.emotes.fabric.network.EmoteCustomPayload;
import io.github.kosmx.emotes.fabric.network.ServerNetwork;
import io.github.kosmx.emotes.server.network.EmotePlayTracker;
import io.github.kosmx.emotes.server.network.IServerNetworkInstance;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2596;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={class_3244.class})
public abstract class ServerPlayNetworkInstance
implements IServerNetworkInstance {
    @Unique
    private final EmotePlayTracker emoteTracker = new EmotePlayTracker();
    @Unique
    HashMap<Byte, Byte> versions = new HashMap();

    @Shadow
    public abstract class_3222 method_32311();

    @Override
    public HashMap<Byte, Byte> getRemoteVersions() {
        return this.versions;
    }

    @Override
    public void setVersions(HashMap<Byte, Byte> map) {
        this.versions = map;
    }

    @Override
    public EmotePlayTracker getEmoteTracker() {
        return this.emoteTracker;
    }

    @Override
    public boolean sendPlayerID() {
        return true;
    }

    @Override
    public void sendMessage(EmotePacket.Builder builder, @Nullable UUID target) throws IOException {
        this.sendMessage(AbstractNetworkInstance.safeGetBytesFromBuffer(builder.setVersion(this.getRemoteVersions()).build().write()), null);
    }

    public void sendMessage(byte[] bytes, @Nullable UUID target) {
        this.sendPacket(ServerPlayNetworking.createS2CPacket((class_8710)new EmoteCustomPayload(bytes)));
    }

    @Unique
    public void sendPacket(class_2596<?> packet) {
        class_3244 s = (class_3244)this;
        s.method_14364(packet);
    }

    @Override
    public void sendConfigCallback() {
        EmotePacket.Builder builder = new EmotePacket.Builder().configureToConfigExchange(true);
        try {
            this.sendPacket(ServerPlayNetworking.createS2CPacket((class_8710)new EmoteCustomPayload(builder.build().write().array())));
        }
        catch (IOException e) {
            FabricWrapper.logger.error("Failed to send config callback", (Throwable)e);
        }
    }

    @Override
    public void presenceResponse() {
        IServerNetworkInstance.presenceResponse(this);
        for (class_3222 player : PlayerLookup.tracking((class_1297)this.method_32311())) {
            ServerNetwork.getInstance().playerStartTracking(player, this.method_32311());
        }
    }

    @Override
    public boolean isActive() {
        return true;
    }
}

