/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.fabric.network;

import io.github.kosmx.emotes.api.proxy.AbstractNetworkInstance;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.github.kosmx.emotes.fabric.network.EmoteCustomPayload;
import io.github.kosmx.emotes.fabric.network.ServerNetwork;
import io.github.kosmx.emotes.inline.TmpGetters;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.fabric.api.client.networking.v1.C2SPlayChannelEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;

public class ClientNetworkInstance
extends AbstractNetworkInstance
implements C2SPlayChannelEvents.Register,
ClientPlayConnectionEvents.Disconnect {
    public static ClientNetworkInstance networkInstance = new ClientNetworkInstance();
    private final AtomicInteger connectState = new AtomicInteger(0);

    public void init() {
        ClientPlayConnectionEvents.JOIN.register(this::playerJoin);
        C2SPlayChannelEvents.REGISTER.register((Object)this);
        ClientPlayConnectionEvents.DISCONNECT.register((Object)this);
    }

    @Override
    public void presenceResponse() {
    }

    public void onChannelRegister(class_634 handler, PacketSender sender, class_310 client, List<class_2960> channels) {
        if (channels.contains(ServerNetwork.channelID) && this.connectState.incrementAndGet() == 2) {
            this.connectState.set(0);
            this.sendConfigCallback();
        }
    }

    private void playerJoin(class_634 clientPacketListener, PacketSender packetSender, class_310 minecraft) {
        ClientPlayNetworking.registerReceiver(EmoteCustomPayload.TYPE, this::receivePayload);
        if (this.connectState.incrementAndGet() == 2) {
            this.connectState.set(0);
            this.sendConfigCallback();
        }
    }

    public void onPlayDisconnect(class_634 handler, class_310 client) {
        this.connectState.set(0);
        this.disconnect();
    }

    void receivePayload(EmoteCustomPayload type, ClientPlayNetworking.Context ctx) {
        this.receiveMessage(type.getData());
    }

    @Override
    public boolean sendPlayerID() {
        return false;
    }

    @Override
    public boolean isActive() {
        return ClientPlayNetworking.canSend((class_2960)ServerNetwork.channelID);
    }

    @Override
    public void sendMessage(EmotePacket.Builder builder, @Nullable UUID target) throws IOException {
        if (target != null) {
            builder.configureTarget(target);
        }
        EmotePacket writer = builder.build();
        ClientPlayNetworking.send((class_8710)new EmoteCustomPayload(writer.write().array()));
        if (writer.data.emoteData != null && writer.data.emoteData.extraData.containsKey("song") && !writer.data.writeSong) {
            TmpGetters.getClientMethods().sendChatMessage((class_2561)class_2561.method_43471((String)"emotecraft.song_too_big_to_send"));
        }
    }
}

