/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.fabric.network;

import io.github.kosmx.emotes.api.proxy.INetworkInstance;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.github.kosmx.emotes.common.network.GeyserEmotePacket;
import io.github.kosmx.emotes.common.network.objects.NetData;
import io.github.kosmx.emotes.fabric.FabricWrapper;
import io.github.kosmx.emotes.fabric.network.EmoteCustomPayload;
import io.github.kosmx.emotes.fabric.network.GeyserEmoteCustomPayload;
import io.github.kosmx.emotes.server.network.AbstractServerEmotePlay;
import io.github.kosmx.emotes.server.network.IServerNetworkInstance;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public class ServerNetwork
extends AbstractServerEmotePlay<class_1657> {
    public static final class_2960 channelID = class_2960.method_60654((String)"emotecraft:emote");
    public static final class_2960 geyserChannelID = class_2960.method_60654((String)"geyser:emote");
    public static ServerNetwork instance = new ServerNetwork();

    public void init() {
        PayloadTypeRegistry.playC2S().register(GeyserEmoteCustomPayload.TYPE, GeyserEmoteCustomPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(GeyserEmoteCustomPayload.TYPE, GeyserEmoteCustomPayload.CODEC);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            ServerPlayNetworking.registerReceiver((class_3244)handler, EmoteCustomPayload.TYPE, this::receivePayload);
            ServerPlayNetworking.registerReceiver((class_3244)handler, GeyserEmoteCustomPayload.TYPE, this::receiveGeyserPayload);
        });
    }

    void receivePayload(EmoteCustomPayload type, ServerPlayNetworking.Context ctx) {
        try {
            this.receiveMessage(type.getData(), ctx.player(), (INetworkInstance)ctx.player().field_13987);
        }
        catch (IOException e) {
            FabricWrapper.logger.error("Failed to receive payload", (Throwable)e);
        }
    }

    void receiveGeyserPayload(GeyserEmoteCustomPayload type, ServerPlayNetworking.Context ctx) {
        this.receiveGeyserMessage(ctx.player(), type.getData());
    }

    @Override
    protected UUID getUUIDFromPlayer(class_1657 player) {
        return player.method_5667();
    }

    @Override
    protected class_1657 getPlayerFromUUID(UUID player) {
        return FabricWrapper.SERVER_INSTANCE.method_3760().method_14602(player);
    }

    @Override
    protected long getRuntimePlayerID(class_1657 player) {
        return player.method_5628();
    }

    @Override
    protected IServerNetworkInstance getPlayerNetworkInstance(class_1657 player) {
        return (IServerNetworkInstance)((class_3222)player).field_13987;
    }

    @Override
    protected void sendForEveryoneElse(GeyserEmotePacket packet, class_1657 player) {
        PlayerLookup.tracking((class_1297)player).forEach(serverPlayer -> {
            try {
                if (serverPlayer != player && ServerPlayNetworking.canSend((class_3222)serverPlayer, (class_2960)geyserChannelID)) {
                    ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)new GeyserEmoteCustomPayload(packet.write()));
                }
            }
            catch (IOException e) {
                FabricWrapper.logger.error("Failed to send geyser emote packet to {}", (Object)serverPlayer.method_5820(), (Object)e);
            }
        });
    }

    @Override
    protected void sendForEveryoneElse(NetData data, GeyserEmotePacket emotePacket, class_1657 player) {
        data.player = player.method_5667();
        PlayerLookup.tracking((class_1297)player).forEach(serverPlayerEntity -> {
            try {
                if (serverPlayerEntity != player) {
                    if (ServerPlayNetworking.canSend((class_3222)serverPlayerEntity, (class_2960)channelID)) {
                        EmotePacket.Builder packetBuilder = new EmotePacket.Builder(data);
                        packetBuilder.setVersion(((IServerNetworkInstance)serverPlayerEntity.field_13987).getRemoteVersions());
                        ServerPlayNetworking.send((class_3222)serverPlayerEntity, (class_8710)new EmoteCustomPayload(packetBuilder.build().write().array()));
                    } else if (ServerPlayNetworking.canSend((class_3222)serverPlayerEntity, (class_2960)geyserChannelID) && emotePacket != null) {
                        ServerPlayNetworking.send((class_3222)serverPlayerEntity, (class_8710)new GeyserEmoteCustomPayload(emotePacket.write()));
                    }
                }
            }
            catch (IOException e) {
                FabricWrapper.logger.error("Failed to send emote packet to {}", (Object)serverPlayerEntity.method_5820(), (Object)e);
            }
        });
    }

    @Override
    protected void sendForPlayerInRange(NetData data, class_1657 player, UUID target) {
        PlayerLookup.tracking((class_1297)player).forEach(serverPlayerEntity -> this.targetFinder((class_3222)serverPlayerEntity, data, target));
    }

    @Override
    protected void sendForPlayer(NetData data, class_1657 player, UUID target) {
        PlayerLookup.all((MinecraftServer)Objects.requireNonNull(player.method_5682())).forEach(serverPlayerEntity -> this.targetFinder((class_3222)serverPlayerEntity, data, target));
    }

    private void targetFinder(class_3222 serverPlayerEntity, NetData data, UUID target) {
        if (serverPlayerEntity.method_5667().equals(target)) {
            try {
                EmotePacket.Builder packetBuilder = new EmotePacket.Builder(data);
                packetBuilder.setVersion(((IServerNetworkInstance)serverPlayerEntity.field_13987).getRemoteVersions());
                ServerPlayNetworking.send((class_3222)serverPlayerEntity, (class_8710)new EmoteCustomPayload(packetBuilder.build().write().array()));
            }
            catch (IOException e) {
                FabricWrapper.logger.error("Failed to send emote packet to {}", (Object)serverPlayerEntity.method_5820(), (Object)e);
            }
        }
    }
}

