/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.main.mixinFunctions;

import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Pair;
import io.github.kosmx.emotes.api.events.client.ClientEmoteEvents;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.executor.emotePlayer.IEmotePlayerEntity;
import io.github.kosmx.emotes.inline.TmpGetters;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.main.config.ClientConfig;
import io.github.kosmx.emotes.main.emotePlay.EmotePlayer;
import io.github.kosmx.emotes.main.network.ClientEmotePlay;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public interface IPlayerEntity
extends IEmotePlayerEntity {
    public static final int FPPerspective = 0;
    public static final Supplier<Integer> TPBPerspective = () -> (Boolean)((ClientConfig)EmoteInstance.config).frontAsTPPerspective.get() != false ? 2 : 1;

    default public void initEmotePlay() {
        Pair<KeyframeAnimation, Integer> p = ClientEmotePlay.getEmoteForUUID(this.emotes_getUUID());
        if (p != null) {
            ((ClientEmoteEvents.EmotePlayEvent)ClientEmoteEvents.EMOTE_PLAY.invoker()).onEmotePlay((KeyframeAnimation)p.getLeft(), this.emotes_getUUID());
            this.emotecraft$playEmote((KeyframeAnimation)p.getLeft(), (Integer)p.getRight(), false);
        }
        if (!this.isMainPlayer() && TmpGetters.getClientMethods().getMainPlayer() != null && TmpGetters.getClientMethods().getMainPlayer().isPlayingEmote()) {
            IPlayerEntity playerEntity = TmpGetters.getClientMethods().getMainPlayer();
            ClientEmotePlay.clientRepeatLocalEmote(playerEntity.emotecraft$getEmote().getData(), playerEntity.emotecraft$getEmote().getTick(), this.emotes_getUUID());
        }
    }

    default public void initEmotePerspective(EmotePlayer emotePlayer) {
        if (((ClientConfig)EmoteInstance.config).enablePerspective.get().booleanValue() && this.isMainPlayer() && TmpGetters.getClientMethods().getPerspective() == 0) {
            emotePlayer.perspective = 1;
            TmpGetters.getClientMethods().setPerspective(TPBPerspective.get());
        }
    }

    @Override
    @Nullable
    public EmotePlayer emotecraft$getEmote();

    @Override
    default public boolean isPlayingEmote() {
        return EmotePlayer.isRunningEmote(this.emotecraft$getEmote());
    }

    @Override
    default public boolean isMainPlayer() {
        return TmpGetters.getClientMethods().getMainPlayer() == this;
    }

    public int emotes_getAge();

    public int emotes_getAndIncreaseAge();

    @Override
    default public void emoteTick() {
        if (this.emotes_getAge() <= 1 && this.emotes_getAndIncreaseAge() == 1) {
            this.initEmotePlay();
        }
        if (this.isPlayingEmote()) {
            this.emotecraft$setBodyYaw(this.emotecraft$getViewYaw());
            this.emoteTickCallback();
            if (this.isMainPlayer() && this.emotecraft$getEmote().perspective == 1 && TmpGetters.getClientMethods().getPerspective() != TPBPerspective.get().intValue()) {
                this.emotecraft$getEmote().perspective = 0;
            }
            if (this.isMainPlayer() && !this.emotecraft$isForcedEmote() && !EmoteHolder.canRunEmote(this)) {
                this.emotecraft$getEmote().stop();
                ClientEmotePlay.clientStopLocalEmote(this.emotecraft$getEmote().getData());
            }
        }
    }

    @Override
    default public void stopEmote() {
        if (this.emotecraft$getEmote() != null) {
            this.emotecraft$getEmote().stop();
            this.emotecraft$voidEmote();
        }
    }

    @Override
    default public void stopEmote(UUID emoteID) {
        if (this.emotecraft$getEmote() != null && this.emotecraft$getEmote().getData().getUuid().equals(emoteID)) {
            this.emotecraft$getEmote().stop();
            this.emotecraft$voidEmote();
        }
    }

    public void emotecraft$voidEmote();
}

