/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.client;

import dev.emi.emi.api.stack.EmiStack;
import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.client.ClientBuiltPool;
import fzzyhmstrs.emi_loot.client.ClientRawPool;
import fzzyhmstrs.emi_loot.client.LootReceiver;
import fzzyhmstrs.emi_loot.util.ConditionalStack;
import fzzyhmstrs.emi_loot.util.LText;
import fzzyhmstrs.emi_loot.util.TextKey;
import io.netty.handler.codec.DecoderException;
import it.unimi.dsi.fastutil.floats.Float2ObjectArrayMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3545;

public abstract class AbstractTextKeyParsingClientLootTable<T extends LootReceiver>
implements LootReceiver {
    private final Map<List<TextKey>, ClientRawPool> rawItems;
    public List<ClientBuiltPool> builtItems;

    public AbstractTextKeyParsingClientLootTable() {
        this.rawItems = new HashMap<List<TextKey>, ClientRawPool>();
    }

    public AbstractTextKeyParsingClientLootTable(Map<List<TextKey>, ClientRawPool> map) {
        this.rawItems = map;
    }

    static class_2960 getIdFromBuf(class_2540 buf) {
        String idToParse = buf.method_19772();
        if (idToParse.contains(":")) {
            return class_2960.method_60654((String)idToParse);
        }
        if (idToParse.startsWith("b/")) {
            return class_2960.method_60654((String)("blocks/" + idToParse.substring(2)));
        }
        if (idToParse.startsWith("e/")) {
            return class_2960.method_60654((String)("entities/" + idToParse.substring(2)));
        }
        if (idToParse.startsWith("c/")) {
            return class_2960.method_60654((String)("chests/" + idToParse.substring(2)));
        }
        if (idToParse.startsWith("g/")) {
            return class_2960.method_60654((String)("gameplay/" + idToParse.substring(2)));
        }
        if (idToParse.startsWith("a/")) {
            return class_2960.method_60654((String)("archaeology/" + idToParse.substring(2)));
        }
        return class_2960.method_60654((String)idToParse);
    }

    abstract List<class_3545<Integer, class_2561>> getSpecialTextKeyList(class_1937 var1, class_2248 var2);

    public void build(class_1937 world, class_2248 block) {
        HashMap<List, Object2FloatMap> builderItems = new HashMap<List, Object2FloatMap>();
        this.rawItems.forEach((list, pool) -> {
            ArrayList<class_3545<Integer, class_2561>> applyToAllList = new ArrayList<class_3545<Integer, class_2561>>(this.getSpecialTextKeyList(world, block));
            list.forEach(textKey -> {
                class_2561 text = textKey.process(class_1799.field_8037, world).text();
                applyToAllList.add(new class_3545((Object)textKey.index(), (Object)text));
            });
            pool.map().forEach((poolList, poolItemMap) -> {
                ArrayList newPoolList = new ArrayList();
                Object2FloatOpenHashMap itemsToAdd = new Object2FloatOpenHashMap();
                ArrayList itemsToRemove = new ArrayList();
                poolList.forEach(arg_0 -> AbstractTextKeyParsingClientLootTable.lambda$build$4(poolItemMap, world, itemsToRemove, (Object2FloatMap)itemsToAdd, newPoolList, arg_0));
                list.forEach(arg_0 -> AbstractTextKeyParsingClientLootTable.lambda$build$8(poolItemMap, world, itemsToRemove, (Object2FloatMap)itemsToAdd, arg_0));
                ArrayList summedList = new ArrayList(applyToAllList);
                summedList.addAll(newPoolList);
                if (!(!summedList.isEmpty() || EMILoot.config.skippedKeys.contains("emi_loot.no_conditions") && EMILoot.config.isTooltipStyle())) {
                    summedList.add(new class_3545((Object)TextKey.getIndex("emi_loot.no_conditions"), (Object)LText.translatable("emi_loot.no_conditions")));
                }
                Object2FloatMap builderPoolMap = builderItems.getOrDefault(summedList, (Object2FloatMap)poolItemMap);
                builderPoolMap.putAll((Map)itemsToAdd);
                itemsToRemove.forEach(arg_0 -> ((Object2FloatMap)builderPoolMap).removeFloat(arg_0));
                builderItems.put(summedList, builderPoolMap);
            });
        });
        LinkedList<ClientBuiltPool> finalList = new LinkedList<ClientBuiltPool>();
        builderItems.forEach((builtList, builtMap) -> {
            Float2ObjectArrayMap consolidatedMap = new Float2ObjectArrayMap();
            builtMap.forEach((arg_0, arg_1) -> AbstractTextKeyParsingClientLootTable.lambda$build$11((Float2ObjectMap)consolidatedMap, arg_0, arg_1));
            Float2ObjectArrayMap emiConsolidatedMap = new Float2ObjectArrayMap();
            consolidatedMap.forEach((arg_0, arg_1) -> AbstractTextKeyParsingClientLootTable.lambda$build$12((Float2ObjectMap)emiConsolidatedMap, arg_0, arg_1));
            finalList.add(new ClientBuiltPool((List<class_3545<Integer, class_2561>>)builtList, emiConsolidatedMap.float2ObjectEntrySet().stream().map(entry -> new ConditionalStack((List<class_3545<Integer, class_2561>>)builtList, entry.getFloatKey(), (List)entry.getValue())).toList()));
        });
        this.builtItems = finalList;
    }

    abstract class_3545<class_2960, class_2960> getBufId(class_2540 var1);

    abstract T simpleTableToReturn(class_3545<class_2960, class_2960> var1, class_2540 var2);

    abstract T emptyTableToReturn();

    abstract T filledTableToReturn(class_3545<class_2960, class_2960> var1, Map<List<TextKey>, ClientRawPool> var2);

    @Override
    public LootReceiver fromBuf(class_2540 buf, class_1937 world) {
        int builderCount;
        boolean isEmpty = true;
        class_3545<class_2960, class_2960> ids = this.getBufId(buf);
        class_2960 id = (class_2960)ids.method_15442();
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.info("parsing table " + String.valueOf(id));
        }
        if ((builderCount = buf.readShort()) == -1) {
            return this.simpleTableToReturn(ids, buf);
        }
        HashMap<List<TextKey>, ClientRawPool> itemMap = new HashMap<List<TextKey>, ClientRawPool>();
        for (int b = 0; b < builderCount; ++b) {
            LinkedList<TextKey> qualifierList = new LinkedList<TextKey>();
            int conditionSize = buf.readShort();
            for (int i = 0; i < conditionSize; ++i) {
                try {
                    TextKey key = TextKey.fromBuf(buf);
                    qualifierList.add(key);
                    continue;
                }
                catch (DecoderException e) {
                    EMILoot.LOGGER.error("Client table " + String.valueOf(id) + " had a TextKey decoding error while reading a loot condition!");
                }
            }
            int functionSize = buf.readShort();
            for (int i = 0; i < functionSize; ++i) {
                try {
                    TextKey key = TextKey.fromBuf(buf);
                    qualifierList.add(key);
                    continue;
                }
                catch (DecoderException e) {
                    EMILoot.LOGGER.error("Client table " + String.valueOf(id) + " had a TextKey decoding error while reading a loot function!");
                }
            }
            ClientRawPool pool = itemMap.getOrDefault(qualifierList, new ClientRawPool(new HashMap<List<TextKey>, Object2FloatMap<class_1799>>()));
            int pileSize = buf.readShort();
            for (int i = 0; i < pileSize; ++i) {
                LinkedList<TextKey> pileQualifierList = new LinkedList<TextKey>();
                int pileQualifierSize = buf.readShort();
                for (int j = 0; j < pileQualifierSize; ++j) {
                    try {
                        TextKey key = TextKey.fromBuf(buf);
                        pileQualifierList.add(key);
                        continue;
                    }
                    catch (DecoderException e) {
                        EMILoot.LOGGER.error("Client table " + String.valueOf(id) + " had a TextKey decoding error while reading an item pile qualifier!");
                    }
                }
                Object2FloatMap<class_1799> pileItemMap = pool.map().getOrDefault(pileQualifierList, (Object2FloatMap<class_1799>)new Object2FloatOpenHashMap());
                int pileItemSize = buf.readShort();
                for (int j = 0; j < pileItemSize; ++j) {
                    class_1799 stack = this.readItemStack(buf, world);
                    float weight = buf.readFloat();
                    pileItemMap.put((Object)stack, weight);
                    isEmpty = false;
                }
                pool.map().put(pileQualifierList, pileItemMap);
            }
            itemMap.put(qualifierList, pool);
        }
        if (isEmpty) {
            return this.emptyTableToReturn();
        }
        return this.filledTableToReturn(ids, itemMap);
    }

    private static /* synthetic */ void lambda$build$12(Float2ObjectMap emiConsolidatedMap, Float consolidatedWeight, List consolidatedList) {
        LinkedList<EmiStack> emiStacks = new LinkedList<EmiStack>();
        for (class_1799 i : consolidatedList) {
            emiStacks.add(EmiStack.of((class_1799)i));
        }
        emiConsolidatedMap.put(consolidatedWeight.floatValue(), emiStacks);
    }

    private static /* synthetic */ void lambda$build$11(Float2ObjectMap consolidatedMap, class_1799 stack, Float weight) {
        List consolidatedList = (List)consolidatedMap.getOrDefault(weight.floatValue(), new LinkedList());
        if (!consolidatedList.contains(stack)) {
            consolidatedList.add(stack);
        }
        consolidatedMap.put(weight.floatValue(), (Object)consolidatedList);
    }

    private static /* synthetic */ void lambda$build$8(Object2FloatMap poolItemMap, class_1937 world, List itemsToRemove, Object2FloatMap itemsToAdd, TextKey textKey) {
        poolItemMap.forEach((poolStack, weight) -> {
            List<class_1799> stacks = textKey.process((class_1799)poolStack, world).stacks();
            AtomicReference<Float> toAddWeight = new AtomicReference<Float>(Float.valueOf(1.0f));
            if (!stacks.contains(poolStack)) {
                itemsToRemove.add(poolStack);
                toAddWeight.set(Float.valueOf(poolItemMap.getFloat(poolStack)));
            }
            stacks.forEach(stack -> {
                if (poolItemMap.containsKey(stack)) {
                    toAddWeight.set(Float.valueOf(poolItemMap.getFloat(stack)));
                }
            });
            stacks.forEach(stack -> {
                if (!poolItemMap.containsKey(stack)) {
                    itemsToAdd.put(stack, ((Float)toAddWeight.get()).floatValue());
                }
            });
        });
    }

    private static /* synthetic */ void lambda$build$4(Object2FloatMap poolItemMap, class_1937 world, List itemsToRemove, Object2FloatMap itemsToAdd, List newPoolList, TextKey textKey) {
        poolItemMap.forEach((poolStack, weight) -> {
            List<class_1799> stacks = textKey.process((class_1799)poolStack, world).stacks();
            AtomicReference<Float> toAddWeight = new AtomicReference<Float>(Float.valueOf(1.0f));
            if (!stacks.contains(poolStack)) {
                itemsToRemove.add(poolStack);
                toAddWeight.set(Float.valueOf(poolItemMap.getFloat(poolStack)));
            }
            stacks.forEach(stack -> {
                if (poolItemMap.containsKey(stack)) {
                    toAddWeight.set(Float.valueOf(poolItemMap.getFloat(stack)));
                }
            });
            stacks.forEach(stack -> {
                if (!poolItemMap.containsKey(stack)) {
                    itemsToAdd.put(stack, ((Float)toAddWeight.get()).floatValue());
                }
            });
        });
        class_2561 text = textKey.process(class_1799.field_8037, world).text();
        newPoolList.add(new class_3545((Object)textKey.index(), (Object)text));
    }
}

