/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.emi;

import com.google.common.collect.ArrayListMultimap;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.EMILootAgnos;
import fzzyhmstrs.emi_loot.client.ClientChestLootTable;
import fzzyhmstrs.emi_loot.emi.EmiClientPlugin;
import fzzyhmstrs.emi_loot.util.FloatTrimmer;
import fzzyhmstrs.emi_loot.util.LText;
import fzzyhmstrs.emi_loot.util.TrimmedTitle;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class ChestLootRecipe
implements EmiRecipe {
    private final ClientChestLootTable loot;
    private final ArrayListMultimap<Float, EmiStack> lootStacksSorted;
    private final int lootStacksSortedSize;
    private final List<EmiStack> outputs;
    private boolean isGuaranteedNonChance = false;
    private final TrimmedTitle title;
    private final float columns = 8.0f;

    public ChestLootRecipe(ClientChestLootTable loot) {
        class_5250 rawTitle;
        this.loot = loot;
        if (loot.items.size() == 1 && loot.items.values().toFloatArray()[0] == 1.0f) {
            this.isGuaranteedNonChance = true;
        }
        ArrayListMultimap map2 = ArrayListMultimap.create();
        LinkedList<EmiStack> outputsList = new LinkedList<EmiStack>();
        loot.items.forEach((item, weight) -> {
            EmiStack stack = EmiStack.of((class_1799)item);
            map2.put(weight, (Object)stack);
            outputsList.add(stack);
        });
        this.lootStacksSorted = map2;
        this.lootStacksSortedSize = loot.items.size() > 48 || EMILoot.config.chestLootAlwaysStackSame ? this.lootStacksSorted.keySet().size() : loot.items.size();
        this.outputs = outputsList;
        String key = "emi_loot.chest." + loot.id.toString();
        if (!class_1074.method_4663((String)key)) {
            String[] chestPathTokens;
            StringBuilder chestName = new StringBuilder();
            for (String str : chestPathTokens = loot.id.method_12832().split("[/_]")) {
                if (LText.tablePrefixes.contains(str)) continue;
                if (!chestName.isEmpty()) {
                    chestName.append(" ");
                }
                if (str.length() <= 1) {
                    chestName.append(str);
                    continue;
                }
                chestName.append(str.substring(0, 1).toUpperCase()).append(str.substring(1));
            }
            if (EMILootAgnos.isModLoaded(loot.id.method_12836())) {
                rawTitle = LText.translatable("emi_loot.chest.unknown_chest", chestName.toString());
            } else {
                class_5250 unknown = LText.translatable("emi_loot.chest.unknown");
                rawTitle = LText.translatable("emi_loot.chest.unknown_chest", chestName.toString() + " " + unknown.getString());
            }
            if (EMILoot.config.isLogI18n(EMILoot.Type.CHEST)) {
                EMILoot.LOGGER.warn("Untranslated chest loot table \"{}\" (key: \"{}\")", (Object)loot.id, (Object)key);
            }
        } else {
            rawTitle = LText.translatable(key);
        }
        this.title = TrimmedTitle.of((class_2561)rawTitle, 138);
    }

    public EmiRecipeCategory getCategory() {
        return EmiClientPlugin.LOOT_CATEGORY;
    }

    @Nullable
    public class_2960 getId() {
        return class_2960.method_60655((String)"emi_loot", (String)("/" + this.getCategory().id.method_12832() + "/" + this.loot.id.method_12836() + "/" + this.loot.id.method_12832()));
    }

    public List<EmiIngredient> getInputs() {
        return new LinkedList<EmiIngredient>();
    }

    public List<EmiIngredient> getCatalysts() {
        return super.getCatalysts();
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public int getDisplayWidth() {
        return 144;
    }

    public int getDisplayHeight() {
        int titleHeight = 11;
        int boxesHeight = (int)Math.ceil((float)this.lootStacksSortedSize / 8.0f) * (EMILoot.config.isCompact(EMILoot.Type.CHEST) ? 18 : 19) - 1;
        return titleHeight + boxesHeight;
    }

    public void addWidgets(WidgetHolder widgets) {
        int finalRowHeight;
        int titleSpace;
        if (widgets.getHeight() < this.getDisplayHeight()) {
            titleSpace = 9;
            finalRowHeight = (widgets.getHeight() - titleSpace) / (int)Math.ceil((double)this.lootStacksSortedSize / 8.0);
        } else {
            titleSpace = 11;
            finalRowHeight = 18;
        }
        widgets.addText(this.title.title(), 1, 0, 0x404040, false);
        if (EMILootAgnos.isModLoaded(this.loot.id.method_12836())) {
            widgets.addTooltip(LText.components(this.title.rawTitle(), this.loot.id.method_12836()), 0, 0, 144, 10);
        } else {
            widgets.addTooltipText(List.of(this.title.rawTitle()), 0, 0, 144, 10);
        }
        AtomicInteger index = new AtomicInteger(this.lootStacksSortedSize);
        for (Map.Entry entry : this.lootStacksSorted.asMap().entrySet()) {
            float weight = ((Float)entry.getKey()).floatValue();
            Collection items = (Collection)entry.getValue();
            if (this.loot.items.size() <= 48 && !EMILoot.config.chestLootAlwaysStackSame) {
                for (EmiStack stack : items) {
                    int row = (int)Math.ceil((float)index.get() / 8.0f) - 1;
                    int column = (index.get() - 1) % 8;
                    index.getAndDecrement();
                    String fTrim = FloatTrimmer.trimFloatString(weight, (Integer)EMILoot.config.chanceDecimalPlaces.get());
                    SlotWidget slotWidget = new SlotWidget((EmiIngredient)stack, column * 18, titleSpace + row * finalRowHeight).recipeContext((EmiRecipe)this);
                    widgets.add((Widget)slotWidget.appendTooltip((class_2561)LText.translatable("emi_loot.percentage", fTrim)));
                }
                continue;
            }
            int row = (int)Math.ceil((float)index.get() / 8.0f) - 1;
            int column = (int)((float)(index.get() - 1) % 8.0f);
            index.getAndDecrement();
            EmiIngredient ingredient = EmiIngredient.of(items.stream().toList());
            String fTrim = FloatTrimmer.trimFloatString(Math.max(weight / 100.0f, 0.01f), Math.max((Integer)EMILoot.config.chanceDecimalPlaces.get() + 1, 2));
            SlotWidget slotWidget = new SlotWidget(ingredient, column * 18, titleSpace + row * finalRowHeight).recipeContext((EmiRecipe)this);
            widgets.add((Widget)slotWidget.appendTooltip((class_2561)LText.translatable("emi_loot.rolls", fTrim).method_27695(new class_124[]{class_124.field_1056, class_124.field_1065})));
        }
    }

    public boolean supportsRecipeTree() {
        return super.supportsRecipeTree() && this.isGuaranteedNonChance;
    }

    public boolean hideCraftable() {
        return super.hideCraftable();
    }
}

