/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.parser.processor;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.mixins.BoundedIntUnaryOperatorAccessor;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.util.LText;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2096;
import net.minecraft.class_40;
import net.minecraft.class_42;
import net.minecraft.class_44;
import net.minecraft.class_5250;
import net.minecraft.class_5657;
import net.minecraft.class_5658;
import net.minecraft.class_5659;
import net.minecraft.class_5660;
import net.minecraft.class_5662;

public class NumberProcessors {
    public static class_5250 processBoolean(Boolean input, String keyTrue, String keyFalse, Object ... args) {
        if (input != null) {
            if (input.booleanValue()) {
                return LText.translatable(keyTrue, args);
            }
            return LText.translatable(keyFalse, args);
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Boolean null for keys: " + keyTrue + " / " + keyFalse + " in table: " + LootTableParser.currentTable);
        }
        return LText.empty();
    }

    public static class_5250 processNumberRange(class_2096<?> range, String exact, String between, String atLeast, String atMost, String fallback, Object ... args) {
        if (!range.equals((Object)class_2096.class_2100.field_9708) && !range.equals((Object)class_2096.class_2099.field_9705)) {
            Optional max;
            Optional min = range.comp_1805();
            if (Objects.equals(min, max = range.comp_1806()) && min.isPresent()) {
                return LText.translatable(exact, min.get(), args);
            }
            if (min.isPresent() && max.isPresent()) {
                return LText.translatable(between, min.get(), max.get(), args);
            }
            if (min.isPresent()) {
                return LText.translatable(atLeast, min.get(), args);
            }
            if (max.isPresent()) {
                return LText.translatable(atMost, max.get(), args);
            }
            if (fallback.isEmpty()) {
                return LText.empty();
            }
            return LText.translatable(fallback);
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Non-specific number range for keys: " + exact + " / " + between + " in table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.predicate.invalid");
    }

    public static class_5250 processBoundedIntUnaryOperator(class_42 operator) {
        class_5658 min = ((BoundedIntUnaryOperatorAccessor)operator).getMin();
        class_5658 max = ((BoundedIntUnaryOperatorAccessor)operator).getMax();
        if (min != null && max != null) {
            float maxVal;
            float minVal;
            if (min.method_365() == class_5659.field_27921 && max.method_365() == class_5659.field_27921 && (minVal = ((class_44)min).comp_1895()) == (maxVal = ((class_44)max).comp_1895())) {
                return NumberProcessors.processLootNumberProvider(min);
            }
            return LText.translatable("emi_loot.operator.between", NumberProcessors.processLootNumberProvider(min), NumberProcessors.processLootNumberProvider(max));
        }
        if (min != null) {
            return LText.translatable("emi_loot.operator.min", NumberProcessors.processLootNumberProvider(min));
        }
        if (max != null) {
            return LText.translatable("emi_loot.operator.max", NumberProcessors.processLootNumberProvider(max));
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Null or undefined bounded int unary operator in table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.operator.unknown");
    }

    public static class_5250 processLootNumberProvider(class_5658 provider) {
        class_5657 type = provider.method_365();
        if (type == class_5659.field_27921) {
            return LText.translatable("emi_loot.number_provider.constant", Float.valueOf(((class_44)provider).comp_1895()));
        }
        if (type == class_5659.field_27923) {
            class_5658 n = ((class_40)provider).comp_1893();
            class_5658 p = ((class_40)provider).comp_1894();
            float nVal = NumberProcessors.getRollAvg(n);
            float pVal = NumberProcessors.getRollAvg(p);
            class_5250 nValText = NumberProcessors.processLootNumberProvider(n);
            class_5250 pValText = NumberProcessors.processLootNumberProvider(p);
            float avg = nVal * pVal;
            return LText.translatable("emi_loot.number_provider.binomial", nValText, pValText, Float.valueOf(avg));
        }
        if (type == class_5659.field_27922) {
            class_5658 min = ((class_5662)provider).comp_1900();
            class_5658 max = ((class_5662)provider).comp_1901();
            float minVal = NumberProcessors.getRollAvg(min);
            float maxVal = NumberProcessors.getRollAvg(max);
            class_5250 minValText = NumberProcessors.processLootNumberProvider(min);
            class_5250 maxValText = NumberProcessors.processLootNumberProvider(max);
            float avg = (minVal + maxVal) / 2.0f;
            return LText.translatable("emi_loot.number_provider.uniform", minValText, maxValText, Float.valueOf(avg));
        }
        if (type == class_5659.field_27924) {
            String lootScore = ((class_5660)provider).comp_1898();
            float lootScale = ((class_5660)provider).comp_1899();
            return LText.translatable("emi_loot.number_provider.score", lootScore, Float.valueOf(lootScale));
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Non-specific or undefined number provider in table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.number_provider.unknown");
    }

    public static float getRollAvg(class_5658 provider) {
        class_5657 type = provider.method_365();
        if (type == class_5659.field_27921) {
            return ((class_44)provider).comp_1895();
        }
        if (type == class_5659.field_27923) {
            class_5658 n = ((class_40)provider).comp_1893();
            class_5658 p = ((class_40)provider).comp_1894();
            float nVal = NumberProcessors.getRollAvg(n);
            float pVal = NumberProcessors.getRollAvg(p);
            return nVal * pVal;
        }
        if (type == class_5659.field_27922) {
            class_5658 min = ((class_5662)provider).comp_1900();
            class_5658 max = ((class_5662)provider).comp_1901();
            float minVal = NumberProcessors.getRollAvg(min);
            float maxVal = NumberProcessors.getRollAvg(max);
            return (minVal + maxVal) / 2.0f;
        }
        if (type == class_5659.field_27924) {
            return 0.0f;
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Loot number provider with unknown type: " + provider.method_365().toString());
        }
        return 0.0f;
    }
}

