/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.util;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.EMILootClientAgnos;
import fzzyhmstrs.emi_loot.client.ClientBuiltPool;
import fzzyhmstrs.emi_loot.util.ConditionalStack;
import fzzyhmstrs.emi_loot.util.FloatTrimmer;
import fzzyhmstrs.emi_loot.util.IconEmiWidget;
import fzzyhmstrs.emi_loot.util.LText;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3545;
import net.minecraft.class_5684;
import net.minecraft.class_757;

public abstract class IconGroupEmiWidget
extends Widget {
    private final List<IconEmiWidget> icons;
    private final List<SlotWidget> items;
    private final int x;
    private final int y;
    private final int iconsWidth;
    private final int itemsWidth;
    private final int width;
    private final Bounds bounds;

    public IconGroupEmiWidget(int x, int y, ClientBuiltPool pool) {
        this.x = x;
        this.y = y;
        LinkedList<IconEmiWidget> list = new LinkedList<IconEmiWidget>();
        for (int i = 0; i < pool.conditions().size(); ++i) {
            class_3545<Integer, class_2561> pair = pool.conditions().get(i);
            int xOffset = i / 2 * 11;
            int yOffset = i % 2 * 11;
            list.add(EMILootClientAgnos.createIconEmiWidget(x + xOffset, y + yOffset, (Integer)pair.method_15442(), (class_2561)pair.method_15441()));
        }
        this.icons = list;
        this.iconsWidth = 12 + (this.icons.size() - 1) / 2 * 11;
        this.itemsWidth = 2 + pool.stacks().size() * 20;
        this.width = this.iconsWidth + this.itemsWidth;
        this.bounds = new Bounds(x, y, this.width, 23);
        LinkedList<SlotWidget> list2 = new LinkedList<SlotWidget>();
        int itemXOffset = this.iconsWidth + 2;
        for (ConditionalStack entry : pool.stacks()) {
            String rounded = FloatTrimmer.trimFloatString(entry.weight(), (Integer)EMILoot.config.chanceDecimalPlaces.get());
            SlotWidget widget = new SlotWidget(entry.getIngredient(), itemXOffset + x, y + 3).appendTooltip((class_2561)LText.translatable("emi_loot.percent_chance", rounded));
            itemXOffset += 20;
            list2.add(widget);
        }
        this.items = list2;
    }

    public int getIconsWidth() {
        return this.iconsWidth;
    }

    public int getWidth() {
        return this.width;
    }

    public List<class_5684> getTooltip(int mouseX, int mouseY) {
        for (IconEmiWidget icon : this.icons) {
            if (!icon.getBounds().contains(mouseX, mouseY)) continue;
            return icon.getTooltip(mouseX, mouseY);
        }
        for (SlotWidget slot : this.items) {
            if (!slot.getBounds().contains(mouseX, mouseY)) continue;
            return slot.getTooltip(mouseX, mouseY);
        }
        return List.of();
    }

    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        for (SlotWidget slot : this.items) {
            if (!slot.getBounds().contains(mouseX, mouseY) || !slot.mouseClicked(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public Bounds getBounds() {
        return this.bounds;
    }

    public void renderInternal(class_332 draw, int mouseX, int mouseY, float delta) {
        int newWidth;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int widthRemaining = this.itemsWidth;
        int xNew = this.x + this.iconsWidth;
        do {
            newWidth = Math.min(64, widthRemaining);
            draw.method_25293(IconEmiWidget.FRAME_ID, xNew, this.y, newWidth, 1, 0.0f, 0.0f, newWidth, 1, 64, 16);
            xNew += newWidth;
        } while ((widthRemaining -= newWidth) > 0);
        draw.method_51739(class_1921.method_51784(), this.x, this.x + this.width, this.y, this.y + 1, 0x555555);
        for (IconEmiWidget icon : this.icons) {
            icon.method_25394(draw, mouseX, mouseY, delta);
        }
        for (SlotWidget slot : this.items) {
            this.renderSlot(slot, draw, mouseX, mouseY, delta);
        }
    }

    public void renderSlot(SlotWidget slot, class_332 draw, int mouseX, int mouseY, float delta) {
        RenderSystem.setShader(class_757::method_34542);
        draw.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        slot.drawBackground(draw, mouseX, mouseY, delta);
        slot.drawStack(draw, mouseX, mouseY, delta);
        RenderSystem.disableDepthTest();
        slot.drawOverlay(draw, mouseX, mouseY, delta);
    }
}

