/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.recipe.special;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;

public class EmiAnvilRepairItemRecipe
implements EmiRecipe {
    private final class_1792 tool;
    private final class_2960 id;
    private final int uniq = EmiUtil.RANDOM.nextInt();

    public EmiAnvilRepairItemRecipe(class_1792 tool, class_2960 id) {
        this.tool = tool;
        this.id = id;
    }

    @Override
    public EmiRecipeCategory getCategory() {
        return VanillaEmiRecipeCategories.ANVIL_REPAIRING;
    }

    @Override
    public class_2960 getId() {
        return this.id;
    }

    @Override
    public List<EmiIngredient> getInputs() {
        return List.of(EmiStack.of((class_1935)this.tool), EmiStack.of((class_1935)this.tool));
    }

    @Override
    public List<EmiStack> getOutputs() {
        return List.of(EmiStack.of((class_1935)this.tool));
    }

    @Override
    public boolean supportsRecipeTree() {
        return false;
    }

    @Override
    public int getDisplayWidth() {
        return 125;
    }

    @Override
    public int getDisplayHeight() {
        return 18;
    }

    @Override
    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(EmiTexture.PLUS, 27, 3);
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 75, 1);
        int notUniq = this.uniq;
        widgets.addGeneratedSlot(r -> this.getItem((Random)r, 0), notUniq, 0, 0);
        widgets.addGeneratedSlot(r -> this.getItem((Random)r, 1), notUniq, 49, 0);
        widgets.addGeneratedSlot(r -> this.getItem((Random)r, 2), notUniq, 107, 0).recipeContext(this);
    }

    protected EmiStack getItem(Random random, int item) {
        ArrayList items = Lists.newArrayList();
        items.add(this.getTool(random));
        items.add(this.getTool(random));
        items.add(this.getMergeItems(items));
        return EmiStack.of((class_1799)items.get(item));
    }

    private class_1799 getMergeItems(List<class_1799> items) {
        class_1799 item = this.tool.method_7854();
        int maxDamage = item.method_7936();
        int damage = items.get(0).method_7919() - 21 * maxDamage / 20 + items.get(1).method_7919();
        if (damage > 0) {
            item.method_7974(damage);
        }
        return item;
    }

    private class_1799 getTool(Random r) {
        class_1799 stack = this.tool.method_7854();
        if (stack.method_7936() <= 0) {
            return stack;
        }
        int d = r.nextInt(stack.method_7936());
        stack.method_7974(d);
        return stack;
    }
}

