/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiRegistryAdapter;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.config.IndexSource;
import dev.emi.emi.data.EmiData;
import dev.emi.emi.data.IndexStackData;
import dev.emi.emi.registry.EmiComparisonDefaults;
import dev.emi.emi.registry.EmiTags;
import dev.emi.emi.runtime.EmiHidden;
import dev.emi.emi.runtime.EmiLog;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7706;
import net.minecraft.class_9326;

public class EmiStackList {
    private static final class_6862<class_1792> ITEM_HIDDEN = class_6862.method_40092((class_5321)EmiPort.getItemRegistry().method_30517(), (class_2960)EmiTags.HIDDEN_FROM_RECIPE_VIEWERS);
    private static final class_6862<class_2248> BLOCK_HIDDEN = class_6862.method_40092((class_5321)EmiPort.getBlockRegistry().method_30517(), (class_2960)EmiTags.HIDDEN_FROM_RECIPE_VIEWERS);
    private static final class_6862<class_3611> FLUID_HIDDEN = class_6862.method_40092((class_5321)EmiPort.getFluidRegistry().method_30517(), (class_2960)EmiTags.HIDDEN_FROM_RECIPE_VIEWERS);
    public static List<Predicate<EmiStack>> invalidators = Lists.newArrayList();
    public static List<EmiStack> stacks = List.of();
    public static List<EmiStack> filteredStacks = List.of();
    private static Object2IntMap<EmiStack> strictIndices = new Object2IntOpenCustomHashMap((Hash.Strategy)new StrictHashStrategy());
    private static Object2IntMap<Object> keyIndices = new Object2IntOpenHashMap();

    public static void clear() {
        invalidators.clear();
        stacks = List.of();
        strictIndices.clear();
        keyIndices.clear();
    }

    public static void reload() {
        class_310 client = class_310.method_1551();
        class_1761.class_8128 context = new class_1761.class_8128(client.field_1724.field_3944.method_45735(), false, (class_7225.class_7874)client.field_1687.method_30349());
        ArrayList groups = Lists.newArrayList();
        LinkedHashMap<String, IndexGroup> namespaceGroups = new LinkedHashMap<String, IndexGroup>();
        for (Object item : EmiPort.getItemRegistry()) {
            String itemName = "null";
            try {
                itemName = item.toString();
                EmiStack stack = EmiStack.of((class_1935)item);
                namespaceGroups.computeIfAbsent(stack.getId().method_12836(), (Function<String, IndexGroup>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$reload$0(java.lang.String ), (Ljava/lang/String;)Ldev/emi/emi/registry/EmiStackList$IndexGroup;)()).stacks.add(stack);
            }
            catch (Exception e) {
                EmiLog.error("Item " + itemName + " threw while EMI was attempting to construct the index, items may be missing.");
                EmiLog.error(e);
            }
        }
        if (EmiConfig.indexSource != IndexSource.REGISTERED) {
            long groupReloadStart = System.currentTimeMillis();
            EmiLog.info("Reloading item groups on client thread...");
            Map itemGroupToStacksMap = (Map)client.method_5385(() -> {
                Reference2ReferenceOpenHashMap map = new Reference2ReferenceOpenHashMap();
                for (class_1761 group : class_7706.method_47341()) {
                    String groupName = "null";
                    try {
                        groupName = group.method_7737().toString();
                        group.method_47306(context);
                        map.put(group, group.method_45414());
                    }
                    catch (Exception e) {
                        EmiLog.error("Creative item group " + groupName + " threw while EMI was attempting to construct the index, items may be missing.");
                        EmiLog.error(e);
                    }
                }
                return map;
            }).join();
            EmiLog.info("Reloading item groups on client thread took " + (System.currentTimeMillis() - groupReloadStart) + "ms");
            for (class_1761 group : class_7706.method_47341()) {
                String groupName = "null";
                try {
                    groupName = group.method_7737().getString();
                    Object2IntOpenHashMap usedNamespaces = new Object2IntOpenHashMap();
                    IndexGroup ig = new IndexGroup();
                    Collection searchStacks = (Collection)itemGroupToStacksMap.get(group);
                    for (class_1799 stack : searchStacks) {
                        EmiStack es = EmiStack.of(stack);
                        String namespace = es.getId().method_12836();
                        usedNamespaces.put((Object)namespace, usedNamespaces.getOrDefault((Object)namespace, 0) + 1);
                        ig.stacks.add(es);
                    }
                    if (EmiConfig.indexSource == IndexSource.CREATIVE) {
                        for (String namespace : usedNamespaces.keySet()) {
                            if (!namespaceGroups.containsKey(namespace)) continue;
                            IndexGroup ng = (IndexGroup)namespaceGroups.get(namespace);
                            if (usedNamespaces.getInt((Object)namespace) * 3 < searchStacks.size() && usedNamespaces.getInt((Object)namespace) * 3 < ng.stacks.size()) continue;
                            ng.suppressedBy.add(ig);
                        }
                    }
                    groups.add(ig);
                }
                catch (Exception e) {
                    EmiLog.error("Creative item group " + groupName + " threw while EMI was attempting to construct the index, items may be missing.");
                    EmiLog.error(e);
                }
            }
        }
        groups.addAll(namespaceGroups.values());
        IndexGroup fluidGroup = new IndexGroup();
        for (class_3611 fluid : EmiPort.getFluidRegistry()) {
            String fluidName = null;
            try {
                class_3609 ff;
                fluidName = fluid.toString();
                if (!fluid.method_15793(fluid.method_15785()) && (!(fluid instanceof class_3609) || (ff = (class_3609)fluid).method_15751() != class_3612.field_15906)) continue;
                EmiStack fs = EmiStack.of(fluid);
                fluidGroup.stacks.add(fs);
            }
            catch (Exception e) {
                EmiLog.error("Fluid  " + fluidName + " threw while EMI was attempting to construct the index, stack may be missing.");
                EmiLog.error(e);
            }
        }
        groups.add(fluidGroup);
        ObjectOpenCustomHashSet added = new ObjectOpenCustomHashSet((Hash.Strategy)new StrictHashStrategy());
        stacks = Lists.newLinkedList();
        for (IndexGroup group : groups) {
            if (!group.shouldDisplay()) continue;
            for (EmiStack stack : group.stacks) {
                if (added.contains(stack)) continue;
                stacks.add(stack);
                added.add(stack);
            }
        }
    }

    private static <T> boolean isHiddenFromRecipeViewers(T key) {
        if (key instanceof class_1792) {
            class_1747 bi;
            class_1792 i = (class_1792)key;
            if (i instanceof class_1747 && (bi = (class_1747)i).method_7711().method_9564().method_26164(BLOCK_HIDDEN)) {
                return true;
            }
            if (i.method_40131().method_40220(ITEM_HIDDEN)) {
                return true;
            }
        } else if (key instanceof class_3611) {
            class_3611 f = (class_3611)key;
            if (f.method_15791(FLUID_HIDDEN)) {
                return true;
            }
        } else {
            EmiRegistryAdapter<?> adapter = EmiTags.ADAPTERS_BY_CLASS.get(key.getClass());
            if (adapter != null) {
                return adapter.getRegistry().method_47983(key).method_40220(class_6862.method_40092((class_5321)adapter.getRegistry().method_30517(), (class_2960)EmiTags.HIDDEN_FROM_RECIPE_VIEWERS));
            }
        }
        return false;
    }

    public static void bake() {
        stacks.removeIf(s -> {
            try {
                if (s.isEmpty()) {
                    return true;
                }
                for (Predicate<EmiStack> invalidator : invalidators) {
                    if (!invalidator.test((EmiStack)s)) continue;
                    return true;
                }
                return EmiStackList.isHiddenFromRecipeViewers(s.getKey());
            }
            catch (Throwable t) {
                EmiLog.error("Stack threw error while baking");
                t.printStackTrace();
                return true;
            }
        });
        for (Supplier<IndexStackData> supplier : EmiData.stackData) {
            IndexStackData ssd = supplier.get();
            if (!ssd.removed().isEmpty()) {
                HashSet removed = Sets.newHashSet();
                for (EmiIngredient invalidator : ssd.removed()) {
                    for (EmiStack stack2 : invalidator.getEmiStacks()) {
                        removed.add(stack2.copy().comparison(c -> EmiPort.compareStrict()));
                    }
                }
                stacks.removeAll(removed);
            }
            if (!ssd.filters().isEmpty()) {
                stacks.removeIf(s -> {
                    String id = String.valueOf(s.getId());
                    for (IndexStackData.Filter filter : ssd.filters()) {
                        if (!filter.filter().test(id)) continue;
                        return true;
                    }
                    return false;
                });
            }
            for (IndexStackData.Added added : ssd.added()) {
                if (added.added().isEmpty()) continue;
                if (added.after().isEmpty()) {
                    stacks.add(added.added().getEmiStacks().get(0));
                    continue;
                }
                int i = stacks.indexOf(added.after());
                if (i == -1) {
                    i = stacks.size() - 1;
                }
                stacks.add(i + 1, added.added().getEmiStacks().get(0));
            }
        }
        stacks = stacks.stream().filter(stack -> {
            String name = "Unknown";
            String id = "unknown";
            try {
                if (stack.isEmpty()) {
                    return false;
                }
                name = stack.toString();
                id = stack.getId().toString();
                if (name != null && stack.getKey() != null && stack.getName() != null) {
                    return true;
                }
                EmiLog.warn("Hiding stack " + name + " with id " + id + " from index due to returning dangerous values");
                return false;
            }
            catch (Throwable t) {
                EmiLog.warn("Hiding stack " + name + " with id " + id + " from index due to throwing errors");
                t.printStackTrace();
                return false;
            }
        }).toList();
        for (int i = 0; i < stacks.size(); ++i) {
            EmiStack stack3 = stacks.get(i);
            strictIndices.put((Object)stack3, i);
            keyIndices.put(stack3.getKey(), i);
        }
        EmiStackList.bakeFiltered();
    }

    public static void bakeFiltered() {
        filteredStacks = stacks.stream().filter(s -> !EmiHidden.isDisabled(s) && !EmiHidden.isHidden(s)).toList();
    }

    public static int getIndex(EmiIngredient ingredient) {
        EmiStack stack = ingredient.getEmiStacks().get(0);
        int ret = strictIndices.getOrDefault((Object)stack, Integer.MAX_VALUE);
        if (ret == Integer.MAX_VALUE) {
            ret = keyIndices.getOrDefault((Object)stack, ret);
        }
        return ret;
    }

    private static /* synthetic */ IndexGroup lambda$reload$0(String k) {
        return new IndexGroup();
    }

    public static class IndexGroup {
        public List<EmiStack> stacks = Lists.newArrayList();
        public Set<IndexGroup> suppressedBy = Sets.newHashSet();

        public boolean shouldDisplay() {
            for (IndexGroup suppressor : this.suppressedBy) {
                if (!suppressor.shouldDisplay()) continue;
                return false;
            }
            return true;
        }
    }

    public static class StrictHashStrategy
    implements Hash.Strategy<EmiStack> {
        public boolean equals(EmiStack a, EmiStack b) {
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            if (a.isEmpty() && b.isEmpty()) {
                return true;
            }
            return a.isEqual(b, EmiPort.compareStrict());
        }

        public int hashCode(EmiStack stack) {
            if (stack != null) {
                class_9326 changes = stack.getComponentChanges();
                int i = 31 + stack.getKey().hashCode();
                return 31 * i + changes.hashCode();
            }
            return 0;
        }
    }

    public static class ComparisonHashStrategy
    implements Hash.Strategy<EmiStack> {
        public boolean equals(EmiStack a, EmiStack b) {
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            if (a.isEmpty() && b.isEmpty()) {
                return true;
            }
            return a.isEqual(b, EmiComparisonDefaults.get(a.getKey()));
        }

        public int hashCode(EmiStack stack) {
            if (stack != null) {
                int i = 31 + stack.getKey().hashCode();
                return 31 * i + EmiComparisonDefaults.get(stack.getKey()).getHash(stack);
            }
            return 0;
        }
    }
}

