/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.io.nbt;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import journeymap.client.JourneymapClient;
import journeymap.client.io.FileHandler;
import journeymap.client.io.RegionImageHandler;
import journeymap.client.model.MapType;
import journeymap.client.model.RegionCoord;
import journeymap.client.model.RegionImageCache;
import journeymap.common.Journeymap;
import journeymap.common.nbt.RegionDataStorageHandler;
import net.minecraft.class_1923;
import net.minecraft.class_310;
import org.apache.logging.log4j.Logger;

public class RegionLoader {
    private static final Pattern anvilPattern = Pattern.compile("r\\.([^\\.]+)\\.([^\\.]+)\\.mca");
    final Logger logger = Journeymap.getLogger();
    final MapType mapType;
    private Stack<RegionCoord> regions;
    private int regionsFound = 0;

    public RegionLoader(class_310 minecraft, MapType mapType, boolean all) throws IOException {
        this.mapType = mapType;
        this.findRegions(minecraft, mapType, all);
    }

    public static File getRegionFile(class_310 minecraft, int dimension, int chunkX, int chunkZ) {
        File regionDir = new File(FileHandler.getWorldSaveDir(minecraft), "region");
        File regionFile = new File(regionDir, String.format("r.%s.%s.mca", chunkX >> 5, chunkZ >> 5));
        return regionFile;
    }

    public static File getRegionFile(class_310 minecraft, int chunkX, int chunkZ) {
        File regionDir = new File(FileHandler.getWorldSaveDir(minecraft), "region");
        File regionFile = new File(regionDir, String.format("r.%s.%s.mca", chunkX >> 5, chunkZ >> 5));
        return regionFile;
    }

    public Stack<RegionCoord> getRegions() {
        return Objects.requireNonNullElseGet(this.regions, Stack::new);
    }

    public int getRegionsFound() {
        return this.regionsFound;
    }

    public boolean isUnderground() {
        return this.mapType.isUnderground();
    }

    public Integer getVSlice() {
        return this.mapType.vSlice;
    }

    private void findRegions(class_310 mc, MapType mapType, boolean all) {
        File mcWorldDir = FileHandler.getMCWorldDir(mc, mapType.dimension);
        File regionDir = new File(mcWorldDir, "region");
        if (!regionDir.exists() && !regionDir.mkdirs()) {
            this.logger.warn("MC world region directory isn't usable: {}", (Object)regionDir);
            return;
        }
        RegionImageCache.INSTANCE.flushToDisk(false);
        RegionImageCache.INSTANCE.clear();
        File jmImageWorldDir = FileHandler.getJMWorldDir(mc);
        RegionCoord playerRc = RegionCoord.fromChunkPos(jmImageWorldDir, mapType, mc.field_1724.method_31476().field_9181, mc.field_1724.method_31476().field_9180);
        int validFileCount = 0;
        int existingImageCount = 0;
        File[] anvilFiles = regionDir.listFiles();
        if (anvilFiles == null || anvilFiles.length < 1) {
            this.logger.warn("No region files found in MC world region directory: {}", (Object)regionDir);
            return;
        }
        this.regions = new Stack();
        block2: for (File anvilFile : anvilFiles) {
            try {
                Matcher matcher = anvilPattern.matcher(anvilFile.getName());
                if (anvilFile.isDirectory() || !matcher.matches()) continue;
                ++validFileCount;
                String x = matcher.group(1);
                String z = matcher.group(2);
                if (x == null || z == null) continue;
                RegionCoord rc = new RegionCoord(jmImageWorldDir, Integer.parseInt(x), Integer.parseInt(z), mapType.dimension);
                if (all) {
                    this.regions.add(rc);
                    ++this.regionsFound;
                    continue;
                }
                boolean fullRegion = false;
                Boolean cacheEnabled = JourneymapClient.getInstance().getCoreProperties().dataCachingEnabled.get();
                boolean hasFile = RegionImageHandler.getRegionImageFile(rc, mapType).exists();
                if (cacheEnabled.booleanValue() && hasFile) {
                    fullRegion = new RegionDataStorageHandler().getRegionData(new RegionDataStorageHandler.Key(rc, mapType)).isFullRegion();
                }
                if (!hasFile || cacheEnabled.booleanValue() && !fullRegion) {
                    List<class_1923> chunkCoords = rc.getChunkCoordsInRegion();
                    for (class_1923 coord : chunkCoords) {
                        if (!mc.field_1687.method_8393(coord.field_9181, coord.field_9180)) continue;
                        this.regions.add(rc);
                        ++this.regionsFound;
                        continue block2;
                    }
                    continue;
                }
                ++existingImageCount;
            }
            catch (Throwable t) {
                this.logger.warn("Error processing Region File {}, skipping!", (Object)anvilFile.getName(), (Object)t);
            }
        }
        if (this.regions.isEmpty() && validFileCount != existingImageCount) {
            this.logger.warn("Anvil region files in " + String.valueOf(regionDir) + ": " + validFileCount + ", matching image files: " + existingImageCount + ", but found nothing to do for mapType " + String.valueOf(mapType));
        }
        this.regions.remove(playerRc);
        this.regions.sort(RegionCoord.getComparator());
        this.regions.add(playerRc);
    }

    public MapType getMapType() {
        return this.mapType;
    }
}

