/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.properties;

import journeymap.api.v2.client.event.InfoSlotDisplayEvent;
import journeymap.client.properties.ClientCategory;
import journeymap.client.properties.InGameMapProperties;
import journeymap.client.ui.minimap.Orientation;
import journeymap.client.ui.minimap.Position;
import journeymap.client.ui.minimap.ReticleOrientation;
import journeymap.client.ui.minimap.Shape;
import journeymap.client.ui.option.MapTypeProvider;
import journeymap.client.ui.option.TimeFormat;
import journeymap.client.ui.theme.ThemeLabelSource;
import journeymap.common.properties.PropertiesBase;
import journeymap.common.properties.catagory.Category;
import journeymap.common.properties.config.BooleanField;
import journeymap.common.properties.config.EnumField;
import journeymap.common.properties.config.FloatField;
import journeymap.common.properties.config.IntegerField;
import journeymap.common.properties.config.StringField;
import journeymap.common.properties.config.custom.MinimapCaveLayerIntField;
import net.minecraft.class_310;

public class MiniMapProperties
extends InGameMapProperties {
    public final BooleanField enabled = new BooleanField(Category.Inherit, "jm.minimap.enable_minimap", true, true, 1);
    public final BooleanField showDayNight = new BooleanField(Category.Inherit, "jm.common.show_day_night", true, 5);
    public final StringField minimapLockedMapType = new StringField(Category.Inherit, "jm.minimap.map_type", MapTypeProvider.ANY.key(), MapTypeProvider.class, 150);
    public final IntegerField caveLayer = new MinimapCaveLayerIntField(Category.Inherit, "jm.minimap.cave_slice.slider", -4, 15, 4, 1, 151);
    public final StringField info1Label = new StringField(Category.Inherit, "jm.minimap.info1_label.button", ThemeLabelSource.Blank.getKey(), ThemeLabelSource.class, 126);
    public final EnumField<InfoSlotDisplayEvent.Position> info1LabelPosition = new EnumField<InfoSlotDisplayEvent.Position>(Category.Inherit, "jm.minimap.info1_label.position", InfoSlotDisplayEvent.Position.Top, 127);
    public final StringField info2Label = new StringField(Category.Inherit, "jm.minimap.info2_label.button", ThemeLabelSource.GameTime.getKey(), ThemeLabelSource.class, 128);
    public final EnumField<InfoSlotDisplayEvent.Position> info2LabelPosition = new EnumField<InfoSlotDisplayEvent.Position>(Category.Inherit, "jm.minimap.info2_label.position", InfoSlotDisplayEvent.Position.Top, 129);
    public final StringField info3Label = new StringField(Category.Inherit, "jm.minimap.info3_label.button", ThemeLabelSource.Location.getKey(), ThemeLabelSource.class, 130);
    public final EnumField<InfoSlotDisplayEvent.Position> info3LabelPosition = new EnumField<InfoSlotDisplayEvent.Position>(Category.Inherit, "jm.minimap.info3_label.position", InfoSlotDisplayEvent.Position.Bottom, 131);
    public final StringField info4Label = new StringField(Category.Inherit, "jm.minimap.info4_label.button", ThemeLabelSource.Biome.getKey(), ThemeLabelSource.class, 132);
    public final EnumField<InfoSlotDisplayEvent.Position> info4LabelPosition = new EnumField<InfoSlotDisplayEvent.Position>(Category.Inherit, "jm.minimap.info4_label.position", InfoSlotDisplayEvent.Position.Bottom, 132);
    public final FloatField infoSlotAlpha = new FloatField(Category.Inherit, "jm.minimap.info_slot.background_alpha", 0.0f, 1.0f, 0.7f, 145);
    public final FloatField infoSlotFontScale = new FloatField(Category.Inherit, "jm.minimap.info_slot.font_scale", 0.5f, 5.0f, 1.0f, 125);
    public final StringField infoSlotTimeFormat = new StringField(Category.Inherit, "jm.common.time_format", TimeFormat.Provider.class, 146);
    public final StringField systemTimeRealFormat = new StringField(Category.Inherit, "jm.common.system_time_format", TimeFormat.Provider.class, 147);
    public final EnumField<ReticleOrientation> reticleOrientation = new EnumField<ReticleOrientation>(Category.Inherit, "jm.minimap.reticle_orientation", ReticleOrientation.Compass, 186);
    public final EnumField<Shape> shape = new EnumField<Shape>(Category.Inherit, "jm.minimap.shape", Shape.Circle, 180);
    public final IntegerField sizePercent = new IntegerField(Category.Inherit, "jm.minimap.size", 1, 100, 30, 205);
    public final IntegerField frameAlpha = new IntegerField(Category.Inherit, "jm.minimap.frame_alpha", 0, 100, 100, 190);
    public final IntegerField terrainAlpha = new IntegerField(Category.Inherit, "jm.minimap.terrain_alpha", 0, 100, 100, 195);
    public final FloatField backgroundAlpha = new FloatField(Category.Inherit, "jm.minimap.terrain_background_alpha", 0.0f, 1.0f, 0.8f, 200);
    public final EnumField<Orientation> orientation = new EnumField<Orientation>(Category.Inherit, "jm.minimap.orientation.button", Orientation.North, 185);
    public final FloatField compassFontScale = new FloatField(Category.Inherit, "jm.minimap.compass_font_scale", 0.5f, 4.0f, 1.0f, 120);
    public final BooleanField showCompass = new BooleanField(Category.Inherit, "jm.minimap.show_compass", true, 10);
    public final BooleanField showReticle = new BooleanField(Category.Inherit, "jm.minimap.show_reticle", true, 15);
    public final FloatField positionX = new FloatField(Category.Hidden, "jm.minimap.position_x", 0.0f, 1.0f, 0.9f);
    public final FloatField positionY = new FloatField(Category.Hidden, "jm.minimap.position_y", 0.0f, 1.0f, 0.25f);
    public final BooleanField moveEffectIcons = new BooleanField(ClientCategory.MinimapPosition, "jm.hud.effects.enable", true);
    public final IntegerField effectTranslateX = new IntegerField(Category.Hidden, "jm.hud.effects.location.button", -10000, 0, 0);
    public final IntegerField effectTranslateY = new IntegerField(Category.Hidden, "jm.hud.effects.location.button", 0, 10000, 0);
    public final BooleanField effectVertical = new BooleanField(ClientCategory.MinimapPosition, "jm.hud.effects.style.vertical", false);
    public final BooleanField effectReversed = new BooleanField(ClientCategory.MinimapPosition, "jm.hud.effects.style.reverse", false);
    public final FloatField minimapKeyMovementSpeed = new FloatField(ClientCategory.MinimapPosition, "jm.hud.minimap.key_movement_speed", 0.001f, 0.025f, 0.001f, 0.001f, 3);
    public final EnumField<Position> position = new EnumField<Position>(ClientCategory.MinimapPosition, "jm.minimap.position", Position.TopRight);
    protected final transient int id;
    protected boolean active = false;

    public MiniMapProperties(int id) {
        this.id = id;
        super.setPropertiesId(id);
    }

    @Override
    public String getName() {
        return String.format("minimap%s", this.id > 1 ? Integer.valueOf(this.id) : "");
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        if (this.active != active) {
            this.active = active;
            this.save();
        }
    }

    public int getId() {
        return this.id;
    }

    @Override
    public <T extends PropertiesBase> void updateFrom(T otherInstance) {
        super.updateFrom(otherInstance);
        if (otherInstance instanceof MiniMapProperties) {
            this.setActive(((MiniMapProperties)otherInstance).isActive());
        }
    }

    public int getSize() {
        return (int)Math.max(128.0, Math.floor((double)this.sizePercent.get().intValue() / 100.0 * (double)class_310.method_1551().method_22683().method_4507()));
    }

    @Override
    protected void postLoad(boolean isNew) {
        super.postLoad(isNew);
        if (isNew) {
            if (this.getId() == 1) {
                this.setActive(true);
                if (class_310.method_1551() != null && class_310.method_1551().field_1772.method_1726()) {
                    this.fontScale.set(Float.valueOf(2.0f));
                    this.infoSlotFontScale.set(Float.valueOf(2.0f));
                    this.compassFontScale.set(Float.valueOf(2.0f));
                }
            } else {
                this.setActive(false);
                this.positionX.set(Float.valueOf(90.0f));
                this.positionY.set(Float.valueOf(25.0f));
                this.position.set(Position.TopRight);
                this.shape.set(Shape.Rectangle);
                this.frameAlpha.set((Object)100);
                this.terrainAlpha.set((Object)100);
                this.orientation.set(Orientation.North);
                this.reticleOrientation.set(ReticleOrientation.Compass);
                this.sizePercent.set((Object)30);
                if (class_310.method_1551() != null && class_310.method_1551().field_1772.method_1726()) {
                    this.fontScale.set(Float.valueOf(2.0f));
                    this.infoSlotFontScale.set(Float.valueOf(2.0f));
                    this.compassFontScale.set(Float.valueOf(2.0f));
                }
            }
        }
    }
}

