/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.task.main;

import com.mojang.blaze3d.platform.TextureUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import journeymap.client.JourneymapClient;
import journeymap.client.task.main.IMainThreadTask;
import journeymap.client.task.main.MappingMonitorTask;
import journeymap.client.texture.ImageUtil;
import journeymap.common.Journeymap;
import net.minecraft.class_1043;
import net.minecraft.class_310;
import org.apache.logging.log4j.Logger;
import org.lwjgl.glfw.GLFW;

public class ExpireTextureTask
implements IMainThreadTask {
    private static final int MAX_FAILS = 5;
    private static String NAME = "Tick." + MappingMonitorTask.class.getSimpleName();
    private static Logger LOGGER = Journeymap.getLogger();
    private final List<class_1043> textures;
    private final int textureId;
    private volatile int fails;

    private ExpireTextureTask(int textureId) {
        this.textures = null;
        this.textureId = textureId;
    }

    private ExpireTextureTask(class_1043 texture) {
        this.textures = new ArrayList<class_1043>();
        this.textures.add(texture);
        this.textureId = -1;
    }

    private ExpireTextureTask(Collection<class_1043> textureCollection) {
        this.textures = new ArrayList<class_1043>(textureCollection);
        this.textureId = -1;
    }

    public static void queue(int textureId) {
        if (textureId != -1) {
            JourneymapClient.getInstance().queueMainThreadTask(new ExpireTextureTask(textureId));
        }
    }

    public static void queue(class_1043 texture) {
        JourneymapClient.getInstance().queueMainThreadTask(new ExpireTextureTask(texture));
    }

    public static void queue(Collection<class_1043> textureCollection) {
        JourneymapClient.getInstance().queueMainThreadTask(new ExpireTextureTask(textureCollection));
    }

    @Override
    public IMainThreadTask perform(class_310 mc, JourneymapClient jm) {
        boolean success = this.deleteTextures();
        if (!success && this.textures != null && !this.textures.isEmpty()) {
            ++this.fails;
            LOGGER.warn("ExpireTextureTask.perform() couldn't delete textures: " + String.valueOf(this.textures) + ", fails: " + this.fails);
            if (this.fails <= 5) {
                return this;
            }
        }
        return null;
    }

    private boolean deleteTextures() {
        if (this.textureId != -1) {
            return this.deleteTexture(this.textureId);
        }
        ListIterator<class_1043> iter = this.textures.listIterator();
        while (iter.hasNext()) {
            class_1043 texture = (class_1043)iter.next();
            if (texture == null) {
                iter.remove();
                continue;
            }
            if (!this.deleteTexture(texture)) break;
            iter.remove();
        }
        return this.textures.isEmpty();
    }

    private boolean deleteTexture(class_1043 texture) {
        boolean success = false;
        if (texture.method_4624() != -1) {
            try {
                texture.method_4528();
                ImageUtil.closeSafely(texture.method_4525());
                success = true;
            }
            catch (Exception t) {
                LOGGER.warn("Couldn't delete texture " + String.valueOf(texture) + ": " + String.valueOf(t));
            }
        } else {
            ImageUtil.closeSafely(texture.method_4525());
            success = true;
        }
        return success;
    }

    private boolean deleteTexture(int textureId) {
        try {
            if (GLFW.glfwGetCurrentContext() == class_310.method_1551().method_22683().method_4490()) {
                TextureUtil.releaseTextureId((int)textureId);
                return true;
            }
        }
        catch (Exception t) {
            LOGGER.warn("Couldn't delete textureId " + textureId + ": " + String.valueOf(t));
        }
        return false;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

