/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypointmanager.group;

import java.awt.Color;
import journeymap.api.common.waypoint.WaypointFactoryImpl;
import journeymap.api.services.EventBus;
import journeymap.api.v2.client.util.tuple.Tuple2;
import journeymap.api.v2.common.event.common.WaypointGroupEvent;
import journeymap.api.v2.common.waypoint.WaypointGroup;
import journeymap.client.Constants;
import journeymap.client.ui.component.TextBox;
import journeymap.client.ui.component.buttons.CheckBox;
import journeymap.client.ui.component.popupscreenbutton.PopupButton;
import journeymap.client.ui.component.popupscreenbutton.PopupButtonScreen;
import journeymap.client.ui.component.popupscreenbutton.colorpicker.ColorPickerButton;
import journeymap.client.ui.component.popupscreenbutton.colorpicker.ColorPickerScreen;
import journeymap.client.ui.waypointmanager.group.DeleteConfirmGroupPopup;
import journeymap.common.waypoint.WaypointGroupStore;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_7843;
import net.minecraft.class_7847;
import net.minecraft.class_7919;
import net.minecraft.class_7940;
import net.minecraft.class_8021;
import net.minecraft.class_8030;
import net.minecraft.class_8667;

public class EditGroupPopup
extends PopupButtonScreen<WaypointGroup> {
    private final class_8667 layout = class_8667.method_52741();
    private TextBox textBox;
    protected static Integer defaultGroupColor = new Color(20, 20, 20).getRGB();
    private final WaypointGroup group;
    private boolean closeOnDelete = false;
    private Integer color;
    private Boolean colorOverride;
    private boolean isNew = false;
    private boolean enabled = true;

    public EditGroupPopup(class_2561 title, WaypointGroup group) {
        super(title);
        this.group = group;
        this.colorOverride = group.colorOverride();
    }

    public EditGroupPopup(class_2561 title) {
        this(title, WaypointFactoryImpl.instance.createWaypointGroup(""));
        this.isNew = true;
    }

    protected void method_25426() {
        this.textBox = new TextBox(this.group.getName(), this.field_22793, 120, 20);
        CheckBox colorOverride = new CheckBox(Constants.getString("jm.waypoint.edit_group.color_override"), this.group.colorOverride(), this::setColorOverride);
        colorOverride.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"jm.waypoint.edit_group.color_override.tooltip")));
        this.layout.method_52735(12).method_52740().method_46467();
        this.layout.method_52736((class_8021)new class_7940((class_2561)this.field_22785.method_27661().method_27692(class_124.field_1067), this.field_22793).method_48984(150).method_48981(true));
        if (this.group.isLocked() || WaypointGroupStore.DEFAULT.getGuid().equals(this.group.getGuid())) {
            this.textBox.method_1888(false);
            class_7940 locked = (class_7940)this.layout.method_52736((class_8021)new class_7940((class_2561)class_2561.method_43471((String)"jm.waypoint.edit_group.locked").method_27661().method_27692(class_124.field_1061), this.field_22793).method_48984(150).method_48981(true));
            locked.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"jm.waypoint.edit_group.locked.tooltip")));
        } else {
            this.method_48265((class_364)this.textBox);
        }
        this.layout.method_52736((class_8021)this.enabledCheckbox());
        class_8667 colors = class_8667.method_52742();
        colors.method_52735(6);
        Integer initGroupColor = this.group.getColor() == null ? defaultGroupColor : this.group.getColor();
        colors.method_52736((class_8021)new ColorPickerButton(20, 20, () -> initGroupColor, this::setColor));
        colors.method_52738((class_8021)colorOverride, class_7847::method_46474);
        class_8667 bottomButtons = class_8667.method_52742();
        bottomButtons.method_52735(6);
        PopupButton deleteButton = (PopupButton)bottomButtons.method_52736(new PopupButton<Tuple2>(this.field_22793.method_1727(Constants.getString("jm.common.delete")) + 10, 0, Constants.getString("jm.common.delete"), () -> new DeleteConfirmGroupPopup(this.group), this::deleteGroup));
        deleteButton.setEnabled(!this.group.getGuid().equals(WaypointGroupStore.DEFAULT.getGuid()) && !this.group.isLocked() && !this.isNew);
        bottomButtons.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"jm.waypoint.save"), b -> this.save()).method_46432(this.field_22793.method_27525((class_5348)class_5244.field_41873) + 10).method_46431());
        bottomButtons.method_52736((class_8021)class_4185.method_46430((class_2561)class_5244.field_24335, b -> super.method_25419()).method_46432(this.field_22793.method_27525((class_5348)class_5244.field_24335) + 10).method_46431());
        this.layout.method_52736((class_8021)((TextBox)class_8667.method_52742().method_52736((class_8021)this.textBox)));
        this.layout.method_52736((class_8021)colors);
        this.layout.method_52736((class_8021)bottomButtons);
        this.layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.method_48640();
    }

    private void deleteGroup(Tuple2<Boolean, Boolean> tuple) {
        EventBus.post(new WaypointGroupEvent(this.group, WaypointGroupEvent.Context.DELETED, ((Boolean)tuple.a()).booleanValue()));
        this.closeOnDelete = true;
        super.method_25419();
    }

    private void setColorOverride(class_4185 button) {
        this.colorOverride = ((CheckBox)button).getToggled();
    }

    private void setColor(ColorPickerScreen.ColorPickerResponse colorPickerResponse) {
        if (!colorPickerResponse.canceled()) {
            this.color = colorPickerResponse.color();
        }
    }

    protected void renderPopupScreen(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderPopupScreen(graphics, mouseX, mouseY, partialTicks);
        if (this.minecraft.field_1755 == this && this.closeOnDelete) {
            this.method_25419();
        }
    }

    public void renderPopupScreenBackground(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_52752(guiGraphics);
        guiGraphics.method_52706(BACKGROUND_SPRITE, this.layout.method_46426() - 18, this.layout.method_46427() - 18, this.layout.method_25368() + 36, this.layout.method_25364() + 36);
    }

    private CheckBox enabledCheckbox() {
        boolean enabled = this.group == null || this.group.isEnabled();
        return new CheckBox(Constants.getString("jm.common.enabled"), enabled, button -> this.setEnabled(((CheckBox)button).getToggled()));
    }

    private void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257) {
            this.save();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private void save() {
        String name = this.textBox.method_1882();
        if (!name.isEmpty()) {
            this.group.setName(name);
            this.group.setEnabled(this.enabled);
            if (this.colorOverride != null) {
                this.group.setColorOverride(this.colorOverride.booleanValue());
                if (this.color != null && this.colorOverride.booleanValue()) {
                    this.group.setColor(this.color);
                }
            }
            this.setResponseAndClose(this.group);
        }
    }

    @Override
    protected void onClosed() {
        if (this.onClose != null) {
            super.onClosed();
        } else {
            EventBus.post(new WaypointGroupEvent(this.group, WaypointGroupEvent.Context.UPDATE));
        }
        super.method_25419();
    }

    protected void method_48640() {
        this.layout.method_48222();
        class_7843.method_48634((class_8021)this.layout, (class_8030)this.method_48202());
    }
}

