/*
 * Decompiled with CFR 0.152.
 */
package com.boyonk.musicsync;

import com.boyonk.musicsync.network.packet.c2s.play.MusicTrackerUpdateC2SPacket;
import com.boyonk.musicsync.network.packet.s2c.play.PlayMusicS2CPacket;
import com.boyonk.musicsync.network.packet.s2c.play.StopMusicS2CPacket;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_5195;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class ServerMusicTracker {
    private static final TrackerData DEFAULT_TRACKING_DATA = new TrackerData(){

        @Override
        public Optional<class_5195> type() {
            return Optional.empty();
        }

        @Override
        public boolean playing() {
            return false;
        }
    };
    public static final int DEFAULT_TIME_UNTIL_NEXT_SONG = 100;
    private final MinecraftServer server;
    private final Map<class_3222, TrackerData> trackerData = new HashMap<class_3222, TrackerData>();
    @Nullable
    private class_6880<class_3414> current;
    private int timeUntilNextSong = 100;
    private final class_5819 random = class_5819.method_43047();
    private boolean enabled = true;

    public ServerMusicTracker(MinecraftServer server) {
        this.server = server;
    }

    public void tick() {
        if (!this.enabled) {
            if (!this.trackerData.isEmpty()) {
                this.trackerData.clear();
            }
            return;
        }
        if (!this.refreshPlayers()) {
            return;
        }
        class_5195 type = this.getMusicType();
        if (type == null) {
            return;
        }
        if (this.current != null) {
            if (!type.method_27279().method_40230().equals(this.current.method_40230()) && type.method_27282()) {
                this.stop(class_3532.method_15395((class_5819)this.random, (int)0, (int)(type.method_27280() / 2)));
            }
            if (!this.isPlaying()) {
                this.stop(Math.min(this.timeUntilNextSong, class_3532.method_15395((class_5819)this.random, (int)type.method_27280(), (int)type.method_27281())));
            }
        }
        this.timeUntilNextSong = Math.min(this.timeUntilNextSong, type.method_27281());
        --this.timeUntilNextSong;
        if (this.current == null && this.timeUntilNextSong <= 0) {
            this.play(type);
        }
    }

    public void enable() {
        if (!this.enabled) {
            this.enabled = true;
        }
    }

    public void disable() {
        if (this.enabled) {
            this.enabled = false;
        }
    }

    protected void stop() {
        this.stop(100);
    }

    public void stop(int timeUntilNextSong) {
        this.timeUntilNextSong = timeUntilNextSong;
        if (this.current != null) {
            StopMusicS2CPacket packet = new StopMusicS2CPacket();
            this.server.method_3760().method_14571().forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_8710)packet));
            this.current = null;
        }
    }

    protected void play(class_5195 type) {
        this.timeUntilNextSong = Integer.MAX_VALUE;
        this.current = type.method_27279();
        PlayMusicS2CPacket packet = new PlayMusicS2CPacket(this.current, this.random.method_43055());
        this.server.method_3760().method_14571().forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_8710)packet));
    }

    protected boolean refreshPlayers() {
        HashSet currentPlayers = new HashSet(this.server.method_3760().method_14571());
        boolean anyPlayers = !currentPlayers.isEmpty();
        Set<class_3222> trackedPlayers = this.trackerData.keySet();
        if (currentPlayers.equals(trackedPlayers)) {
            return anyPlayers;
        }
        List<class_3222> toAdd = currentPlayers.stream().filter(player -> !trackedPlayers.contains(player)).toList();
        List<class_3222> toRemove = trackedPlayers.stream().filter(player -> !currentPlayers.contains(player)).toList();
        toAdd.forEach(player -> this.trackerData.put((class_3222)player, DEFAULT_TRACKING_DATA));
        toRemove.forEach(this.trackerData::remove);
        return anyPlayers;
    }

    @Nullable
    protected class_5195 getMusicType() {
        List<class_5195> types = this.trackerData.values().stream().map(TrackerData::type).filter(Optional::isPresent).map(Optional::get).toList();
        if (types.isEmpty()) {
            return null;
        }
        List<class_5195> shouldReplaceTypes = types.stream().filter(class_5195::method_27282).toList();
        if (!shouldReplaceTypes.isEmpty()) {
            return shouldReplaceTypes.get(this.random.method_43048(shouldReplaceTypes.size()));
        }
        return types.get(this.random.method_43048(types.size()));
    }

    protected boolean isPlaying() {
        return !this.trackerData.isEmpty() && this.trackerData.values().stream().anyMatch(TrackerData::playing);
    }

    public void onUpdate(MusicTrackerUpdateC2SPacket packet, class_3222 player) {
        this.trackerData.put(player, packet);
    }

    public static interface TrackerData {
        public Optional<class_5195> type();

        public boolean playing();
    }
}

