/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting;

import java.util.Arrays;
import net.caffeinemc.mods.sodium.api.util.NormI8;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class TQuad {
    private static final int QUANTIZATION_FACTOR = 4;
    private ModelQuadFacing facing;
    private final float[] extents;
    private final int packedNormal;
    private float dotProduct;
    private Vector3fc center;
    private Vector3fc quantizedNormal;

    private TQuad(ModelQuadFacing facing, float[] extents, Vector3fc center, int packedNormal) {
        this.facing = facing;
        this.extents = extents;
        this.center = center;
        this.packedNormal = packedNormal;
        if (this.facing.isAligned()) {
            this.dotProduct = TQuad.getAlignedDotProduct(this.facing, this.extents);
        } else {
            float normX = NormI8.unpackX(this.packedNormal);
            float normY = NormI8.unpackY(this.packedNormal);
            float normZ = NormI8.unpackZ(this.packedNormal);
            this.dotProduct = this.getCenter().dot(normX, normY, normZ);
        }
    }

    private static float getAlignedDotProduct(ModelQuadFacing facing, float[] extents) {
        return extents[facing.ordinal()] * (float)facing.getSign();
    }

    static TQuad fromAligned(ModelQuadFacing facing, float[] extents, Vector3fc center) {
        return new TQuad(facing, extents, center, ModelQuadFacing.PACKED_ALIGNED_NORMALS[facing.ordinal()]);
    }

    static TQuad fromUnaligned(ModelQuadFacing facing, float[] extents, Vector3fc center, int packedNormal) {
        return new TQuad(facing, extents, center, packedNormal);
    }

    public ModelQuadFacing getFacing() {
        return this.facing;
    }

    public ModelQuadFacing useQuantizedFacing() {
        if (!this.facing.isAligned()) {
            this.getQuantizedNormal();
            this.facing = ModelQuadFacing.fromNormal(this.quantizedNormal.x(), this.quantizedNormal.y(), this.quantizedNormal.z());
            this.dotProduct = this.facing.isAligned() ? TQuad.getAlignedDotProduct(this.facing, this.extents) : this.getCenter().dot(this.quantizedNormal);
        }
        return this.facing;
    }

    public float[] getExtents() {
        return this.extents;
    }

    public Vector3fc getCenter() {
        if (this.center == null) {
            this.center = new Vector3f((this.extents[0] + this.extents[3]) / 2.0f, (this.extents[1] + this.extents[4]) / 2.0f, (this.extents[2] + this.extents[5]) / 2.0f);
        }
        return this.center;
    }

    public float getDotProduct() {
        return this.dotProduct;
    }

    public int getPackedNormal() {
        return this.packedNormal;
    }

    public Vector3fc getQuantizedNormal() {
        if (this.quantizedNormal == null) {
            if (this.facing.isAligned()) {
                this.quantizedNormal = this.facing.getAlignedNormal();
            } else {
                this.computeQuantizedNormal();
            }
        }
        return this.quantizedNormal;
    }

    private void computeQuantizedNormal() {
        float normX = NormI8.unpackX(this.packedNormal);
        float normY = NormI8.unpackY(this.packedNormal);
        float normZ = NormI8.unpackZ(this.packedNormal);
        float infNormLength = Math.max(Math.abs(normX), Math.max(Math.abs(normY), Math.abs(normZ)));
        if (infNormLength != 0.0f && infNormLength != 1.0f) {
            normX /= infNormLength;
            normY /= infNormLength;
            normZ /= infNormLength;
        }
        Vector3f normal = new Vector3f((float)((int)(normX * 4.0f)), (float)((int)(normY * 4.0f)), (float)((int)(normZ * 4.0f)));
        normal.normalize();
        this.quantizedNormal = normal;
    }

    int getQuadHash() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.extents);
        result = this.facing.isAligned() ? 31 * result + this.facing.hashCode() : 31 * result + this.packedNormal;
        result = 31 * result + Float.hashCode(this.dotProduct);
        return result;
    }

    public boolean extentsEqual(float[] other) {
        return TQuad.extentsEqual(this.extents, other);
    }

    public static boolean extentsEqual(float[] a, float[] b) {
        for (int i = 0; i < 6; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean extentsIntersect(float[] extentsA, float[] extentsB) {
        for (int axis = 0; axis < 3; ++axis) {
            int opposite = axis + 3;
            if (!(extentsA[axis] <= extentsB[opposite]) && !(extentsB[axis] <= extentsA[opposite])) continue;
            return false;
        }
        return true;
    }

    public static boolean extentsIntersect(TQuad a, TQuad b) {
        return TQuad.extentsIntersect(a.extents, b.extents);
    }
}

