/*
 * Decompiled with CFR 0.152.
 */
package de.pnku.mcrv.block;

import com.google.common.annotations.VisibleForTesting;
import de.pnku.mcrv.block.MoreCrafterVariantBlock;
import de.pnku.mcrv.init.McrvBlockInit;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1662;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_3919;
import net.minecraft.class_7225;
import net.minecraft.class_8566;
import net.minecraft.class_8881;
import org.jetbrains.annotations.NotNull;

public class MoreCrafterVariantBlockEntity
extends class_2621
implements class_3908,
class_8566 {
    public static final int CONTAINER_WIDTH = 3;
    public static final int CONTAINER_HEIGHT = 3;
    public static final int SLOT_DISABLED = 1;
    public static final int SLOT_ENABLED = 0;
    public static final int CONTAINER_SIZE = 9;
    public static final int DATA_TRIGGERED = 9;
    public static final int NUM_DATA = 10;
    private class_2371<class_1799> items = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
    private int craftingTicksRemaining = 0;
    protected final class_3913 mcrvContainerData = new class_3919(this, 10){
        private final int[] slotStates = new int[9];
        private int triggered = 0;

        public int method_17390(int index) {
            return index == 9 ? this.triggered : this.slotStates[index];
        }

        public void method_17391(int index, int value) {
            if (index == 9) {
                this.triggered = value;
            } else {
                this.slotStates[index] = value;
            }
        }

        public int method_17389() {
            return 10;
        }
    };

    public MoreCrafterVariantBlockEntity(class_2338 pos, class_2680 state) {
        super(McrvBlockInit.MORE_CRAFTER_VARIANT_BLOCK_ENTITY, pos, state);
    }

    @NotNull
    protected class_2561 method_17823() {
        return class_2561.method_43471((String)("container.quad-lolmcrv." + this.getBlock().crafterWoodType + "_crafter"));
    }

    protected MoreCrafterVariantBlock getBlock() {
        return (MoreCrafterVariantBlock)this.method_11010().method_26204();
    }

    @NotNull
    public class_1703 method_5465(int containerId, class_1661 inventory) {
        return new class_8881(containerId, inventory, (class_8566)this, this.mcrvContainerData);
    }

    public void setSlotState(int slot, boolean state) {
        if (this.slotCanBeDisabled(slot)) {
            this.mcrvContainerData.method_17391(slot, state ? 0 : 1);
            this.method_5431();
        }
    }

    public boolean isSlotDisabled(int slot) {
        if (slot >= 0 && slot < 9) {
            return this.mcrvContainerData.method_17390(slot) == 1;
        }
        return false;
    }

    public boolean method_5437(int slot, class_1799 stack) {
        if (this.mcrvContainerData.method_17390(slot) == 1) {
            return false;
        }
        class_1799 itemStack = (class_1799)this.items.get(slot);
        int i = itemStack.method_7947();
        if (i >= itemStack.method_7914()) {
            return false;
        }
        if (itemStack.method_7960()) {
            return true;
        }
        return !this.smallerStackExist(i, itemStack, slot);
    }

    private boolean smallerStackExist(int currentSize, class_1799 stack, int slot) {
        for (int i = slot + 1; i < 9; ++i) {
            class_1799 itemStack;
            if (this.isSlotDisabled(i) || !(itemStack = this.method_5438(i)).method_7960() && (itemStack.method_7947() >= currentSize || !class_1799.method_31577((class_1799)itemStack, (class_1799)stack))) continue;
            return true;
        }
        return false;
    }

    public void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        this.craftingTicksRemaining = tag.method_10550("variant_crafting_ticks_remaining");
        this.items = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        if (!this.method_54871(tag)) {
            class_1262.method_5429((class_2487)tag, this.items, (class_7225.class_7874)registries);
        }
        int[] is = tag.method_10561("variant_disabled_slots");
        for (int i = 0; i < 9; ++i) {
            this.mcrvContainerData.method_17391(i, 0);
        }
        int[] var8 = is;
        int var5 = is.length;
        for (int var6 = 0; var6 < var5; ++var6) {
            int j = var8[var6];
            if (!this.slotCanBeDisabled(j)) continue;
            this.mcrvContainerData.method_17391(j, 1);
        }
        this.mcrvContainerData.method_17391(9, tag.method_10550("variant_triggered"));
    }

    public void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        tag.method_10569("variant_crafting_ticks_remaining", this.craftingTicksRemaining);
        if (!this.method_54872(tag)) {
            class_1262.method_5426((class_2487)tag, this.items, (class_7225.class_7874)registries);
        }
        this.addDisabledSlots(tag);
        this.addTriggered(tag);
    }

    private void addTriggered(class_2487 tag) {
        tag.method_10569("variant_triggered", this.mcrvContainerData.method_17390(9));
    }

    public int method_5439() {
        return 9;
    }

    public boolean method_5442() {
        class_1799 itemStack;
        Iterator var1 = this.items.iterator();
        do {
            if (var1.hasNext()) continue;
            return true;
        } while ((itemStack = (class_1799)var1.next()).method_7960());
        return false;
    }

    @NotNull
    public class_1799 method_5438(int slot) {
        return (class_1799)this.items.get(slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        if (this.isSlotDisabled(slot)) {
            this.setSlotState(slot, true);
        }
        super.method_5447(slot, stack);
    }

    public boolean method_5443(class_1657 player) {
        return class_1263.method_49105((class_2586)this, (class_1657)player);
    }

    @NotNull
    public class_2371<class_1799> method_11282() {
        return this.items;
    }

    protected void method_11281(class_2371<class_1799> items) {
        this.items = items;
    }

    public int method_17398() {
        return 3;
    }

    public int method_17397() {
        return 3;
    }

    public void method_7683(class_1662 contents) {
        for (class_1799 itemStack : this.items) {
            contents.method_7404(itemStack);
        }
    }

    public void addDisabledSlots(class_2487 tag) {
        IntArrayList intList = new IntArrayList();
        for (int index = 0; index < 9; ++index) {
            if (!this.isSlotDisabled(index)) continue;
            intList.add(index);
        }
        tag.method_10572("variant_disabled_slots", (List)intList);
    }

    public void setTriggered(boolean triggered) {
        this.mcrvContainerData.method_17391(9, triggered ? 1 : 0);
    }

    @VisibleForTesting
    public boolean isTriggered() {
        return this.mcrvContainerData.method_17390(9) == 1;
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, MoreCrafterVariantBlockEntity crafter) {
        int i = crafter.craftingTicksRemaining - 1;
        if (i >= 0) {
            crafter.craftingTicksRemaining = i;
            if (i == 0) {
                level.method_8652(pos, (class_2680)state.method_11657((class_2769)MoreCrafterVariantBlock.CRAFTING, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
    }

    public void setCraftingTicksRemaining(int craftingTicksRemaining) {
        this.craftingTicksRemaining = craftingTicksRemaining;
    }

    public int getRedstoneSignal() {
        int i = 0;
        for (int j = 0; j < this.method_5439(); ++j) {
            class_1799 itemStack = this.method_5438(j);
            if (itemStack.method_7960() && !this.isSlotDisabled(j)) continue;
            ++i;
        }
        return i;
    }

    public boolean slotCanBeDisabled(int slot) {
        return slot > -1 && slot < 9 && ((class_1799)this.items.get(slot)).method_7960();
    }
}

