/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftfr.roleplaychat;

import java.util.Arrays;
import java.util.List;
import net.minecraft.class_3222;
import net.minecraftfr.roleplaychat.chatTypeMessage.ActionMessage;
import net.minecraftfr.roleplaychat.chatTypeMessage.GlobalOOCMessage;
import net.minecraftfr.roleplaychat.chatTypeMessage.MessageType;
import net.minecraftfr.roleplaychat.chatTypeMessage.OOCMessage;
import net.minecraftfr.roleplaychat.chatTypeMessage.ShoutMessage;
import net.minecraftfr.roleplaychat.chatTypeMessage.SpeakMessage;
import net.minecraftfr.roleplaychat.chatTypeMessage.WhisperMessage;
import org.joml.Math;

public class ChatManager {
    public boolean handleChatMessage(class_3222 player, String message) {
        List<MessageType> messageTypes = Arrays.asList(new ShoutMessage(message), new WhisperMessage(message), new ActionMessage(message), new OOCMessage(message), new GlobalOOCMessage(message));
        for (MessageType type : messageTypes) {
            if (!type.canBeSend()) continue;
            this.sendLocalMessage(player, type);
            return false;
        }
        SpeakMessage speakMessage = new SpeakMessage(message);
        this.sendLocalMessage(player, speakMessage);
        return false;
    }

    private void sendLocalMessage(class_3222 player, MessageType messageType) {
        ChatManager.sendMessageToPlayerListFromPosition(player, player.method_51469().method_18456(), messageType);
    }

    public static void sendMessageToPlayerListFromPosition(class_3222 sender, List<class_3222> players, MessageType messageType) {
        int radius = messageType.getRadius();
        players.forEach(otherPlayer -> {
            int distance = (int)Math.round((double)sender.method_19538().method_1022(otherPlayer.method_19538()));
            if (radius == 0 || distance <= radius) {
                messageType.setDistance(distance);
                messageType.sendMessage(sender, (class_3222)otherPlayer);
            }
        });
    }
}

