/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftfr.roleplaychat.chatTypeMessage;

import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5251;

public abstract class MessageType {
    protected String message;
    protected int radius;
    protected int color;
    protected String character;
    protected String command;
    protected Integer distance;

    public MessageType(String message, int radius, int color, String character) {
        this.message = message;
        this.radius = radius;
        this.color = color;
        this.character = character;
    }

    public int getRadius() {
        return this.radius;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean canBeSend() {
        return this.message.startsWith(this.character);
    }

    public class_5250 formatMessage(class_3222 player) {
        String contentMessage = this.formatContentMessage(player);
        return class_2561.method_43470((String)contentMessage).method_27694(style -> style.method_27703(class_5251.method_27717((int)this.getFadedColor())));
    }

    public String formatContentMessage(class_3222 player) {
        return this.getChatName(player) + " " + this.message.substring(1).trim();
    }

    public void sendMessage(class_3222 sender, class_3222 receiver) {
        receiver.method_7353((class_2561)this.formatMessage(sender), false);
    }

    public void setDistance(int distance) {
        this.distance = distance;
    }

    protected String getChatName(class_3222 player) {
        return "<" + player.method_5477().getString() + ">";
    }

    protected int getDistance() {
        return this.distance;
    }

    protected int getFadedColor() {
        if (this.distance == null) {
            return this.color;
        }
        int maxDistance = this.radius;
        float fadeFactor = Math.min((float)this.distance.intValue() / (float)maxDistance, 1.0f);
        int red = (int)((double)(this.color >> 16 & 0xFF) * (1.0 - (double)fadeFactor));
        int green = (int)((double)(this.color >> 8 & 0xFF) * (1.0 - (double)fadeFactor));
        int blue = (int)((double)(this.color & 0xFF) * (1.0 - (double)fadeFactor));
        int fadedColor = red << 16 | green << 8 | blue;
        return fadedColor;
    }
}

